<?php

class ControllerToolSync extends HController {
    private $db3;
    protected function getAlias() {
        return 'tool/sync';
    }

    protected function init() {
        $this->data['lang'] = $this->load->language($this->getAlias());
        $this->document->setTitle($this->data['lang']['heading_title']);
        $this->data['token'] = $this->session->data['token'];
    }

    protected function getList() {
        parent::getList();
        //This sync needs to be run on BM Server.
        $tables[] = array(
            'direction'=>'in',
            'query_type'=>'update',
            'table_name'=>'employee',
            'primary_key'=>'employee_id',
            'columns' => array('employee_id','company_id','employee_image','employee_code','title_first_name','first_name','title_middle_name','middle_name','surname','full_name','its_no','gender','marital_status','mobile_no','phone_no','email','qualification_id','employee_category_id','city','area','nationality','cnic_expiry','nicop_no','nicop_name','nicop_expiry','nicop_address','passport_no','passport_name','passport_expiry','passport_address')
        );
        $tables[] = array(
            'direction'=>'in',
            'query_type'=>'update/insert_ignore',
            'table_name'=>'employee_family',
            'primary_key'=>'employee_family_id',
            'columns' => array('*')
        );
        $tables[] = array(
            'direction'=>'in',
            'query_type'=>'update/insert_ignore',
            'table_name'=>'employee_qualification',
            'primary_key'=>'employee_qualification_id',
            'columns' => array('*')
        );

        $start_date = date('Y-m-d', strtotime('-2 month'));
        $end_date = date('Y-m-d', strtotime('+1 month'));
        $tables[] = array(
            'direction'=>'out',
            'query_type'=>'update/insert_ignore',
            'table_name'=>'employee_leave',
            'primary_key'=>'employee_leave_id',
            'columns' => array('*'),
            'filter' => "`status` IN ('Approved','Rejected') AND ((`leave_from` >= '$start_date' AND `leave_from` <= '$end_date') OR (`leave_to` >= '$start_date' AND `leave_to` <= '$end_date'))"
        );

        $tables[] = array(
            'direction'=>'in',
            'query_type'=>'update/insert_ignore',
            'table_name'=>'employee_leave',
            'primary_key'=>'employee_leave_id',
            'columns' => array('*'),
            'filter' => "`status` IN ('Approved','Requested') AND ((`leave_from` >= '$start_date' AND `leave_from` <= '$end_date') OR (`leave_to` >= '$start_date' AND `leave_to` <= '$end_date'))"
        );
        $tables[] = array(
            'direction'=>'out',
            'query_type'=>'update/insert_ignore',
            'table_name'=>'company',
            'primary_key'=>'company_id',
            'columns' => array('*'),
        );
        $tables[] = array(
            'direction'=>'out',
            'query_type'=>'update/insert_ignore',
            'table_name'=>'company_allowance_policy',
            'primary_key'=>'company_allowance_policy_id',
            'columns' => array('*'),
        );
        $tables[] = array(
            'direction'=>'out',
            'query_type'=>'update/insert_ignore',
            'table_name'=>'department',
            'primary_key'=>'department_id',
            'columns' => array('*'),
        );
        $tables[] = array(
            'direction'=>'out',
            'query_type'=>'update/insert_ignore',
            'table_name'=>'department_allowance_policy',
            'primary_key'=>'department_allowance_policy_id',
            'columns' => array('*'),
        );
        $tables[] = array(
            'direction'=>'out',
            'query_type'=>'update',
            'table_name'=>'special_allowance',
            'primary_key'=>'special_allowance_id',
            'columns' => array('special_allowance_id','approved_status','approved_amount','is_post', 'post_at','post_by_id','modified_at','modified_by_id'),
            'filter' => "fiscal_year_id ='".$this->session->data['fiscal_year_id']."' AND `approved_status` IN ('Approved','Rejected')"
        );
        $tables[] = array(
            'direction'=>'out',
            'query_type'=>'update',
            'table_name'=>'special_allowance_detail',
            'view_name'=>'vw_special_allowance_detail',
            'primary_key'=>'special_allowance_detail_id',
            'columns' => array('special_allowance_detail_id','special_allowance_id','sort_order','allowance_for','employee_family_id','school_id','class_id','special_allowance_category_id','period_start_date','period_end_date','amount','remarks','receipt_date','receipt_no','approved_amount','policy_on','policy_value','policy_amount'),
            'filter' => "fiscal_year_id ='".$this->session->data['fiscal_year_id']."' AND `approved_status` IN ('Approved','Rejected')"
        );
        $tables[] = array(
            'direction'=>'in',
            'query_type'=>'update/insert_ignore',
            'table_name'=>'special_allowance',
            'primary_key'=>'special_allowance_id',
            'columns' => array('company_id','special_allowance_id','fiscal_year_id','document_date','document_no','document_identity','special_allowance_type_id','employee_registration_id','registration_code','file_name','file_directory','is_taxable','total_amount','approved_amount','approved_status','created_at','created_by_id','modified_at','modified_by_id'),
            'filter' => array('fiscal_year_id' => $this->session->data['fiscal_year_id'],'approved_status' => 'Requested')
        );

        $tables[] = array(
            'direction'=>'in',
            'query_type'=>'update/insert_ignore',
            'table_name'=>'special_allowance_detail',
            'view_name'=>'vw_special_allowance_detail',
            'primary_key'=>'special_allowance_detail_id',
            'columns' => array('special_allowance_detail_id','special_allowance_id','sort_order','allowance_for','employee_family_id','school_id','class_id','special_allowance_category_id','period_start_date','period_end_date','amount','approved_amount','remarks','receipt_date','receipt_no'),
            'filter' => array('fiscal_year_id' => $this->session->data['fiscal_year_id'],'approved_status' => 'Requested')
        );

        $tables[] = array(
            'direction'=>'out',
            'query_type'=>'insert_ignore',
            'table_name'=>'employee',
            'primary_key'=>'employee_id',
            'columns' => array('employee_id','login_id','login_password','company_id','employee_image','employee_code','title_first_name','first_name','title_middle_name','middle_name','surname','full_name','its_no','dob','gender','marital_status','mobile_no','phone_no','email','qualification_id','employee_category_id','city','area','nationality','cnic_no','cnic_expiry','cnic_address','nicop_no','nicop_name','nicop_expiry','nicop_address','passport_no','passport_name','passport_expiry','passport_address','eobi_no','eobi_date','eobi_sno','ntn_no','probation_from','probation_to','created_at','created_by_id')
        );

        $tables[] = array(
            'direction'=>'out',
            'query_type'=>'update',
            'table_name'=>'employee',
            'primary_key'=>'employee_id',
            'columns' => array('employee_id','login_id','login_password','employee_code','dob','cnic_no', 'cnic_name', 'cnic_address','eobi_no','eobi_date','eobi_sno','ntn_no')
        );

        $tables[] = array(
            'direction'=>'out',
            'query_type'=>'insert_ignore',
            'table_name'=>'employee_registration',
            'primary_key'=>'employee_registration_id',
            'columns' => array('*')
        );
        $tables[] = array(
            'direction'=>'out',
            'query_type'=>'update',
            'table_name'=>'employee_registration',
            'primary_key'=>'employee_registration_id',
            'columns' => array('*')
        );
        $tables[] = array(
            'direction'=>'out',
            'query_type'=>'insert_ignore',
            'table_name'=>'special_allowance_category',
            'primary_key'=>'special_allowance_category_id',
            'columns' => array('*')
        );
        $tables[] = array(
            'direction'=>'out',
            'query_type'=>'insert_ignore',
            'table_name'=>'employee_allowance_policy',
            'primary_key'=>'employee_allowance_policy_id',
            'columns' => array('*')
        );
        $tables[] = array(
            'direction'=>'out',
            'query_type'=>'update/insert_ignore',
            'table_name'=>'school',
            'primary_key'=>'school_id',
            'columns' => array('*')
        );
        $tables[] = array(
            'direction'=>'out',
            'query_type'=>'update/insert_ignore',
            'table_name'=>'class',
            'primary_key'=>'class_id',
            'columns' => array('*')
        );
        $tables[] = array(
            'direction'=>'out',
            'query_type'=>'update/insert_ignore',
            'table_name'=>'section',
            'primary_key'=>'section_id',
            'columns' => array('*')
        );
        $tables[] = array(
            'direction'=>'out',
            'query_type'=>'update/insert_ignore',
            'table_name'=>'qualification',
            'primary_key'=>'qualification_id',
            'columns' => array('*')
        );
        $tables[] = array(
            'direction'=>'out',
            'query_type'=>'update/insert_ignore',
            'table_name'=>'designation',
            'primary_key'=>'designation_id',
            'columns' => array('*')
        );
        $tables[] = array(
            'direction'=>'out',
            'query_type'=>'update/insert_ignore',
            'table_name'=>'employee_category',
            'primary_key'=>'employee_category_id',
            'columns' => array('*')
        );
        $tables[] = array(
            'direction'=>'out',
            'query_type'=>'update/insert_ignore',
            'table_name'=>'bank',
            'primary_key'=>'bank_id',
            'columns' => array('*')
        );
        $tables[] = array(
            'direction'=>'out',
            'query_type'=>'update/insert_ignore',
            'table_name'=>'attendance_shift',
            'primary_key'=>'attendance_shift_id',
            'columns' => array('*'),
            'filter' => "(`created_at` >= '".date('Y-m-d', strtotime('-2 month'))." 00:00:00' or `modified_at` >= '".date('Y-m-d', strtotime('-2 month'))." 00:00:00')"
        );
        $tables[] = array(
            'direction'=>'out',
            'query_type'=>'update/insert_ignore',
            'table_name'=>'attendance_shift_detail',
            'primary_key'=>'attendance_shift_detail_id',
            'columns' => array('*'),
            'filter' => "(`created_at` >= '".date('Y-m-d', strtotime('-2 month'))." 00:00:00' or `modified_at` >= '".date('Y-m-d', strtotime('-2 month'))." 00:00:00')"
        );
        $tables[] = array(
            'direction'=>'out',
            'query_type'=>'update/insert_ignore',
            'table_name'=>'holiday',
            'primary_key'=>'holiday_id',
            'columns' => array('*')
        );
        $tables[] = array(
            'direction'=>'out',
            'query_type'=>'update/insert_ignore',
            'table_name'=>'special_allowance_category',
            'primary_key'=>'special_allowance_category_id',
            'columns' => array('*')
        );
        $tables[] = array(
            'direction'=>'out',
            'query_type'=>'update/insert_ignore',
            'table_name'=>'allowance',
            'primary_key'=>'allowance_id',
            'columns' => array('*')
        );
        $tables[] = array(
            'direction'=>'out',
            'query_type'=>'update/insert_ignore',
            'table_name'=>'deduction',
            'primary_key'=>'deduction_id',
            'columns' => array('*')
        );
        $tables[] = array(
            'direction'=>'out',
            'query_type'=>'update/insert_ignore',
            'table_name'=>'tax_slab',
            'primary_key'=>'tax_slab_id',
            'columns' => array('*')
        );

        $tables[] = array(
            'direction'=>'out',
            'query_type'=>'update/insert_ignore',
            'table_name'=>'employee_attendance',
            'primary_key'=>'employee_attendance_id',
            'columns' => array('*'),
            'filter' => "(`created_at` >= '".date('Y-m-d', strtotime('-2 month'))." 00:00:00' or `modified_at` >= '".date('Y-m-d', strtotime('-2 month'))." 00:00:00')"
        );

        $this->data['tables'] = $tables;
        $this->data['href_sync_database'] = $this->url->link('tool/sync/syncDatabase', 'token=' . $this->session->data['token'], 'SSL');
        $this->template = $this->getAlias() . '.tpl';
        $this->response->setOutput($this->render());
    }

    public function syncDatabase() {
        ini_set('max_execution_time','0');
        $info = $this->request->post;
        $records = 0;

        $this->db3 = new DB('dbmysqli', '172.18.238.201', 'root', 'BM786921105253', 'dhk_payroll','3306');
        //$this->db3 = new DB('dbmysqli', '14.192.149.179', 'root', 'BM786921105253', 'dhk_payroll','3307');
        //$this->db3 = new DB('dbmysqli', '14.192.149.179', 'root', 'BM786921105253', 'test_payroll','3307');

        $query_type = explode('/',$info['query_type']);
        foreach($query_type as $type) {
            if($type=='update') {
                $records = $this->UpdateRecords($info);
            } elseif($type=='insert_ignore') {
                $records = $this->InsertIgnoreRecords($info);
            }
        }
        $json = array (
            'success' => true,
            'post' => $info,
            'records' => $records,
            'query_type' => $query_type,
        );

        echo json_encode($json);
    }


    private function UpdateRecords($table_info) {
        $this->model['sync'] = $this->load->model('tool/sync');
        if($table_info['direction']=='in') {
            $sql = "SELECT ".implode(',',$table_info['columns']);
            $sql .= " FROM `".(isset($table_info['view_name'])?$table_info['view_name']:$table_info['table_name'])."`";
            if(isset($table_info['filter'])) {
                $filter = $table_info['filter'];
                if(is_array($filter)) {
                    $implode = array();
                    foreach($filter as $column => $value) {
                        $implode[] = "`$column`='$value'";
                    }
                    if($implode)
                        $sql .= " WHERE " . implode(" AND ", $implode);
                } else {
                    $sql .= " WHERE " . html_entity_decode($filter);
                }
            }
            $query = $this->db3->query($sql);
            $rows = $query->rows;
            $records = $query->num_rows;

            $this->model['sync']->setTable($table_info['table_name']);
            foreach($rows as $row) {
                $id = $this->model['sync']->edit($this->getAlias(), $row[$table_info['primary_key']], $row);

                $log = new Log('sync_'.date('Ymd').'.txt');
                $log->write('IN:'.$table_info['table_name'].' - '.json_encode($row));
            }
        } elseif($table_info['direction']=='out') {
            $this->model['sync']->setTable($table_info['table_name']);
            $sql = "SELECT ".implode(',',$table_info['columns']);
            if(isset($table_info['view_name'])) {
                $sql .= " FROM `".$table_info['view_name']."`";
            } else {
                $sql .= " FROM `".$table_info['table_name']."`";
            }
            if(isset($table_info['filter'])) {
                $filter = $table_info['filter'];
                if(is_array($filter)) {
                    $implode = array();
                    foreach($filter as $column => $value) {
                        $implode[] = "`$column`='$value'";
                    }
                    if($implode)
                        $sql .= " WHERE " . implode(" AND ", $implode);
                } else {
                    $sql .= " WHERE " . html_entity_decode($filter);
                }
            }
            $query = $this->db->query($sql);
            $rows = $query->rows;
            $records = count($rows);
            foreach($rows as $row) {
                $sql = $this->model['sync']->getUpdateSql($table_info['table_name'], $table_info['primary_key'], $row);
                $this->db3->query($sql);

                $log = new Log('sync_'.date('Ymd').'.txt');
                $log->write('OUT:'.$table_info['table_name'].' - '.$sql);
            }
        }
        //d($con, true);
        return $records;
    }

    private function InsertIgnoreRecords($table_info) {
        $this->model['sync'] = $this->load->model('tool/sync');
        if($table_info['direction']=='in') {
            $sql = "SELECT ".implode(',',$table_info['columns']);
            $sql .= " FROM `".(isset($table_info['view_name'])?$table_info['view_name']:$table_info['table_name'])."`";
            if(isset($table_info['filter'])) {
                $filter = $table_info['filter'];
                if(is_array($filter)) {
                    $implode = array();
                    foreach($filter as $column => $value) {
                        $implode[] = "`$column`='$value'";
                    }
                    if($implode)
                        $sql .= " WHERE " . implode(" AND ", $implode);
                } else {
                    $sql .= " WHERE " . html_entity_decode($filter);
                }
            }
            $query = $this->db3->query($sql);
            $rows = $query->rows;
            $records = $query->num_rows;

            $this->model['sync']->setTable($table_info['table_name']);
            foreach($rows as $row) {
                $id = $this->model['sync']->insertIgnore($table_info['table_name'], $row);

                $log = new Log('sync_'.date('Ymd').'.txt');
                $log->write('IN:'.$table_info['table_name'].' - '.json_encode($row));
            }
        } elseif($table_info['direction']=='out') {
            $sql = "SELECT ".implode(',',$table_info['columns']);
            $sql .= " FROM `".$table_info['table_name']."`";
            if(isset($table_info['filter'])) {
                $filter = $table_info['filter'];
                if(is_array($filter)) {
                    $implode = array();
                    foreach($filter as $column => $value) {
                        $implode[] = "`$column`='$value'";
                    }
                    if($implode)
                        $sql .= " WHERE " . implode(" AND ", $implode);
                } else {
                    $sql .= " WHERE " . html_entity_decode($filter);
                }
            }
            $query = $this->db->query($sql);
            $rows = $query->rows;
            $records = $query->num_rows;

            if(in_array($table_info['table_name'], array('special_allowance_category', 'company_allowance_policy','department_allowance_policy','employee_allowance_policy'))) {
                $sql = "TRUNCATE TABLE `".$table_info['table_name']."`";
                $this->db3->query($sql);
            }
            $this->model['sync']->setTable($table_info['table_name']);
            foreach($rows as $row) {
                $sql = $this->model['sync']->GetInsertIgnore($table_info['table_name'], $row);
                $this->db3->query($sql);

                $log = new Log('sync_'.date('Ymd').'.txt');
                $log->write('OUT:'.$table_info['table_name'].' - '.$sql);
            }
        }
        //d($con, true);
        return $records;
    }
}

?>