<?php

class ControllerUserUserDepartment extends HController
{

    protected function getAlias()
    {
        return 'user/user_department';
    }

    protected function getPrimaryKey()
    {
        return 'user_id';
    }

    protected function getList()
    {
        parent::getList();

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateUpdate()) {
            $this->db->beginTransaction();
            $post = $this->request->post;
            $this->model['access'] = $this->load->model('user/user_department');
            $this->model['access']->deleteBulk($this->getAlias(),['company_id' => $this->session->data['company_id'], 'user_id' => $post['user_id']]);
            foreach($post['departments'] as $department_id) {
                $data = [
                    'user_id' => $post['user_id'],
                    'company_id' => $this->session->data['company_id'],
                    'department_id' => $department_id
                ];

                $this->model['access']->add($this->getAlias(), $data);
            }
            $this->db->commit();

            $this->session->data['success'] = $this->language->get('success_insert');
        }

        $this->model['user_access'] = $this->load->model('user/user_access');
        $user_ids = $this->model['user_access']->getArrays('user_id','user_id',['company_id' => $this->session->data['company_id']]);

        $this->model['user'] = $this->load->model('user/user');
        $where = "user_id IN ('".implode("','",$user_ids)."')";
        $this->data['users'] = $this->model['user']->getRows($where);

        $this->data['action_save'] = $this->url->link($this->getAlias(), 'token=' . $this->session->data['token'], 'SSL');
        $this->data['href_get_departments'] = $this->url->link($this->getAlias() . '/getDepartments', 'token=' . $this->session->data['token'], 'SSL');
        $this->template = $this->getAlias() . '.tpl';
        $this->response->setOutput($this->render());
    }

    public function getDepartments() {
        $user_id = $this->request->post['user_id'];
        $company_id = $this->session->data['company_id'];

        $this->model['department'] = $this->load->model('setup/department');
        $this->model['user_department'] = $this->load->model('user/user_department');

        $departments = $this->model['department']->getRows(['status' => 'Active', 'company_id' => $company_id],['department_name']);
        $access = $this->model['user_department']->getArrays('department_id','department_id',['user_id' => $user_id, 'company_id' => $company_id]);
        $html = '';
        foreach($departments as $department) {
            $html .= '<div class="checkbox">';
            $html .= '    <label>';
            if(in_array($department['department_id'],$access)) {
                $html .= '        <input type="checkbox" name="departments[]" class="minimal-red" checked value="'.$department['department_id'].'">&nbsp;'.$department['department_name'];
            } else {
                $html .= '        <input type="checkbox" name="departments[]" class="minimal-red" value="'.$department['department_id'].'">&nbsp;'.$department['department_name'];
            }
            $html .= '    </label>';
            $html .= '</div>';
        }
        $json = [
            'success' => true,
            'html' => $html
        ];

        echo json_encode($json);
    }
}

?>