<?php

class ModelEmployeeEmployeeAttendance extends HModel {
    protected $canAudit = false;

    protected function getTable() {
        return 'employee_attendance';
    }

    protected function getView() {
        return 'vw_employee_attendance';
    }

    public function getAttendanceSummary($filter=array()) {
        /*
        $sql = "SELECT ea.`employee_registration_id`, er.`registration_code`, er.`employee_id`, er.`employee_code`, er.`employee_name`".PHP_EOL;
        $sql .= ", er.`attendance_code`, er.`department_name`".PHP_EOL;
        $sql .= " , er.`shift_title`, er.`late_deduction`".PHP_EOL;
        $sql .= " , SUM(IF(ea.`status`='P',1,0)) AS total_present".PHP_EOL;
        $sql .= " , SUM(IF(ea.`status`='A',1,0)) AS total_absent".PHP_EOL;
        $sql .= " , SUM(IF(ea.`status`='LT',1,0)) AS total_late".PHP_EOL;
        $sql .= " , SUM(IF(ea.`status`='LP',1,0)) AS total_pay_leave".PHP_EOL;
        $sql .= " , SUM(IF(ea.`status`='LD',1,0)) AS total_deduction_leave".PHP_EOL;
        $sql .= " , SUM(IF(ea.`status`='H',1,0)) AS total_holiday".PHP_EOL;
        $sql .= " , COUNT(*) AS total".PHP_EOL;
        $sql .= " FROM `employee_attendance` AS ea".PHP_EOL;
        $sql .= " INNER JOIN `vw_employee_registration` er ON er.`employee_registration_id` = ea.`employee_registration_id`".PHP_EOL;
        if($filter) {
            if(is_array($filter)) {
                $implode = array();
                foreach($filter as $column => $value) {
                    $implode[] = "`$column`='$value'";
                }
                if($implode)
                    $sql .= " WHERE " . implode(" AND ", $implode).PHP_EOL;
            } else {
                $sql .= " WHERE " . $filter.PHP_EOL;
            }
        }
        $sql .= " GROUP BY `employee_registration_id`";
        */

        $sql = "SELECT er.`employee_registration_id`, er.`registration_code`, er.`employee_id`, e.`employee_code`, e.full_name AS `employee_name`".PHP_EOL;
        $sql .= " , er.`attendance_code`, d.`department_name`, c.yearly_leave".PHP_EOL;
        $sql .= " , ash.`shift_title`, ash.`late_deduction`".PHP_EOL;
        $sql .= " , (SELECT COUNT(*) FROM `employee_attendance` WHERE `status` = 'P' AND employee_registration_id = er.employee_registration_id AND `attendance_date` >= '".$filter['from_date']."' AND `attendance_date` <= '".$filter['to_date']."') AS total_present".PHP_EOL;
        $sql .= " , (SELECT COUNT(*) FROM `employee_attendance` WHERE `status` = 'A' AND employee_registration_id = er.employee_registration_id AND `attendance_date` >= '".$filter['from_date']."' AND `attendance_date` <= '".$filter['to_date']."') AS total_absent".PHP_EOL;
        $sql .= " , (SELECT COUNT(*) FROM `employee_attendance` WHERE `status` = 'LT' AND employee_registration_id = er.employee_registration_id AND `attendance_date` >= '".$filter['from_date']."' AND `attendance_date` <= '".$filter['to_date']."') AS total_late".PHP_EOL;
        $sql .= " , (SELECT COUNT(*) FROM `employee_attendance` WHERE `status` = 'H' AND employee_registration_id = er.employee_registration_id AND `attendance_date` >= '".$filter['from_date']."' AND `attendance_date` <= '".$filter['to_date']."') AS total_holiday".PHP_EOL;
        $sql .= " , (SELECT COUNT(*) FROM `employee_attendance` WHERE `status` = 'LP' AND employee_registration_id = er.employee_registration_id AND `attendance_date` >= '".$filter['from_date']."' AND `attendance_date` <= '".$filter['to_date']."') AS total_pay_leave".PHP_EOL;
        $sql .= " , (SELECT COUNT(*) FROM `employee_attendance` WHERE `status` = 'LD' AND employee_registration_id = er.employee_registration_id AND `attendance_date` >= '".$filter['from_date']."' AND `attendance_date` <= '".$filter['to_date']."') AS total_deduction_leave".PHP_EOL;
        $sql .= " , (SELECT COUNT(*) FROM `employee_attendance` WHERE `status` = 'WV' AND employee_registration_id = er.employee_registration_id AND `attendance_date` >= '".$filter['from_date']."' AND `attendance_date` <= '".$filter['to_date']."') AS total_waived".PHP_EOL;
        $sql .= " , (SELECT COUNT(*) FROM `employee_attendance` WHERE `status` = 'UA' AND employee_registration_id = er.employee_registration_id AND `attendance_date` >= '".$filter['from_date']."' AND `attendance_date` <= '".$filter['to_date']."') AS total_un_availed".PHP_EOL;
        $sql .= " FROM `employee_registration` er".PHP_EOL;
        $sql .= " INNER JOIN `employee` e ON e.employee_id = er.`employee_id`".PHP_EOL;
        $sql .= " INNER JOIN `company` c ON c.company_id = er.`company_id`".PHP_EOL;
        $sql .= " INNER JOIN `department` d ON d.department_id = er.`department_id`".PHP_EOL;
        $sql .= " LEFT JOIN `attendance_shift` ash ON ash.`attendance_shift_id` = er.`attendance_shift_id`".PHP_EOL;
        $sql .= " WHERE er.`company_id`='".$filter['company_id']."' AND er.status='Active'".PHP_EOL;
        if($filter['department_id']) {
            $sql .= " AND er.department_id IN ('".implode("','", $filter['department_id'])."')".PHP_EOL;
        }
        if($filter['employee_registration_id']) {
            $sql .= " AND er.employee_registration_id='".$filter['employee_registration_id']."'".PHP_EOL;
        }

        //d([$filter, $sql],true);
        $query = $this->conn->query($sql);
        return $query->rows;
    }


    public function getYearlyAttendance($employee_registration_id, $from_date, $to_date) {
        $sql = "SELECT c.`yearly_leave`, ash.`shift_title`, ash.`late_deduction`";
        $sql .= " FROM `employee_registration` er";
        $sql .= " INNER JOIN `company` c ON c.`company_id` = er.`company_id`";
        $sql .= " LEFT JOIN `attendance_shift` ash ON ash.`attendance_shift_id` = er.`attendance_shift_id`";
        $sql .= " WHERE er.`employee_registration_id` = '$employee_registration_id'";
        $query = $this->conn->query($sql);
        $row =  $query->row;
        $data = [
            'yearly_leave' => $row['yearly_leave'],
            'shift_title' => $row['shift_title'],
            'late_deduction' => $row['late_deduction'],
            'Absent' => 0,
            'Present' => 0,
            'Late' => 0,
            'LP' => 0,
            'LD' => 0,
        ];

        $sql = "SELECT ";
        $sql .= " SUM(IF(ea.`status`='A',1,0)) AS `Absent`";
        $sql .= ", SUM(IF(ea.`status`='P',1,0)) AS `Present`";
        $sql .= ", SUM(IF(ea.`status`='LT',1,0)) AS `Late`";
        $sql .= ", SUM(IF(ea.`status`='LP',1,0)) AS `LP`";
        $sql .= ", SUM(IF(ea.`status`='LD',1,0)) AS `LD`";
        $sql .= " FROM `employee_attendance` ea";
        $sql .= " WHERE ea.attendance_date >= '$from_date' AND ea.attendance_date <= '$to_date'";
        $sql .= " AND ea.employee_registration_id = '$employee_registration_id'";

        $query = $this->conn->query($sql);
        $row =  $query->row;
        if($row) {
            $data['Absent'] = empty($row['Absent'])?0:$row['Absent'];
            $data['Present'] = empty($row['Present'])?0:$row['Present'];
            $data['Late'] = empty($row['Late'])?0:$row['Late'];
            $data['LP'] = empty($row['LP'])?0:$row['LP'];
            $data['LD'] = empty($row['LD'])?0:$row['LD'];
        }


        return $data;
    }

}

?>