<?php

class ModelEmployeeEmployeeRegistration extends HModel {

    protected function getTable() {
        return 'employee_registration';
    }

    protected function getView() {
        return 'vw_employee_registration';
    }

    private function getQuery() {
        $sql = "SELECT `er`.`company_id`, `er`.`employee_id`,  `er`.`employee_registration_id`,  `er`.`registration_code`";
        $sql .= " , `er`.`attendance_code`, `er`.`department_id`, `er`.`designation_id`, `er`.`attendance_shift_id`";
        $sql .= " , `er`.`joining_date`, `er`.`leaving_date`, `er`.`employee_bank_id`";
        $sql .= " , `er`.`bank_id`, `er`.`bank_account`, `er`.`bank_title`, `er`.`bank_iban`, `er`.`arrears`, `er`.`status`, `er`.`total_payroll`";
        $sql .= " , `er`.`created_at`, `er`.`created_by_id`, `er`.`modified_at`, `er`.`modified_by_id`";
        $sql .= " , `er`.`party_id`, `er`.`attendance_exempted`, `e`.`employee_image`, `e`.`employee_code`, `e`.`full_name` as employee_name, `e`.`dob`, `e`.`gender`";
        $sql .= " , `er`.`override_attendance_policy`, `er`.`override_allowance_policy`, er.deduction_days, er.deduction_percent";
        $sql .= " , `e`.`mobile_no`, `e`.`phone_no`, `e`.`email`, `e`.`its_no`, `e`.`cnic_no`, `e`.`cnic_name`, `e`.`cnic_address`";
        $sql .= " , `e`.`eobi_date`, `e`.`eobi_no`, `e`.`ntn_no`, `e`.`surname`, `e`.`marital_status`, `e`.`city`, `e`.`area`, `e`.`nationality`";
        $sql .= " , `e`.`cnic_expiry`, `e`.`eobi_sno`, `e`.`probation_from`, `e`.`probation_to`, `e`.`ramzan_enayat`";
        $sql .= " , `e`.`nicop_no`, `e`.`nicop_name`, `e`.`nicop_expiry`, `e`.`nicop_address`";
        $sql .= " , `e`.`passport_no`, `e`.`passport_name`, `e`.`passport_expiry`, `e`.`passport_address`";
        $sql .= " , `c`.`parent_company_id`, `c`.`company_name`, `c`.`eobi_party_id`, `c`.`eobi_ah_key`, `c`.`tax_party_id`, `c`.`tax_ah_key`";
        $sql .= " , `d`.`department_name`, `d`.`party_id` , `d`.`ah_key` , `d`.`budget_key`, `ds`.`designation_name`, `s`.`shift_title`";
        $sql .= " , `s`.`late_deduction`, `b`.`bank_name`";
        $sql .= " ,(SELECT COUNT(0) FROM `payroll` `p` WHERE `p`.`employee_registration_id` = `er`.`employee_registration_id`) AS `paid_payroll`";
        $sql .= " FROM `employee_registration` `er`";
        $sql .= " LEFT JOIN `company` `c` ON `c`.`company_id` = `er`.`company_id`";
        $sql .= " LEFT JOIN `employee` `e` ON `e`.`employee_id` = `er`.`employee_id`";
        $sql .= " LEFT JOIN `department` `d` ON `d`.`department_id` = `er`.`department_id`";
        $sql .= " LEFT JOIN `designation` `ds` ON `ds`.`designation_id` = `er`.`designation_id`";
        $sql .= " LEFT JOIN `attendance_shift` `s` ON `s`.`attendance_shift_id` = `er`.`attendance_shift_id`";
        $sql .= " LEFT JOIN `bank` `b` ON `b`.`bank_id` = `er`.`bank_id`";

        return $sql;
    }

    public function getRecords($filter=array(), $sort_order=array(), $limit='') {
        $sql = $this->getQuery();
        if($filter) {
            if(is_array($filter)) {
                //$table_columns = $this->getTableColumns($this->getTable());
                $implode = array();
                foreach($filter as $column => $value) {
                    //if(in_array($column,$table_columns)) {
                    $implode[] = "`$column`='$value'";
                    //}
                }
                if($implode)
                    $sql .= " WHERE " . implode(" AND ", $implode);
            } else {
                $sql .= " WHERE " . $filter;
            }
        }

        if($sort_order) {
            $sql .= " ORDER BY " . implode(',',$sort_order);
        }

        if($limit) {
            $sql .= " LIMIT ".$limit;
        }

        $query = $this->conn->query($sql);
        return $query->rows;
    }

    public function getRecord($filter=array(), $sort_order=array(),$columns=null) {
        $sql = $this->getQuery();

        if($filter) {
            if(is_array($filter)) {
                //$table_columns = $this->getTableColumns($this->getTable());
                $implode = array();
                foreach($filter as $column => $value) {
                    //if(in_array($column,$table_columns)) {
                    $implode[] = "`$column`='$value'";
                    //}
                }
                if($implode)
                    $sql .= " WHERE " . implode(" AND ", $implode);
            } else {
                $sql .= " WHERE " . $filter;
            }
        }

        if($sort_order) {
            $sql .= " ORDER BY " . implode(',',$sort_order);
        }

        $query = $this->conn->query($sql);
        return $query->row;
    }

    public function getRegistrationCode($company_id='') {
        $sql = "SELECT MAX(CONVERT(registration_code,UNSIGNED INTEGER)) as max_no";
        $sql .= " FROM `".DB_PREFIX.$this->getTable()."`";
        if($company_id != '') {
            $sql .= " WHERE `company_id` = '".$company_id."'";
        }
        $query = $this->conn->query($sql);
        $row = $query->row;
        return (is_null($row['max_no'])?'1':$row['max_no']+1);
    }

    public function validateAttendanceCode($code) {
        $sql = " SELECT * FROM employee_registration ";
        $sql .= " WHERE attendance_code = '".$code."' ";
        $query = $this->conn->query($sql);
        if($query->num_rows == 0)
        {
            return true;
        }
        else
        {
            return false;
        }
    }
}

?>