<?php

class ModelEmployeeMachineAttendance extends HModel {

    protected function getTable() {
        return '_temp_machine_attendance';
    }

    protected function getView() {
        $sql = "(";
        $sql .= "SELECT er.*, ma.attendance_date, ma.clock_in as time_in, ma.clock_out as time_Out";
        $sql .= " FROM `_temp_machine_attendance` ma";
        $sql .= " INNER JOIN `vw_employee_registration` er ON er.`attendance_code` = ma.`machine_no`";
        $sql .= ") as ma";

        return $sql;
    }

    public function truncateTempTable() {
        $sql = "TRUNCATE TABLE `".$this->getTable()."`";
        $this->conn->query($sql);
    }

    public function fillTempTable($csv_file) {
        $sql = "LOAD DATA LOCAL INFILE '".$this->conn->escape($csv_file)."' INTO TABLE `".$this->getTable()."` CHARACTER SET 'utf8' FIELDS TERMINATED BY ',' ENCLOSED BY '\"' LINES TERMINATED BY '\r\n' IGNORE 1 LINES;";
        //$sql = "LOAD DATA INFILE '".$this->conn->escape($csv_file)."' INTO TABLE `".$this->getTable()."` CHARACTER SET 'utf8' FIELDS TERMINATED BY ',' ENCLOSED BY '\"' LINES TERMINATED BY '\r\n' IGNORE 1 LINES;";
        $this->conn->query($sql);
    }

    public function getAttendanceData($from_date, $to_date) {
        $sql = "SELECT er.company_id, er.`employee_registration_id`, er.`employee_id`, er.`employee_code`, er.`registration_code`, er.`employee_name`, er.`attendance_shift_id`, ma.`attendance_date`, MIN(ma.`clock_in`) AS clock_in, MAX(ma.`clock_out`) AS clock_out";
        $sql .= " FROM `_temp_machine_attendance` ma";
        $sql .= " INNER JOIN `vw_employee_registration` er ON er.`attendance_code` = ma.`machine_no`";
        $sql .= " WHERE ma.`attendance_date` >='".$from_date."' AND ma.`attendance_date`<='".$to_date."'";
        $sql .= " GROUP BY er.company_id, er.`employee_registration_id`, ma.attendance_date";
        $query = $this->conn->query($sql);
        return $query->rows;
    }

    public function fillEmployeeAttendance($from_date, $to_date) {
        $sql = "INSERT IGNORE INTO `employee_attendance` (employee_attendance_id, company_id, department_id, employee_registration_id, attendance_date, time_in, time_out, shift_in, shift_out, `status`, `attendance_type`, `created_at`, `created_by_id`)".PHP_EOL;
        $sql .= "SELECT CONCAT('{',UUID(),'}') AS employee_attendance_id, er.company_id, er.`department_id`, er.`employee_registration_id`".PHP_EOL;
        $sql .= " , ma.`attendance_date`, MIN(ma.`clock_in`) AS time_in, MAX(ma.`clock_out`) AS time_out, sd.`from_time` AS shift_in, sd.`to_time` AS shift_out".PHP_EOL;
        $sql .= " , IF(sd.`day_status`='Working Day' AND CAST(MIN(ma.`clock_in`) AS TIME) > CAST(sd.`from_time` AS TIME),'LT','P') AS `status`".PHP_EOL;
        //$sql .= " , IF(sd.`day_status`='Working Day' AND (CAST(MIN(ma.`clock_in`) AS TIME) > CAST(sd.`from_time` AS TIME) OR CAST(MAX(ma.`clock_out`) AS TIME) IS NULL OR CAST(MAX(ma.`clock_out`) AS TIME) < CAST(sd.`to_time` AS TIME)),'LT','P') AS `status`".PHP_EOL;
        $sql .= " , 'Automatic' AS attendance_type, '".date('Y-m-d H:i:s')."' AS created_at, '".$this->session->data['user_id']."' AS created_by_id".PHP_EOL;
        $sql .= " FROM `_temp_machine_attendance` ma".PHP_EOL;
        $sql .= " INNER JOIN `vw_employee_registration` er ON er.`attendance_code` = ma.`machine_no` AND er.`company_id` = '".$this->session->data['company_id']."'".PHP_EOL;
        $sql .= " INNER JOIN `attendance_shift_detail` sd ON sd.`attendance_shift_id` = er.`attendance_shift_id` AND sd.`day`= DATE_FORMAT(ma.`attendance_date`, '%a')".PHP_EOL;
        $sql .= " WHERE ma.`attendance_date` >='".$from_date."' AND ma.`attendance_date`<='".$to_date."'".PHP_EOL;
        $sql .= " AND ma.`clock_in` !='' AND ma.`clock_in` !='0:00'".PHP_EOL;
        $sql .= " GROUP BY er.company_id, er.`employee_registration_id`, ma.`attendance_date`".PHP_EOL;
        //d($sql, true);
        $query = $this->conn->query($sql);
    }

}

?>