<?php

class ModelPayrollAccountPosting extends HModel {

    protected function getTable() {
        return 'account_posting';
    }

    //protected function getView() {
    //    return 'vw_payroll';
    //}

    public function fillTable($from_date, $to_date) {
        $sql = "TRUNCATE TABLE `temp_account_posting`";
        $this->conn->query($sql);

        $sql = "INSERT INTO `temp_account_posting`".PHP_EOL;
        $sql .= " SELECT p.`payroll_id`, ds.deposit_slip_id, ds.cheque_no, p.`employee_code`, p.`registration_code`, p.`employee_name`, p.`basic_salary`, p.`house_rent_allowance`, p.`other_allowance`, p.`arrears`, p.`gross_salary`".PHP_EOL;
        $sql .= " , p.`other_deduction`, p.`tax_deduction`, p.`manual_addition`, p.`manual_deduction`, p.`overtime`, p.`attendance_deduction`, p.`payable_salary`".PHP_EOL;
        $sql .= " , (SELECT SUM(deduction_amount) FROM `payroll_deduction` pd WHERE pd.payroll_id = p.`payroll_id` AND pd.deduction_code='ADV') AS advance_amount".PHP_EOL;
        $sql .= " , (SELECT SUM(deduction_amount) FROM `payroll_deduction` pd WHERE pd.payroll_id = p.`payroll_id` AND pd.deduction_id=8) AS eobi_amount".PHP_EOL;
        $sql .= " , ca.`party_id` AS bank_party_id, ca.`ah_key` AS bank_ah_key, p.`eobi_party_id`, p.`eobi_ah_key`, p.`tax_party_id`, p.`tax_ah_key`, p.`dept_party_id`, p.`dept_ah_key`, p.`dept_budget_key`".PHP_EOL;
        $sql .= " FROM `vw_payroll` p".PHP_EOL;
        $sql .= " INNER JOIN `deposit_slip` ds ON ds.`deposit_slip_id` = p.`deposit_slip_id`".PHP_EOL;
        $sql .= " INNER JOIN `company_account` ca ON ca.`company_account_id` = ds.`company_account_id`".PHP_EOL;
        $sql .= " WHERE p.company_id = '".$this->session->data['company_id']."' AND p.fiscal_year_id = '".$this->session->data['fiscal_year_id']."'".PHP_EOL;
        $sql .= " AND p.document_date >='".$from_date."' AND p.document_date <= '".$to_date."'".PHP_EOL;
        $this->conn->query($sql);

        $sql = "INSERT INTO `temp_account_posting`".PHP_EOL;
        $sql .= " SELECT CONCAT('{',UUID(),'}') AS payroll_id, ds.deposit_slip_id, ds.`cheque_no`".PHP_EOL;
        $sql .= " , dsd.`employee_code`, dsd.`registration_code`, dsd.`employee_name`, 0 AS basic_salary, 0 AS house_rent_allowance, 0 AS other_allowance".PHP_EOL;
        $sql .= " , 0 AS arrears, 0 AS gross_salary, 0 AS other_deduction, 0 AS tax_deduction, 0 AS manual_addition, 0 AS manual_deduction, 0 AS overtime".PHP_EOL;
        $sql .= " , 0 AS attendance_deduction, 0 AS payable_salary, 0 AS advance_amount, 0 AS eobi_amount".PHP_EOL;
        $sql .= " , 0 AS bank_party_id, 0 AS bank_ah_key, 0 AS eobi_party_id, 0 AS eobi_ah_key, 0 AS tax_party_id, 0 AS tax_ah_key, 0 AS dept_party_id, 0 AS dept_ah_key, 0 AS dept_budget_key".PHP_EOL;
        $sql .= " FROM `deposit_slip` ds".PHP_EOL;
        $sql .= " INNER JOIN `deposit_slip_detail` dsd ON dsd.`deposit_slip_id` = ds.`deposit_slip_id`".PHP_EOL;
        $sql .= " WHERE ds.company_id = '".$this->session->data['company_id']."' AND ds.fiscal_year_id = '".$this->session->data['fiscal_year_id']."'".PHP_EOL;
        $sql .= " AND ds.deposit_slip_date >='".$from_date."' AND ds.`deposit_slip_date` <= '".$to_date."'".PHP_EOL;
        //$sql .= " AND ds.is_post = 'No' ".PHP_EOL;
        $sql .= " AND ds.`deposit_slip_id` NOT IN (";
        $sql .= " SELECT DISTINCT deposit_slip_id";
        $sql .= " FROM `temp_account_posting`";
        $sql .= " )";
        $this->conn->query($sql);
    }

    public function getDistributionList() {
        $sql = "SELECT ds.`deposit_slip_id`, ds.`payroll_date`, ds.`deposit_slip_date`, ds.`deposit_slip_no`, ds.`deposit_slip_title`, ds.`cheque_date`, ds.`cheque_no`, ca.`account_title`, ca.`account_no`, ds.`cheque_amount`, ds.`is_post`";
        $sql .= " FROM `deposit_slip` ds";
        $sql .= " INNER JOIN `company_account` ca ON ca.`company_account_id` = ds.`company_account_id`";
        $sql .= " WHERE ds.`deposit_slip_id` IN (";
        $sql .= " SELECT DISTINCT deposit_slip_id";
        $sql .= " FROM `temp_account_posting`";
        $sql .= " )";
        //$sql .= " ORDER BY ds.`deposit_slip_no`";
        $sql .= " ORDER BY ds.`cheque_no`";

        $query = $this->conn->query($sql);
        return $query->rows;
    }

    public function getLedger() {
        $sql = "SELECT ca.`party_id` AS PartyID, ca.`ah_key` AS AHKey, 'C' AS trans_type, cheque_no AS Ref, cheque_amount AS Amount";
        $sql .= " FROM `deposit_slip` ds";
        $sql .= " INNER JOIN `company_account` ca ON ca.`company_account_id` = ds.`company_account_id`";
        $sql .= " WHERE ds.deposit_slip_id IN (select distinct deposit_slip_id from `temp_account_posting`)";
        //$sql .= "SELECT bank_party_id as PartyID, bank_ah_key as AHKey, 'C' AS trans_type, cheque_no as Ref, SUM(payable_salary) AS Amount";
        //$sql .= " FROM `temp_account_posting`";
        //$sql .= " GROUP BY bank_party_id, bank_ah_key, cheque_no";
        $sql .= " UNION";
        $sql .= " SELECT eobi_party_id, eobi_ah_key, 'C' AS trans_type,'' as Ref, SUM(eobi_amount) AS Amount";
        $sql .= " FROM `temp_account_posting`";
        $sql .= " GROUP BY eobi_party_id, eobi_ah_key";
        $sql .= " UNION";
        $sql .= " SELECT tax_party_id, tax_ah_key, 'C' AS trans_type,'' as Ref, SUM(tax_deduction) AS Amount";
        $sql .= " FROM `temp_account_posting`";
        $sql .= " GROUP BY tax_party_id, tax_ah_key";
        $sql .= " UNION";
        //$sql .= " SELECT dept_party_id, dept_ah_key, 'D' AS trans_type,'' as Ref, SUM(payable_salary + tax_deduction + eobi_amount) AS Amount";
        $sql .= " SELECT dept_party_id, dept_ah_key, 'D' AS trans_type,'' as Ref, SUM(payable_salary + tax_deduction + other_deduction - advance_amount) AS Amount";
        $sql .= " FROM `temp_account_posting`";
        $sql .= " GROUP BY dept_party_id, dept_ah_key";
        $query = $this->conn->query($sql);
        return $query->rows;
    }

    public function getBudgets() {
        $sql = "SELECT dept_budget_key AS BudKey, dept_party_id as PartyID, dept_ah_key as AHKey, SUM(payable_salary + tax_deduction + other_deduction) AS budAmount";
        $sql .= " FROM `temp_account_posting`";
        $sql .= " GROUP BY dept_budget_key, dept_party_id, dept_ah_key";

        $query = $this->conn->query($sql);
        return $query->rows;
    }

    public function getNextVoucher() {
        $sql = "SELECT MAX(document_no) as document_no";
        $sql .= " FROM `account_posting`";
        $query = $this->conn->query($sql);
        $document_no = $query->row['document_no'];
        if(is_null($document_no)) {
            $document_no = 1;
        } else {
            $document_no++;
        }

        return $document_no;
    }
}
?>