<?php

class ModelPayrollBankLetter extends HModel {

    protected function getTable() {
        return 'bank_letter';
    }

    //protected function getView() {
    //    return 'vw_deposit_slip';
    //}

    public function getNextNumber($document_prefix) {
        $company_id = $this->session->data['company_id'];
        $fiscal_year_id = $this->session->data['fiscal_year_id'];

        $sql  = "SELECT MAX(document_no) AS max_num";
        $sql .= " FROM `bank_letter`";
        $sql .= " WHERE `company_id` = '$company_id'";
        $sql .= " AND `fiscal_year_id` = '$fiscal_year_id'";
        $sql .= " AND `document_prefix` = '$document_prefix'";

        $query = $this->db->query($sql);
        $row = $query->row;
        $max_num = (is_null($row['max_num'])?1:($row['max_num']+1));

        return array(
            'document_prefix' => $document_prefix,
            'document_no' => $max_num,
            'document_identity' => $document_prefix . str_pad($max_num,4,"0",STR_PAD_LEFT)
        );
    }


    public function getEmployeeBanks() {
        $company_id = $this->session->data['company_id'];

        $sql = "SELECT DISTINCT b.bank_id, b.bank_name";
        $sql .= " FROM `employee_registration` er";
        $sql .= " INNER JOIN `bank` b ON b.`bank_id` = er.`bank_id`";
        $sql .= " WHERE company_id = $company_id";
        $sql .= " ORDER BY bank_name";

        //d($sql, true);
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getSpecialEnayatData($filter) {
        $sql = "SELECT 'special_enayat_detail' AS source_table, sed.`special_enayat_detail_id` AS source_table_id";
        $sql .= " , se.`special_enayat_id`, se.`document_identity`, se.`document_date`, se.`document_title`";
        $sql .= " , sed.`employee_registration_id`, sed.`employee_id`, e.employee_code, er.`registration_code`, e.`full_name` as employee_name";
        $sql .= " , IFNULL(b.`bank_name`,'') as bank_name, IFNULL(eb.`bank_id`,'') as bank_id, IFNULL(eb.`account_title`,'') as bank_title, IFNULL(eb.`iban_no`,'') as bank_iban".PHP_EOL;
        $sql .= " , sed.`amount` AS amount, er.`department_id`, er.`bank_id`";
        $sql .= " , (SELECT COUNT(*) FROM `individual_cheque_detail` cd WHERE cd.source_table_id = sed.`special_enayat_detail_id`) AS bank_letter";
        $sql .= " , (SELECT COUNT(*) FROM `bank_letter_detail` bl WHERE bl.source_table_id = sed.`special_enayat_detail_id`) AS bank_letter";
        $sql .= " FROM `special_enayat` se";
        $sql .= " INNER JOIN `special_enayat_detail` sed ON sed.`special_enayat_id` = se.`special_enayat_id`";
        $sql .= " INNER JOIN `employee_registration` er ON er.`employee_registration_id` = sed.`employee_registration_id`";
        $sql .= " INNER JOIN `employee` e ON e.`employee_id` = er.`employee_id`";
        $sql .= " LEFT JOIN `employee_bank` eb ON eb.`employee_bank_id` = er.`employee_bank_id`".PHP_EOL;
        $sql .= " LEFT JOIN `bank` b ON b.`bank_id` = eb.`bank_id`".PHP_EOL;
        $sql .= " WHERE se.company_id = '".$filter['company_id']."'";
        $sql .= " AND se.fiscal_year_id = '".$filter['fiscal_year_id']."'";
        $sql .= " AND se.document_date = '".$filter['source_date']."'";
        if($filter['bank_id']) {
            $sql .= " AND b.bank_id IN ('".implode("','",$filter['bank_id'])."')";
        }
        if($filter['department_id']) {
            $sql .= " AND er.department_id IN ('".implode("','",$filter['department_id'])."')";
        }
        if($filter['employee_registration_id']) {
            $sql .= " AND er.employee_registration_id = '".$filter['employee_registration_id']."'";
        }

        $sql .= " HAVING bank_letter = 0";
        $sql .= " ORDER BY e.full_name";

        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getSpecialAllowanceData($filter) {
        $sql = "SELECT 'special_allowance_installment' AS source_table, `special_allowance_installment_id` AS source_table_id";
        $sql .= " , sa.`employee_registration_id`, er.`employee_id`, e.`employee_code`, er.`registration_code`, e.`full_name` AS employee_name";
        $sql .= " , IFNULL(b.`bank_name`,'') as bank_name, IFNULL(eb.`bank_id`,'') as bank_id, IFNULL(eb.`account_title`,'') as bank_title, IFNULL(eb.`iban_no`,'') as bank_iban".PHP_EOL;
        $sql .= " , sai.`installment_amount` AS amount";
        $sql .= " , (SELECT COUNT(*) FROM `individual_cheque_detail` cd WHERE cd.source_table_id = sai.`special_allowance_installment_id`) AS individual_cheque".PHP_EOL;
        $sql .= " , (SELECT COUNT(*) FROM `bank_letter_detail` bd WHERE bd.source_table_id = sai.`special_allowance_installment_id`) AS bank_letter";
        $sql .= " FROM `special_allowance_installments` sai";
        $sql .= " INNER JOIN `special_allowance` sa ON sa.`special_allowance_id` = sai.`special_allowance_id`";
        $sql .= " INNER JOIN `employee_registration` er ON er.`employee_registration_id` = sa.`employee_registration_id`";
        $sql .= " INNER JOIN `employee` e ON e.`employee_id` = er.`employee_id`";
        $sql .= " LEFT JOIN `employee_bank` eb ON eb.`employee_bank_id` = er.`employee_bank_id`".PHP_EOL;
        $sql .= " LEFT JOIN `bank` b ON b.`bank_id` = eb.`bank_id`".PHP_EOL;
        $sql .= " WHERE sa.company_id = '".$filter['company_id']."'";
        //$sql .= " AND sa.fiscal_year_id = '".$filter['fiscal_year_id']."'"; This check was removed, as employee filling their allowance before financial year.
        $sql .= " AND sa.special_allowance_type_id = '".$filter['special_allowance_type_id']."'";
        $sql .= " AND sai.installment_date = '".$filter['source_date']."'";
        if($filter['bank_id']) {
            $sql .= " AND b.bank_id IN ('".implode("','",$filter['bank_id'])."')";
        }
        if($filter['department_id']) {
            $sql .= " AND er.department_id IN ('".implode("','",$filter['department_id'])."')";
        }
        if($filter['employee_registration_id']) {
            $sql .= " AND er.employee_registration_id = '".$filter['employee_registration_id']."'";
        }
        $sql .= " HAVING individual_cheque = 0 AND bank_letter = 0";
        $sql .= " ORDER BY e.full_name";

        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getPayrollData($filter) {
        $sql = "SELECT 'payroll' AS source_table, p.payroll_id AS source_table_id".PHP_EOL;
        $sql .= " , er.`employee_registration_id`, e.`employee_id`, e.`employee_code`, er.`registration_code`, e.`full_name` AS employee_name".PHP_EOL;
        $sql .= " , IFNULL(b.`bank_name`,'') as bank_name, IFNULL(eb.`bank_id`,'') as bank_id, IFNULL(eb.`account_title`,'') as bank_title, IFNULL(eb.`iban_no`,'') as bank_iban, p.`payable_salary` AS amount".PHP_EOL;
        $sql .= " , (SELECT COUNT(*) FROM `individual_cheque_detail` cd WHERE cd.source_table_id = p.`payroll_id`) AS individual_cheque".PHP_EOL;
        $sql .= " , (SELECT COUNT(*) FROM `bank_letter_detail` bd WHERE bd.source_table_id = p.`payroll_id`) AS bank_letter".PHP_EOL;
        $sql .= " FROM `payroll` p".PHP_EOL;
        $sql .= " INNER JOIN `employee_registration` er ON er.`employee_registration_id` = p.`employee_registration_id`".PHP_EOL;
        $sql .= " INNER JOIN `employee` e ON e.`employee_id` = er.`employee_id`".PHP_EOL;
        $sql .= " LEFT JOIN `employee_bank` eb ON eb.`employee_bank_id` = er.`employee_bank_id`".PHP_EOL;
        $sql .= " LEFT JOIN `bank` b ON b.`bank_id` = eb.`bank_id`".PHP_EOL;
        $sql .= " WHERE p.company_id = '".$filter['company_id']."'".PHP_EOL;
        $sql .= " AND p.fiscal_year_id = '".$filter['fiscal_year_id']."'".PHP_EOL;
        $sql .= " AND p.document_date = '".$filter['source_date']."'".PHP_EOL;
        if($filter['bank_id']) {
            $sql .= " AND b.bank_id IN ('".implode("','",$filter['bank_id'])."')";
        }
        if($filter['department_id']) {
            $sql .= " AND er.department_id IN ('".implode("','",$filter['department_id'])."')".PHP_EOL;
        }
        if($filter['employee_registration_id']) {
            $sql .= " AND er.employee_registration_id = '".$filter['employee_registration_id']."'".PHP_EOL;
        }
        $sql .= " HAVING individual_cheque = 0 AND bank_letter = 0 AND amount != 0".PHP_EOL;
        $sql .= " ORDER BY e.full_name";

        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getPayrollDeductions($document_date, $company_id) {
        $sql = "SELECT 'payroll' AS source_table,'' AS source_table_id, '' AS employee_registration_id, '' AS employee_id, 0 AS employee_code, 0 AS registration_code, '' AS employee_name";
        $sql .= " , b.`bank_name`, ca.bank_id, ca.account_title AS bank_title, ca.`iban` AS bank_iban, SUM(deduction_amount) AS amount";
        $sql .= " FROM `payroll_deduction` pd";
        $sql .= " INNER JOIN `deduction` d ON d.`deduction_id` = pd.`deduction_id` AND d.`deduction_code` != 'EOBI'";
        $sql .= " INNER JOIN `company_account` ca ON ca.`company_account_id` = d.`company_account_id`";
        $sql .= " INNER JOIN bank b ON b.bank_id = ca.bank_id";
        $sql .= " INNER JOIN `payroll` p ON p.`payroll_id` = pd.`payroll_id`";
        $sql .= " AND p.`document_date` = '$document_date'";
        $sql .= " AND p.`company_id` = '$company_id'";
        $sql .= " GROUP BY ca.`bank_id`, ca.`account_no`, ca.`account_title`";
        $sql .= " HAVING amount != 0";

        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getPostDataSpecialAllowance($document_id, $post_type='Single') {
        if($post_type=='Single') {
            $sql = "SELECT bl.document_date AS PayDate, bl.document_identity AS SysKey, 'PR' AS SysTag, sat.`SysTag` AS TranCategory, fy.`ref_id` AS `Year`, '' AS Comp".PHP_EOL;
            $sql .= " , IFNULL(er.`party_id`,'') AS PartyID, e.`cnic_name` AS Party, 'D' AS tran_type".PHP_EOL;
            $sql .= " , 0 AS BAHKey, sat.`ah_key` AS AHKey, 0 AS CCKey, 0 AS BudKey, bl.`document_title` AS Narr, '' AS Ref, 'N' AS taxType".PHP_EOL;
            $sql .= " , bld.amount AS Bamount, bld.amount AS Pamount, sat.`budget_key` AS budget_key".PHP_EOL;
            $sql .= " FROM `bank_letter_detail` bld".PHP_EOL;
            $sql .= " INNER JOIN `bank_letter` bl ON bl.`bank_letter_id` = bld.`bank_letter_id` AND bl.bank_letter_id = '$document_id'".PHP_EOL;
            $sql .= " INNER JOIN `special_allowance_installments` saa ON saa.`special_allowance_installment_id` = bld.`source_table_id`".PHP_EOL;
            $sql .= " INNER JOIN `special_allowance` sa ON sa.`special_allowance_id` = saa.`special_allowance_id`".PHP_EOL;
            $sql .= " INNER JOIN `special_allowance_type` sat ON sat.`special_allowance_type_id` = sa.`special_allowance_type_id`".PHP_EOL;
            $sql .= " INNER JOIN `fiscal_year` fy ON fy.`fiscal_year_id` = bl.`fiscal_year_id`".PHP_EOL;
            $sql .= " INNER JOIN `employee_registration` er ON er.`employee_registration_id` = bld.`employee_registration_id`".PHP_EOL;
            $sql .= " INNER JOIN `employee` e ON e.`employee_id` = er.`employee_id`".PHP_EOL;
            //$sql .= " GROUP BY PartyID, AHKey, Budget_key".PHP_EOL;
            $sql .= " UNION ALL".PHP_EOL;
        } else {
            $sql = " SELECT bl.document_date AS PayDate, bl.document_identity AS SysKey, 'PR' AS SysTag, sat.`SysTag` AS TranCategory, fy.`ref_id` AS `Year`, '' AS Comp".PHP_EOL;
            $sql .= " , '' AS PartyID, '' AS Party, 'D' AS tran_type".PHP_EOL;
            $sql .= " , 0 AS BAHKey, sat.`ah_key` AS AHKey, 0 AS CCKey, 0 AS BudKey, bl.`document_title` AS Narr, '' AS Ref, 'N' AS taxType".PHP_EOL;
            $sql .= " , SUM(bld.amount) AS Bamount, SUM(bld.amount) AS Pamount, sat.`budget_key` AS budget_key".PHP_EOL;
            $sql .= " FROM `bank_letter_detail` bld ".PHP_EOL;
            $sql .= " INNER JOIN `bank_letter` bl ON bl.`bank_letter_id` = bld.`bank_letter_id` AND bl.bank_letter_id = '$document_id'".PHP_EOL;
            $sql .= " INNER JOIN `special_allowance_installments` saa ON saa.`special_allowance_installment_id` = bld.`source_table_id` ".PHP_EOL;
            $sql .= " INNER JOIN `special_allowance` sa ON sa.`special_allowance_id` = saa.`special_allowance_id` ".PHP_EOL;
            $sql .= " INNER JOIN `special_allowance_type` sat ON sat.`special_allowance_type_id` = sa.`special_allowance_type_id`".PHP_EOL;
            $sql .= " INNER JOIN `fiscal_year` fy ON fy.`fiscal_year_id` = bl.`fiscal_year_id` ".PHP_EOL;
            $sql .= " INNER JOIN `employee_registration` er ON er.`employee_registration_id` = bld.`employee_registration_id`".PHP_EOL;
            $sql .= " INNER JOIN `employee` e ON e.`employee_id` = er.`employee_id`".PHP_EOL;
            //$sql .= " GROUP BY AHKey, Budget_key".PHP_EOL;
            $sql .= " UNION ALL".PHP_EOL;
        }
        $sql .= " SELECT bl.document_date AS PayDate, bl.document_identity AS SysKey, 'PR' AS SysTag, '' AS TranCategory, fy.`ref_id` AS `Year`, '' AS Comp".PHP_EOL;
        $sql .= " , '' AS PartyID, '' AS Party, 'C' AS tran_type".PHP_EOL;
        $sql .= " , ca.`ah_key` AS BAHKey, ca.`ah_key` AS AHKey, 0 AS CCKey, 0 AS BudKey, bl.`document_title` AS Narr, bl.cheque_no AS Ref, 'N' AS taxType".PHP_EOL;
        $sql .= " , bl.total_amount AS Bamount, bl.total_amount AS Pamount, '' AS budget_key".PHP_EOL;
        $sql .= " FROM `bank_letter` bl ".PHP_EOL;
        $sql .= " INNER JOIN `fiscal_year` fy ON fy.`fiscal_year_id` = bl.`fiscal_year_id`".PHP_EOL;
        $sql .= " LEFT JOIN `company_account` ca ON ca.`company_account_id` = bl.`company_account_id`".PHP_EOL;
        $sql .= " WHERE bl.bank_letter_id = '$document_id'".PHP_EOL;

        //d($sql, true);
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getPostDataSpecialEnayat($document_id, $post_type='Single') {
        if($post_type=='Single') {
            $sql = "SELECT bl.document_date AS PayDate, bl.document_identity AS SysKey, 'PR' AS SysTag, ee.`SysTag` AS TranCategory, fy.`ref_id` AS `Year`, '' AS Comp".PHP_EOL;
            $sql .= " , IFNULL(er.`party_id`,'') AS PartyID, e.`cnic_name` AS Party, 'D' AS tran_type".PHP_EOL;
            $sql .= " , 0 AS BAHKey, ee.`ah_key` AS AHKey, 0 AS CCKey, 0 AS BudKey, bl.`document_title` AS Narr, '' AS Ref, 'N' AS taxType".PHP_EOL;
            $sql .= " , bld.amount AS Bamount, bld.amount AS Pamount, ee.`budget_key` AS budget_key".PHP_EOL;
            $sql .= " FROM `bank_letter_detail` bld".PHP_EOL;
            $sql .= " INNER JOIN `bank_letter` bl ON bl.`bank_letter_id` = bld.`bank_letter_id`".PHP_EOL;
            $sql .= " AND bl.bank_letter_id = '$document_id'".PHP_EOL;
            $sql .= " INNER JOIN `special_enayat_detail` d ON d.`special_enayat_detail_id` = bld.`source_table_id`".PHP_EOL;
            $sql .= " INNER JOIN `special_enayat` m ON m.`special_enayat_id` = d.`special_enayat_id`".PHP_EOL;
            $sql .= " INNER JOIN `enayat_event` ee ON ee.`enayat_event_id` = m.`enayat_event_id`".PHP_EOL;
            $sql .= " INNER JOIN `fiscal_year` fy ON fy.`fiscal_year_id` = bl.`fiscal_year_id`".PHP_EOL;
            $sql .= " INNER JOIN `employee_registration` er ON er.`employee_registration_id` = bld.`employee_registration_id`".PHP_EOL;
            $sql .= " INNER JOIN `employee` e ON e.`employee_id` = er.`employee_id`".PHP_EOL;
            $sql .= " UNION ALL".PHP_EOL;
        } else {
            $sql = "SELECT bl.document_date AS PayDate, bl.document_identity AS SysKey, 'PR' AS SysTag, ee.`SysTag` AS TranCategory, fy.`ref_id` AS `Year`, '' AS Comp".PHP_EOL;
            $sql .= " , '' AS PartyID, '' AS Party, 'D' AS tran_type".PHP_EOL;
            $sql .= " , 0 AS BAHKey, ee.`ah_key` AS AHKey, 0 AS CCKey, 0 AS BudKey, bl.`document_title` AS Narr, '' AS Ref, 'N' AS taxType".PHP_EOL;
            $sql .= " , SUM(bld.amount) AS Bamount, SUM(bld.amount) AS Pamount, ee.`budget_key` AS budget_key".PHP_EOL;
            $sql .= " FROM `bank_letter_detail` bld".PHP_EOL;
            $sql .= " INNER JOIN `bank_letter` bl ON bl.`bank_letter_id` = bld.`bank_letter_id`".PHP_EOL;
            $sql .= " AND bl.bank_letter_id = '$document_id'".PHP_EOL;
            $sql .= " INNER JOIN `special_enayat_detail` d ON d.`special_enayat_detail_id` = bld.`source_table_id`".PHP_EOL;
            $sql .= " INNER JOIN `special_enayat` m ON m.`special_enayat_id` = d.`special_enayat_id`".PHP_EOL;
            $sql .= " INNER JOIN `enayat_event` ee ON ee.`enayat_event_id` = m.`enayat_event_id`".PHP_EOL;
            $sql .= " INNER JOIN `fiscal_year` fy ON fy.`fiscal_year_id` = bl.`fiscal_year_id`".PHP_EOL;
            $sql .= " INNER JOIN `employee_registration` er ON er.`employee_registration_id` = bld.`employee_registration_id`".PHP_EOL;
            $sql .= " INNER JOIN `employee` e ON e.`employee_id` = er.`employee_id`".PHP_EOL;
            $sql .= " GROUP BY AHKey, Budget_key".PHP_EOL;
            $sql .= " UNION ALL".PHP_EOL;
        }
        $sql .= " SELECT bl.document_date AS PayDate, bl.document_identity AS SysKey, 'PR' AS SysTag, '' AS TranCategory, fy.`ref_id` AS `Year`, '' AS Comp".PHP_EOL;
        $sql .= " , '' AS PartyID, '' AS Party, 'C' AS tran_type".PHP_EOL;
        $sql .= " , ca.`ah_key` AS BAHKey, ca.`ah_key` AS AHKey, 0 AS CCKey, 0 AS BudKey, bl.`document_title` AS Narr, bl.cheque_no AS Ref, 'N' AS taxType".PHP_EOL;
        $sql .= " , bl.total_amount AS Bamount, bl.total_amount AS Pamount, '' AS budget_key".PHP_EOL;
        $sql .= " FROM `bank_letter` bl".PHP_EOL;
        $sql .= " INNER JOIN `fiscal_year` fy ON fy.`fiscal_year_id` = bl.`fiscal_year_id`".PHP_EOL;
        $sql .= " LEFT JOIN `company_account` ca ON ca.`company_account_id` = bl.`company_account_id`".PHP_EOL;
        $sql .= " WHERE bl.bank_letter_id = '$document_id'".PHP_EOL;

        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getPostDataPayroll($document_id) {
        // Departments Data
        $sql = "SELECT bl.document_date AS PayDate, bl.document_identity AS SysKey, 'PR' AS SysTag, 'S' AS TranCategory, fy.`ref_id` AS `Year`, '' AS Comp".PHP_EOL;
        $sql .= " , IFNULL(dp.`party_id`,'') AS PartyID, dp.`department_name` AS Party, 'D' AS tran_type".PHP_EOL;
        $sql .= " , 0 AS BAHKey, dp.`ah_key` AS AHKey, 0 AS CCKey, 0 AS BudKey, bl.`document_title` AS Narr, '' AS Ref, 'N' AS taxType".PHP_EOL;
        $sql .= " , SUM(p.`gross_salary` - p.`manual_deduction` - p.`attendance_deduction`-IFNULL(pd.deduction_amount,0)) AS Pamount".PHP_EOL;
        $sql .= " , SUM(p.`gross_salary` - p.`manual_deduction` - p.`attendance_deduction`-IFNULL(pd.deduction_amount,0)) AS Bamount".PHP_EOL;
        $sql .= " , dp.`budget_key`".PHP_EOL;
        $sql .= " FROM `bank_letter_detail` bld".PHP_EOL;
        $sql .= " INNER JOIN `bank_letter` bl ON bl.`bank_letter_id` = bld.`bank_letter_id`".PHP_EOL;
        $sql .= " AND bl.bank_letter_id = '$document_id'".PHP_EOL;
        $sql .= " LEFT JOIN `company_account` ca ON ca.`company_account_id` = bl.`company_account_id`".PHP_EOL;
        $sql .= " INNER JOIN `payroll` p ON p.`payroll_id` = bld.`source_table_id`".PHP_EOL;
        $sql .= " LEFT JOIN `payroll_deduction` pd ON pd.`payroll_id` = p.`payroll_id` AND pd.`deduction_code`='ADV'".PHP_EOL;
        $sql .= " INNER JOIN `fiscal_year` fy ON fy.`fiscal_year_id` = bl.`fiscal_year_id`".PHP_EOL;
        $sql .= " INNER JOIN `employee_registration` er ON er.`employee_registration_id` = bld.`employee_registration_id`".PHP_EOL;
        $sql .= " INNER JOIN `employee` e ON e.`employee_id` = er.`employee_id`".PHP_EOL;
        $sql .= " INNER JOIN `department` dp ON dp.`department_id` = er.`department_id`".PHP_EOL;
        $sql .= " GROUP BY PartyID, AHKey, budget_key".PHP_EOL;
        // EOBI
        $sql .= " UNION ALL".PHP_EOL;
        $sql .= " SELECT bl.document_date AS PayDate, bl.document_identity AS SysKey, 'PR' AS SysTag, 'S' AS TranCategory, fy.`ref_id` AS `Year`, '' AS Comp".PHP_EOL;
        $sql .= " , IFNULL(c.eobi_party_id,'') AS PartyID, '' AS Party, 'C' AS tran_type".PHP_EOL;
        $sql .= " , IFNULL(c.eobi_ah_key,'') AS BAHKey, IFNULL(c.eobi_ah_key,'') AS AHKey".PHP_EOL;
        $sql .= " , 0 AS CCKey, 0 AS BudKey, bl.`document_title` AS Narr, '' AS Ref, 'N' AS taxType, SUM(pd.`deduction_amount`) AS Pamount, SUM(pd.`deduction_amount`) AS Bamount".PHP_EOL;
        $sql .= " , 0 AS budget_key".PHP_EOL;
        $sql .= " FROM `payroll_deduction` pd".PHP_EOL;
        $sql .= " INNER JOIN `payroll` p ON p.`payroll_id` = pd.`payroll_id`".PHP_EOL;
        $sql .= " INNER JOIN `bank_letter_detail` bld ON bld.`source_table_id` = p.`payroll_id`".PHP_EOL;
        $sql .= " INNER JOIN `bank_letter` bl ON bl.`bank_letter_id` = bld.`bank_letter_id` AND bl.`bank_letter_id` = '$document_id'".PHP_EOL;
        $sql .= " INNER JOIN `fiscal_year` fy ON fy.`fiscal_year_id` = bl.`fiscal_year_id`".PHP_EOL;
        $sql .= " INNER JOIN `company` c ON c.`company_id` = bl.`company_id`".PHP_EOL;
        $sql .= " WHERE pd.`deduction_code`='EOBI'".PHP_EOL;
        // Tax Account
        $sql .= " UNION ALL".PHP_EOL;
        $sql .= " SELECT bl.document_date AS PayDate, bl.document_identity AS SysKey, 'PR' AS SysTag, 'S' AS TranCategory, fy.`ref_id` AS `Year`, '' AS Comp".PHP_EOL;
        $sql .= " , IFNULL(c.`tax_party_id`,'') AS PartyID, 'TAX' AS Party, 'C' AS tran_type".PHP_EOL;
        $sql .= " , c.`tax_ah_key` AS BAHKey, c.`tax_ah_key` AS AHKey, 0 AS CCKey, 0 AS BudKey, bl.`document_title` AS Narr, '' AS Ref, 'N' AS taxType, SUM(p.`tax_deduction`) AS Pamount, SUM(p.`tax_deduction`) AS Bamount".PHP_EOL;
        $sql .= " , 0 AS budget_key".PHP_EOL;
        $sql .= " FROM `bank_letter_detail` bld".PHP_EOL;
        $sql .= " INNER JOIN `bank_letter` bl ON bl.`bank_letter_id` = bld.`bank_letter_id`".PHP_EOL;
        $sql .= " AND bl.bank_letter_id = '$document_id'".PHP_EOL;
        $sql .= " INNER JOIN `payroll` p ON p.`payroll_id` = bld.`source_table_id` AND p.`tax_deduction` != 0".PHP_EOL;
        $sql .= " INNER JOIN `fiscal_year` fy ON fy.`fiscal_year_id` = bl.`fiscal_year_id`".PHP_EOL;
        $sql .= " INNER JOIN `employee_registration` er ON er.`employee_registration_id` = bld.`employee_registration_id`".PHP_EOL;
        $sql .= " INNER JOIN company c ON c.`company_id` = er.`company_id`".PHP_EOL;
        $sql .= " GROUP BY PartyID, AHKey".PHP_EOL;
        // Cheque Amount
        $sql .= " UNION ALL".PHP_EOL;
        $sql .= " SELECT bl.document_date AS PayDate, bl.document_identity AS SysKey, 'PR' AS SysTag, 'S' AS TranCategory, fy.`ref_id` AS `Year`, '' AS Comp".PHP_EOL;
        $sql .= " , IFNULL(ca.`party_id`,'') AS PartyID, '' AS Party, 'C' AS tran_type".PHP_EOL;
        $sql .= " , ca.`ah_key` AS BAHKey, ca.`ah_key` AS AHKey, 0 AS CCKey, 0 AS BudKey, bl.`document_title` AS Narr, bl.`cheque_no` AS Ref, 'N' AS taxType, bl.`total_amount` AS Pamount, bl.`total_amount` AS Bamount".PHP_EOL;
        $sql .= " , 0 AS budget_key".PHP_EOL;
        $sql .= " FROM `bank_letter` bl".PHP_EOL;
        $sql .= " INNER JOIN `company_account` ca ON ca.`company_account_id` = bl.`company_account_id`".PHP_EOL;
        $sql .= " INNER JOIN `fiscal_year` fy ON fy.`fiscal_year_id` = bl.`fiscal_year_id`".PHP_EOL;
        $sql .= " WHERE bl.bank_letter_id = '$document_id'".PHP_EOL;

        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getEmployeeData($bank_letter_id) {
        $sql = "SELECT bl.`bank_letter_id`, bld.`bank_letter_detail_id`, bld.source_table_id, bl.`document_date`, bl.`document_identity`, bl.`document_title`, bl.`source_type`, bl.`cheque_date`, bl.`cheque_no`";
        $sql .= " , er.`employee_registration_id`, bld.bank_name, bld.`bank_title`, bld.`bank_iban`, bld.amount";
        $sql .= " , e.`employee_code`, er.`registration_code`, d.department_name, e.`full_name` AS employee_name, e.`mobile_no`, e.`email`";
        $sql .= " FROM `bank_letter` bl";
        $sql .= " INNER JOIN `bank_letter_detail` bld ON bld.`bank_letter_id` = bl.`bank_letter_id`";
        $sql .= " INNER JOIN `employee_registration` er ON er.`employee_registration_id` = bld.`employee_registration_id`";
        $sql .= " INNER JOIN `employee` e ON e.`employee_id` = er.`employee_id`";
        $sql .= " INNER JOIN `department` d ON d.`department_id` = er.`department_id`";
        $sql .= " WHERE bl.`bank_letter_id` = '$bank_letter_id'";
        $query = $this->db->query($sql);
        return $query->rows;
    }
}

?>