<?php

class ModelPayrollBankLetterDetail extends HModel {

    protected function getTable() {
        return 'bank_letter_detail';
    }

    //protected function getView() {
    //    return 'vw_deposit_slip';
    //}

    public function getRTGSDetails($bank_letter_id) {
        $sql = "SELECT bld.`bank_name`, bld.`bank_title`, bld.`bank_iban`,bld.`amount`, e.`cnic_no`, bl.`bank_reference`";
        $sql .= " FROM `bank_letter_detail` bld";
        $sql .= " INNER JOIN `bank_letter` bl ON bl.`bank_letter_id` = bld.`bank_letter_id` AND bl.bank_letter_id='$bank_letter_id'";
        $sql .= " LEFT JOIN employee e ON e.`employee_id` = bld.`employee_id`";
        $sql .= " ORDER BY bld.bank_name";

        $query = $this->conn->query($sql);
        return $query->rows;
    }


    public function getRecord($filter=array(), $sort_order=array()) {
        $sql = "SELECT bl.*, bld.`bank_letter_detail_id`, bld.`source_table`, bld.`source_table_id`";
        $sql.= " , bld.`employee_registration_id`, bld.`employee_id`, bld.`employee_code`, bld.`registration_code`, bld.`employee_name`";
        $sql.= " , bld.`bank_id` AS employee_bank_id, bld.`bank_name` AS employee_bank_name, bld.`bank_title` AS employee_bank_title, bld.`bank_iban` AS employee_bank_iban, amount";
        $sql.= " FROM `bank_letter` bl";
        $sql.= " INNER JOIN `bank_letter_detail` bld ON bl.`bank_letter_id` = bld.`bank_letter_id`";
        if($filter) {
            if(is_array($filter)) {
                //$table_columns = $this->getTableColumns($this->getTable());
                $implode = array();
                foreach($filter as $column => $value) {
                    //if(in_array($column,$table_columns)) {
                    $implode[] = "`$column`='$value'";
                    //}
                }
                if($implode)
                    $sql .= " WHERE " . implode(" AND ", $implode);
            } else {
                $sql .= " WHERE " . $filter;
            }

        }

        if($sort_order) {
            $sql .= " ORDER BY " . implode(',',$sort_order);
        }

        //d($sql,true);
        $query = $this->conn->query($sql);
        return $query->row;
    }

    public function getRecords($filter=array(), $sort_order=array()) {
        $sql = "SELECT bl.*, bld.`bank_letter_detail_id`, bld.`source_table`, bld.`source_table_id`";
        $sql.= " , bld.`employee_registration_id`, bld.`employee_id`, bld.`employee_code`, bld.`registration_code`, bld.`employee_name`";
        $sql.= " , bld.`bank_id` AS employee_bank_id, bld.`bank_name` AS employee_bank_name, bld.`bank_title` AS employee_bank_title, bld.`bank_iban` AS employee_bank_iban, amount";
        $sql.= " FROM `bank_letter` bl";
        $sql.= " INNER JOIN `bank_letter_detail` bld ON bl.`bank_letter_id` = bld.`bank_letter_id`";
        if($filter) {
            if(is_array($filter)) {
                //$table_columns = $this->getTableColumns($this->getTable());
                $implode = array();
                foreach($filter as $column => $value) {
                    //if(in_array($column,$table_columns)) {
                    $implode[] = "$column='$value'";
                    //}
                }
                if($implode)
                    $sql .= " WHERE " . implode(" AND ", $implode);
            } else {
                $sql .= " WHERE " . $filter;
            }

        }

        if($sort_order) {
            $sql .= " ORDER BY " . implode(',',$sort_order);
        }

        //d($sql,true);
        $query = $this->conn->query($sql);
        return $query->rows;
    }

    public function getColumnRecords($columns, $filter=null, $sort_order=null) {
        $sql = "SELECT ".implode(",", $columns);
        $sql .= " FROM `bank_letter` bl";
        $sql .= " INNER JOIN `bank_letter_detail` bld ON bld.bank_letter_id = bl.bank_letter_id";
        $sql .= " INNER JOIN `employee_registration` er ON er.employee_registration_id = bld.employee_registration_id";
        $sql .= " INNER JOIN `employee` e ON e.employee_id = er.employee_id";
        $sql .= " LEFT JOIN `employee_arabic_name` ean ON ean.its_no = e.its_no";
        $sql .= " LEFT JOIN `department` dp ON dp.department_id = er.department_id";
        $sql .= " LEFT JOIN `designation` d ON d.designation_id = er.designation_id";
        $sql .= " LEFT JOIN `bank` bnk ON bnk.bank_id = bld.bank_id";
        $sql .= " CROSS JOIN (SELECT @rownum:=0) r";
        if($filter) {
            if(is_array($filter)) {
                //$table_columns = $this->getTableColumns($this->getTable());
                $implode = array();
                foreach($filter as $column => $value) {
                    //if(in_array($column,$table_columns)) {
                    $implode[] = "$column='$value'";
                    //}
                }
                if($implode)
                    $sql .= " WHERE " . implode(" AND ", $implode);
            } else {
                $sql .= " WHERE " . $filter;
            }

        }

        if($sort_order) {
            $sql .= " ORDER BY " . implode(',',$sort_order);
        }

        //d($sql,true);
        $query = $this->conn->query($sql);
        return $query->rows;

    }
}

?>