<?php

class ModelPayrollPayroll extends HModel {

    protected function getTable() {
        return 'payroll';
    }

    protected function getView() {
        //return 'vw_payroll';
        return $this->getQuery();
    }

    private function getQuery() {
        $sql = "(";
        $sql .= "SELECT p.*,";
        $sql .= " `p`.`department`                AS `department_name`,";
        $sql .= " `p`.`designation`                AS `designation_name`,";
        $sql .= " `c`.`parent_company_id`         AS `parent_company_id`,";
        $sql .= " `e`.`employee_code`             AS `employee_code`,";
        $sql .= " `er`.`registration_code`        AS `registration_code`,";
        $sql .= " `e`.`full_name`                 AS `employee_name`,";
        $sql .= " `e`.`dob`                       AS `dob`,";
        $sql .= " `er`.`joining_date`             AS `joining_date`,";
        $sql .= " `e`.`mobile_no`                 AS `mobile_no`,";
        $sql .= " `e`.`phone_no`                  AS `phone_no`,";
        $sql .= " `e`.`email`                     AS `email`,";
        $sql .= " `e`.`cnic_no`                   AS `cnic_no`,";
        $sql .= " `e`.`cnic_name`                 AS `cnic_name`,";
        $sql .= " `e`.`cnic_address`              AS `cnic_address`,";
        $sql .= " `e`.`eobi_date`                 AS `eobi_date`,";
        //$sql .= " `e`.`eobi_no`                   AS `eobi_no`,";
        $sql .= " `e`.`ntn_no`                    AS `ntn_no`,";
        $sql .= " `d`.`party_id`                  AS `dept_party_id`,";
        $sql .= " `d`.`ah_key`                    AS `dept_ah_key`,";
        $sql .= " `d`.`budget_key`                AS `dept_budget_key`,";
        $sql .= " `c`.`eobi_party_id`             AS `eobi_party_id`,";
        $sql .= " `c`.`eobi_ah_key`               AS `eobi_ah_key`,";
        $sql .= " `c`.`tax_party_id`              AS `tax_party_id`,";
        $sql .= " `c`.`tax_ah_key`                AS `tax_ah_key`";
        $sql .= " FROM `payroll` p";
        $sql .= " LEFT JOIN `employee_registration` er ON er.`employee_registration_id` = p.`employee_registration_id`";
        $sql .= " LEFT JOIN `employee` e ON e.`employee_id` = er.`employee_id`";
        $sql .= " LEFT JOIN `company` c ON c.`company_id` = er.`company_id`";
        $sql .= " LEFT JOIN `department` d ON d.`department_id` = er.`department_id`";
        $sql .= " LEFT JOIN `designation` ds ON ds.`designation_id` = er.`designation_id`";
        $sql .= " LEFT JOIN `attendance_shift` s ON s.attendance_shift_id = er.`attendance_shift_id`";
        $sql .= " LEFT JOIN `bank` b ON b.`bank_id` = er.`bank_id`";
        $sql .= " WHERE p.company_id='".$this->session->data['company_id']."' AND p.fiscal_year_id='".$this->session->data['fiscal_year_id']."'";
        $sql .= " ) as p";

        return $sql;
    }

    public function getRecord($filter=NULL, $sort_order=NULL, $column=null) {
        $sql = "SELECT p.*,";
        $sql .= " `p`.`department`                AS `department_name`,";
        $sql .= " `p`.`designation`                AS `designation_name`,";
        $sql .= " `c`.`parent_company_id`         AS `parent_company_id`,";
        $sql .= " `e`.`employee_code`             AS `employee_code`,";
        $sql .= " `er`.`registration_code`        AS `registration_code`,";
        $sql .= " `e`.`full_name`                 AS `employee_name`,";
        $sql .= " `e`.`dob`                       AS `dob`,";
        $sql .= " `er`.`joining_date`             AS `joining_date`,";
        $sql .= " `e`.`mobile_no`                 AS `mobile_no`,";
        $sql .= " `e`.`phone_no`                  AS `phone_no`,";
        $sql .= " `e`.`email`                     AS `email`,";
        $sql .= " `e`.`cnic_no`                   AS `cnic_no`,";
        $sql .= " `e`.`cnic_name`                 AS `cnic_name`,";
        $sql .= " `e`.`cnic_address`              AS `cnic_address`,";
        $sql .= " `e`.`eobi_date`                 AS `eobi_date`,";
        $sql .= " `e`.`ntn_no`                    AS `ntn_no`,";
        $sql .= " `d`.`party_id`                  AS `dept_party_id`,";
        $sql .= " `d`.`ah_key`                    AS `dept_ah_key`,";
        $sql .= " `d`.`budget_key`                AS `dept_budget_key`,";
        $sql .= " `c`.`eobi_party_id`             AS `eobi_party_id`,";
        $sql .= " `c`.`eobi_ah_key`               AS `eobi_ah_key`,";
        $sql .= " `c`.`tax_party_id`              AS `tax_party_id`,";
        $sql .= " `c`.`tax_ah_key`                AS `tax_ah_key`";
        $sql .= " FROM `payroll` p";
        $sql .= " LEFT JOIN `employee_registration` er ON er.`employee_registration_id` = p.`employee_registration_id`";
        $sql .= " LEFT JOIN `employee` e ON e.`employee_id` = er.`employee_id`";
        $sql .= " LEFT JOIN `company` c ON c.`company_id` = er.`company_id`";
        $sql .= " LEFT JOIN `department` d ON d.`department_id` = er.`department_id`";
        $sql .= " LEFT JOIN `designation` ds ON ds.`designation_id` = er.`designation_id`";
        $sql .= " LEFT JOIN `attendance_shift` s ON s.attendance_shift_id = er.`attendance_shift_id`";
        $sql .= " LEFT JOIN `bank` b ON b.`bank_id` = er.`bank_id`";

        if($filter) {
            if(is_array($filter)) {
                //$table_columns = $this->getTableColumns($this->getTable());
                $implode = array();
                foreach($filter as $column => $value) {
                    //if(in_array($column,$table_columns)) {
                    $implode[] = "$column='$value'";
                    //}
                }
                if($implode)
                    $sql .= " WHERE " . implode(" AND ", $implode);
            } else {
                $sql .= " WHERE " . $filter;
            }
        }

        if($sort_order) {
            $sql .= " ORDER BY " . implode(',',$sort_order);
        }

        $query = $this->conn->query($sql);
        return $query->row;
    }

    public function getRecords($filter=NULL, $sort_order=NULL, $limit='') {
        $sql = "SELECT p.*,";
        $sql .= " `p`.`department`                AS `department_name`,";
        $sql .= " `p`.`designation`                AS `designation_name`,";
        $sql .= " `c`.`parent_company_id`         AS `parent_company_id`,";
        $sql .= " `e`.`employee_code`             AS `employee_code`,";
        $sql .= " `er`.`registration_code`        AS `registration_code`,";
        $sql .= " `e`.`full_name`                 AS `employee_name`,";
        $sql .= " `e`.`dob`                       AS `dob`,";
        $sql .= " `er`.`joining_date`             AS `joining_date`,";
        $sql .= " `e`.`mobile_no`                 AS `mobile_no`,";
        $sql .= " `e`.`phone_no`                  AS `phone_no`,";
        $sql .= " `e`.`email`                     AS `email`,";
        $sql .= " `e`.`cnic_no`                   AS `cnic_no`,";
        $sql .= " `e`.`cnic_name`                 AS `cnic_name`,";
        $sql .= " `e`.`cnic_address`              AS `cnic_address`,";
        $sql .= " `e`.`eobi_date`                 AS `eobi_date`,";
        $sql .= " `e`.`ntn_no`                    AS `ntn_no`,";
        $sql .= " `d`.`party_id`                  AS `dept_party_id`,";
        $sql .= " `d`.`ah_key`                    AS `dept_ah_key`,";
        $sql .= " `d`.`budget_key`                AS `dept_budget_key`,";
        $sql .= " `c`.`eobi_party_id`             AS `eobi_party_id`,";
        $sql .= " `c`.`eobi_ah_key`               AS `eobi_ah_key`,";
        $sql .= " `c`.`tax_party_id`              AS `tax_party_id`,";
        $sql .= " `c`.`tax_ah_key`                AS `tax_ah_key`";
        $sql .= " FROM `payroll` p";
        $sql .= " LEFT JOIN `employee_registration` er ON er.`employee_registration_id` = p.`employee_registration_id`";
        $sql .= " LEFT JOIN `employee` e ON e.`employee_id` = er.`employee_id`";
        $sql .= " LEFT JOIN `company` c ON c.`company_id` = er.`company_id`";
        $sql .= " LEFT JOIN `department` d ON d.`department_id` = er.`department_id`";
        $sql .= " LEFT JOIN `designation` ds ON ds.`designation_id` = er.`designation_id`";
        $sql .= " LEFT JOIN `attendance_shift` s ON s.attendance_shift_id = er.`attendance_shift_id`";
        $sql .= " LEFT JOIN `bank` b ON b.`bank_id` = er.`bank_id`";

        if($filter) {
            if(is_array($filter)) {
                //$table_columns = $this->getTableColumns($this->getTable());
                $implode = array();
                foreach($filter as $column => $value) {
                    //if(in_array($column,$table_columns)) {
                    $implode[] = "$column='$value'";
                    //}
                }
                if($implode)
                    $sql .= " WHERE " . implode(" AND ", $implode);
            } else {
                $sql .= " WHERE " . $filter;
            }
        }

        if($sort_order) {
            $sql .= " ORDER BY " . implode(',',$sort_order);
        }

        if($limit) {
            $sql .= " LIMIT ".$limit;
        }

        $query = $this->conn->query($sql);
        return $query->rows;
    }

    public function getTaxDetail($post) {
        //d($post, true);
        $eobi_female_age_limit = 55;
        $eobi_male_age_limit = 60;
        $tax_age_limit = 60;
        $amount_limit = 1000000;
        $tax_leniency_percent = 50;

        $parent_company_id = $post['parent_company_id'];
        $company_id = $post['company_id'];
        $employee_registration_id = $post['employee_registration_id'];
        $employee_id = $post['employee_id'];
        $fiscal_year_id = $post['fiscal_year_id'];
        $document_date = $post['document_date'];
        $from_date = $post['from_date'];
        $to_date = $post['to_date'];
        $taxable_current_salary = $post['taxable_salary'];
        $age = $post['age'];
        $gender = $post['gender'];
        $exclude_payroll = $post['exclude_payroll'];
        $emp_reg = $post['registration'];

        $arrWhere = [];
        $arrWhere[] = "`employee_id` = '".$employee_id."'";
        $arrWhere[] = "`status` = 'Active'";
        if($parent_company_id != 0) {
            $arrWhere[] = "`parent_company_id` = '".$parent_company_id."'";
        } else {
            $arrWhere[] = "`company_id` = '".$company_id."'";
        }

        $sql = "SELECT *";
        $sql .= " FROM `vw_employee_registration`";
        $sql .= " WHERE " . implode(" AND ", $arrWhere);
        $query = $this->conn->query($sql);
        $registrations = $query->rows;
        $arrTaxDescription = array();
        $current_remaining_payroll = 0;
        foreach($registrations as $registration) {
            $total_payroll = $registration['total_payroll'];
            $remaining_payroll = $total_payroll;

            $arrWhere = array();
            $arrWhere[] = "`employee_registration_id`='".$registration['employee_registration_id']."'";
            $arrWhere[] = "`wef_date` <='".$document_date."'";
            $sql = "SELECT *";
            $sql .= " FROM `employee_salary`";
            $sql .= " WHERE " . implode(" AND ", $arrWhere);
            $sql .= " ORDER BY wef_date DESC, created_at desc";
            $query = $this->conn->query($sql);
            $salary = $query->row;
            $monthly_taxable_salary = $salary['taxable_amount'];

            $arrWhere = array();
            $arrWhere[] = "`employee_registration_id`='".$registration['employee_registration_id']."'";
            $arrWhere[] = "`fiscal_year_id` ='".$fiscal_year_id."'";
            $sql = "SELECT *";
            $sql .= " FROM `payroll`";
            $sql .= " WHERE " . implode(" AND ", $arrWhere);
            $query = $this->conn->query($sql);
            $payrolls = $query->rows;

            $paid_payroll = 0;
            $taxable_paid_salary = 0;
            $tax_paid = 0;
            foreach ($payrolls as $payroll) {
                if($payroll['exclude_payroll']==0) {
                    $paid_payroll++;
                }
                $tax_paid += $payroll['tax_deduction'];
                $taxable_paid_salary += $payroll['taxable_salary'];
            }
            $remaining_payroll = ($paid_payroll>$total_payroll?0:$total_payroll-$paid_payroll);

            if($employee_registration_id==$registration['employee_registration_id']) {
                if($post['exclude_payroll']==0) {
                    $remaining_payroll--;
                }
                $taxable_current_salary = $post['taxable_salary'];
                $current_remaining_payroll = $remaining_payroll+1;
            } else {
                $taxable_current_salary = 0;
            }
            $taxable_remaining_salary = round($remaining_payroll * $monthly_taxable_salary);

            $arrWhere = array();
            $arrWhere[] = "`employee_registration_id`='".$registration['employee_registration_id']."'";
            $arrWhere[] = "`fiscal_year_id`='".$fiscal_year_id."'";
            $arrWhere[] = "`approved_status`='Approved'";
            $arrWhere[] = "`is_taxable`=1";

            $sql = "SELECT SUM(`approved_amount`) as amount";
            $sql .= " FROM `special_allowance`";
            $sql .= " WHERE " . implode(" AND ", $arrWhere);
            $query = $this->conn->query($sql);
            $row = $query->row;
            $taxable_paid_allowance = $row['amount'];

            $est_annual_taxable_salary = $taxable_paid_salary + $taxable_paid_allowance + $taxable_current_salary + $taxable_remaining_salary;

            $arrPayrolls[$registration['employee_registration_id']] = array(
                'employee_registration_id' => $registration['employee_registration_id'],
                'company_name' => $registration['company_name'],
                'department_name' => $registration['department_name'],
                'registration_code' => $registration['registration_code'],
                'total_payroll' => $total_payroll,
                'paid_payroll' => $paid_payroll,
                'remaining_payroll' => $remaining_payroll,
                'taxable_paid_salary' => $taxable_paid_salary,
                'taxable_paid_allowances' => $taxable_paid_allowance,
                'taxable_current_salary' => $taxable_current_salary,
                'taxable_monthly_salary' => $monthly_taxable_salary,
                'taxable_remaining_salary' => $taxable_remaining_salary,
                'estimated_annual_salary' => $est_annual_taxable_salary,
                'annual_tax_paid' => $tax_paid,
            );
        }

        $annual_taxable_paid_salary = 0;
        $annual_taxable_paid_allowance = 0;
        $annual_taxable_current_salary = 0;
        $annual_taxable_remaining_salary = 0;
        $annual_taxable_salary = 0;
        $annual_tax_paid = 0;
        $salary_count = 0;
        foreach($arrPayrolls as $payroll) {
            $arrTaxDescription[] = array(
                'description' => 'Company',
                'value' => $payroll['company_name'],
            );
            $arrTaxDescription[] = array(
                'description' => 'Department',
                'value' => $payroll['department_name'],
            );
            $arrTaxDescription[] = array(
                'description' => 'Reg. Code',
                'value' => $payroll['registration_code'],
            );
            $arrTaxDescription[] = array(
                'description' => 'Paid Taxable Salary',
                'value' => number_format($payroll['taxable_paid_salary'],2),
            );
            $arrTaxDescription[] = array(
                'description' => 'Paid Taxable Allowance',
                'value' => number_format($payroll['taxable_paid_allowances'],2),
            );
            if($payroll['taxable_current_salary'] > 0) {
                $arrTaxDescription[] = array(
                    'description' => 'Current Taxable Salary',
                    'value' => number_format($payroll['taxable_current_salary'],2),
                );
            }
            $arrTaxDescription[] = array(
                'description' => 'Remaining Taxable Salary ('.number_format($payroll['taxable_monthly_salary'],2).' x '.$payroll['remaining_payroll'].')',
                'value' => number_format($payroll['taxable_remaining_salary'],2),
            );
            $arrTaxDescription[] = array(
                'description' => 'Est. Annual Taxable Salary',
                'value' => number_format($payroll['estimated_annual_salary'],2),
            );
            $arrTaxDescription[] = array(
                'description' => 'Tax Paid',
                'value' => number_format($payroll['annual_tax_paid'],2),
                'break' => true
            );

            $annual_taxable_paid_salary += $payroll['taxable_paid_salary'];
            $annual_taxable_paid_allowance += $payroll['taxable_paid_allowances'];
            $annual_taxable_current_salary += $payroll['taxable_current_salary'];
            $annual_taxable_remaining_salary += $payroll['taxable_remaining_salary'];
            $annual_taxable_salary += $payroll['estimated_annual_salary'];
            $annual_tax_paid += $payroll['annual_tax_paid'];
            $salary_count++;
        }

        $arrTaxDescription[] = array(
            'description' => 'Total Taxable Salary',
            'value' => number_format($annual_taxable_salary,2),
        );

        $sql = "SELECT *";
        $sql .= " FROM `tax_slab`";
        $sql .= " WHERE fiscal_year_id = " . $fiscal_year_id;
        $sql .= " AND $annual_taxable_salary >= `range_from`";
        $sql .= " ORDER BY `range_from` DESC";
        $query = $this->conn->query($sql);
        $row = $query->row;
        $est_annual_tax_amount = round((($annual_taxable_salary-$row['range_from'])*$row['tax_percent']/100)+$row['additional']);
        $remaining_tax = $est_annual_tax_amount - $annual_tax_paid;
        $arrTaxDescription[] = array(
            'description' => 'Total Tax Amount',
            'value' => number_format($est_annual_tax_amount,2),
        );
        $arrTaxDescription[] = array(
            'description' => 'Total Paid Tax',
            'value' => number_format($annual_tax_paid,2),
        );
        $arrTaxDescription[] = array(
            'description' => 'Total Tax Remaining',
            'value' => number_format($remaining_tax,2),
        );
        $monthly_tax = ceil($remaining_tax / $current_remaining_payroll);
        $arrTaxDescription[] = array(
            'description' => 'Monthly Tax Deduction ('.number_format($remaining_tax,2).' / '.$current_remaining_payroll.')',
            'value' => number_format($monthly_tax,2),
        );


        return array(
            'tax_description' => $arrTaxDescription,
            'annual_taxable_paid_salary' => $annual_taxable_paid_salary,
            'annual_taxable_paid_allowance' => $annual_taxable_paid_allowance,
            'annual_taxable_current_salary' => $annual_taxable_current_salary,
            'annual_taxable_remaining_salary' => $annual_taxable_remaining_salary,
            'annual_taxable_salary' => $annual_taxable_salary,
            'annual_tax_amount' => $est_annual_tax_amount,
            'annual_tax_paid' => $annual_tax_paid,
            'remaining_tax' => $remaining_tax,
            'monthly_tax' => $monthly_tax,
            'salary_count' => $salary_count,
        );
    }

    public function getTotalGross($filter) {
        $sql = "SELECT SUM(`taxable_salary`) AS total_taxable";
        $sql .= " FROM `".$this->getView()."`";
        if($filter) {
            if(is_array($filter)) {
                $implode = array();
                foreach($filter as $column => $value) {
                    $implode[] = "`$column`='$value'";
                }
                if($implode)
                    $sql .= " WHERE " . implode(" AND ", $implode);
            } else {
                $sql .= " WHERE " . $filter;
            }
        }

        //d($sql,true);
        $query = $this->conn->query($sql);
        $row = $query->row;
        return empty($row['total_taxable'])?0:$row['total_taxable'];
    }

    public function getTotalTax($filter) {
        $sql = "SELECT SUM(`tax_deduction`) AS total_tax";
        $sql .= " FROM `".$this->getView()."`";
        if($filter) {
            if(is_array($filter)) {
                $implode = array();
                foreach($filter as $column => $value) {
                    $implode[] = "`$column`='$value'";
                }
                if($implode)
                    $sql .= " WHERE " . implode(" AND ", $implode);
            } else {
                $sql .= " WHERE " . $filter;
            }
        }

        $query = $this->conn->query($sql);
        $row = $query->row;
        return empty($row['total_tax'])?0:$row['total_tax'];
    }

    public function getTotalPayrolls($filter){
        $sql = "SELECT COUNT(*) AS total_payroll";
        $sql .= " FROM `".$this->getView()."`";
        if($filter){
            if(is_array($filter)){
                $implode = array();
                foreach($filter as $column => $value) {
                    $implode[] = "`$column`='$value'";
                }
                if($implode)
                    $sql .= " WHERE " . implode(" AND ", $implode);
            } else {
                $sql .= " WHERE " . $filter;
            }
        }
        // d($sql,true);
        $query = $this->conn->query($sql);
        $row = $query->row;
        return empty($row['total_payroll'])?0:$row['total_payroll'];
    }

    public function createTemporaryRegister($where) {
        $table_name = "temp_register_".date('YmdHis');
        $columns = array();

        $sql = "SELECT DISTINCT allowance_id, allowance_name";
        $sql .= " FROM `payroll_allowance` pa";
        $sql .= " INNER JOIN `vw_payroll` p ON p.`payroll_id` = pa.`payroll_id`";
        $sql .= " WHERE " . $where;
        $query = $this->db->query($sql);
        $allowances = $query->rows;

        $sql = "SELECT DISTINCT deduction_id, deduction_code, deduction_name";
        $sql .= " FROM `payroll_deduction` pd";
        $sql .= " INNER JOIN `vw_payroll` p ON p.`payroll_id` = pd.`payroll_id`";
        $sql .= " WHERE " . $where;
        $query = $this->db->query($sql);
        $deductions = $query->rows;

        $sql = "CREATE TABLE `".$table_name."`(";
        $sql .= " `payroll_id` CHAR(38) NOT NULL,";
        //$columns[] = array('column_type' => 'PRI', 'column_name'=>'payroll_id');
        $sql .= " `company_name` VARCHAR(255),";
        //$columns[] = array('column_type' => 'STR', 'column_name'=>'company_name');
        $sql .= " `department_name` VARCHAR(255),";
        $columns[] = array('column_type' => 'STR', 'column_name'=>'department_name');
        $sql .= " `Doc. Date` VARCHAR(255),";
        $columns[] = array('column_type' => 'DT', 'column_name'=>'Doc. Date');
        $sql .= " `document_title` VARCHAR(255),";
        //$columns[] = array('column_type' => 'STR', 'column_name'=>'document_title');
        $sql .= " `employee_registration_id` CHAR(38),";
        //$columns[] = array('column_type' => 'STR', 'column_name'=>'employee_registration_id');
        $sql .= " `employee_id` CHAR(38),";
        //$columns[] = array('column_type' => 'STR', 'column_name'=>'employee_id');
        $sql .= " `Reg No.` VARCHAR(255),";
        $columns[] = array('column_type' => 'STR', 'column_name'=>'Reg No.');
        $sql .= " `Name` VARCHAR(255),";
        $columns[] = array('column_type' => 'STR', 'column_name'=>'Name');
        $sql .= " `Department` VARCHAR(255),";
        $columns[] = array('column_type' => 'STR', 'column_name'=>'Department');
        $sql .= " `S&A` DECIMAL(11,2) NOT NULL DEFAULT 0.00,";
        $columns[] = array('column_type' => 'NUM', 'column_name'=>'S&A');
        $sql .= " `Salary` DECIMAL(11,2) NOT NULL DEFAULT 0.00,";
        $columns[] = array('column_type' => 'NUM', 'column_name'=>'Salary');
        $sql .= " `Arrears` DECIMAL(11,2) NOT NULL DEFAULT 0.00,";
        $columns[] = array('column_type' => 'NUM', 'column_name'=>'Arrears');
        foreach($allowances as $allowance) {
            $sql .= " `".$allowance['allowance_name']."` DECIMAL(11,2) NOT NULL DEFAULT 0.00,";
            $columns[] = array('column_type' => 'NUM', 'column_name'=>$allowance['allowance_name']);
        }
        $sql .= " `MADD` DECIMAL(11,2) NOT NULL DEFAULT 0.00,";
        $columns[] = array('column_type' => 'NUM', 'column_name'=>'MADD');
        $sql .= " `OVT` DECIMAL(11,2) NOT NULL DEFAULT 0.00,";
        $columns[] = array('column_type' => 'NUM', 'column_name'=>'OVT');
        $sql .= " `Gross` DECIMAL(11,2) NOT NULL DEFAULT 0.00,";
        $columns[] = array('column_type' => 'NUM', 'column_name'=>'Gross');
        foreach($deductions as $deduction) {
            $sql .= " `".$deduction['deduction_code']."` DECIMAL(11,2) NOT NULL DEFAULT 0.00,";
            $columns[] = array('column_type' => 'NUM', 'column_name'=>$deduction['deduction_code']);
        }
        $sql .= " `MDED` DECIMAL(11,2) NOT NULL DEFAULT 0.00,";
        $columns[] = array('column_type' => 'NUM', 'column_name'=>'MDED');
        $sql .= " `TAX` DECIMAL(11,2) NOT NULL DEFAULT 0.00,";
        $columns[] = array('column_type' => 'NUM', 'column_name'=>'TAX');
        $sql .= " `ATT Deduction` DECIMAL(11,2) NOT NULL DEFAULT 0.00,";
        $columns[] = array('column_type' => 'NUM', 'column_name'=>'ATT Deduction');
        $sql .= " `Payable` DECIMAL(11,2) NOT NULL DEFAULT 0.00,";
        $columns[] = array('column_type' => 'NUM', 'column_name'=>'Payable');
        $sql .= " `CHQ` VARCHAR(255) NOT NULL,";
        $columns[] = array('column_type' => 'STR', 'column_name'=>'CHQ');
        $sql .= " PRIMARY KEY (`payroll_id`),";
        $sql .= " INDEX `employee_id` (`employee_id`),";
        $sql .= " INDEX `employee_registration_id` (`employee_registration_id`),";
        $sql .= " INDEX `department_name` (`department_name`),";
        $sql .= " INDEX `Reg No.` (`Reg No.`)";
        $sql .= " )";
        $this->db->query($sql);


        $sql = "INSERT INTO `".$table_name."`";
        $sql .= "SELECT p.`payroll_id`, c.company_name, d.department_name, p.`document_date`, p.`document_title`, p.`employee_registration_id`, p.`employee_id`, p.`registration_code` as 'Reg No.', e.`full_name` as Name,d.department_name as Department";
        $sql .= ", ((p.`basic_salary`+p.`arrears`+p.`grossable_allowance` + p.`house_rent_allowance`+p.`manual_addition`+p.`overtime`) - (p.`attendance_deduction`+p.`manual_deduction`)) as 'S&A', p.`basic_salary` as Salary, p.`arrears` as Arrears";
        foreach($allowances as $allowance) {
            $sql .= ", (SELECT allowance_amount FROM `payroll_allowance` pa WHERE pa.`payroll_id`=p.`payroll_id` AND pa.`allowance_id`='".$allowance['allowance_id']."') AS '".$allowance['allowance_name']."'";
        }
        $sql .= ", p.`manual_addition` AS MADD, p.`overtime` AS OVT";
        //$sql .= ", (p.`basic_salary`+p.`arrears`+p.`other_allowance`+p.`manual_addition`+p.`overtime`) as Gross";
        $sql .= ", p.gross_salary as Gross";
        foreach($deductions as $deduction) {
            $sql .= ", (SELECT SUM(deduction_amount) FROM `payroll_deduction` pd WHERE pd.`payroll_id`=p.`payroll_id` AND pd.`deduction_id`='".$deduction['deduction_id']."') AS '".$deduction['deduction_code']."'";
        }
        $sql .= ", p.`manual_deduction` AS MDED";
        //$sql .= ", p.`tax_deduction` AS TAX, p.`attendance_deduction` AS 'ATT Deduction', p.`payable_salary` AS 'Payable', ds.cheque_no as CHQ";
        $sql .= ", p.`tax_deduction` AS TAX, p.`attendance_deduction` AS 'ATT Deduction', p.`payable_salary` AS 'Payable'";
        $sql .= ", IF(";
        $sql .= "(SELECT icd.cheque_no FROM `individual_cheque_detail` icd WHERE icd.source_table_id=p.`payroll_id`) IS NOT NULL";
        $sql .= ",(SELECT icd.cheque_no FROM `individual_cheque_detail` icd WHERE icd.source_table_id=p.`payroll_id`)";
        $sql .= ",(SELECT bl.cheque_no FROM `bank_letter` bl INNER JOIN `bank_letter_detail` bld ON bld.bank_letter_id=bl.bank_letter_id WHERE bld.source_table_id=p.`payroll_id`)";
        $sql .= ") AS CHQ";
        $sql .= " FROM `vw_payroll` p";
        $sql .= " INNER JOIN `employee` e ON e.`employee_id` = p.`employee_id`";
        $sql .= " INNER JOIN `company` c ON c.`company_id` = p.`company_id`";
        $sql .= " INNER JOIN `department` d ON d.`department_id` = p.`department_id`";
        //$sql .= " LEFT JOIN `deposit_slip` ds ON ds.`deposit_slip_id` = p.`deposit_slip_id`";
        $sql .= " WHERE " . $where;
        //$sql .= " ORDER BY d.department_name, e.employee_code, document_date";
        $query = $this->db->query($sql);

        $sql = "SELECT ";
        $arrColumns = array();
        foreach($columns as $column) {
            if($column['column_type']=='NUM') {
                $arrColumns[] = "SUM(`".$column['column_name']."`) as '".$column['column_name']."'";
            } else {
                $arrColumns[] = "`".$column['column_name']."`";
            }
        }
        $sql .= implode(',',$arrColumns);
        $sql .= " FROM `".$table_name."`";
        $sql .= " GROUP BY department_name, `Reg No.`";
        $sql .= " ORDER BY department_name, `Reg No.`";
        $query = $this->db->query($sql);
        $rows = $query->rows;

        $sql = "DROP TABLE `".$table_name."`";
        $this->db->query($sql);

        return $rows;
    }

    public function getRegister($where) {
        $sql = "SELECT DISTINCT allowance_id, allowance_name";
        $sql .= " FROM `payroll_allowance` pa";
        $sql .= " INNER JOIN `vw_payroll` p ON p.`payroll_id` = pa.`payroll_id`";
        $sql .= " WHERE " . $where;
        $sql .= " ORDER BY pa.allowance_name ";
        $query = $this->db->query($sql);
        $allowances = $query->rows;

        $sql = "SELECT DISTINCT deduction_id, deduction_code, deduction_name";
        $sql .= " FROM `payroll_deduction` pd";
        $sql .= " INNER JOIN `vw_payroll` p ON p.`payroll_id` = pd.`payroll_id`";
        $sql .= " WHERE " . $where;
        $sql .= " ORDER BY pd.deduction_name ";
        $query = $this->db->query($sql);
        $deductions = $query->rows;
        //d(array($sql, $deductions), true);

        $sql = "SELECT p.`payroll_id`, c.company_id, c.company_name, p.ntn_no, p.cnic_name, p.department_name, p.designation_name, p.joining_date, p.cnic_no, p.`document_date` as 'Doc. Date', p.`document_title`, p.`employee_registration_id`, p.`employee_id`, ds.account_title as 'Acc. Title', ds.account_no as 'Acc. No.', p.`registration_code` as 'Reg No.', e.`full_name` as Name".PHP_EOL;
        $sql .= ", ((p.`basic_salary`+p.`arrears`+p.`grossable_allowance` + p.`house_rent_allowance`+p.`manual_addition`+p.`overtime`) - (p.`attendance_deduction`+p.`manual_deduction`)) as 'S&A', p.`basic_salary` as Salary, p.`arrears` as Arrears".PHP_EOL;
        foreach($allowances as $allowance) {
            $sql .= ", (SELECT allowance_amount FROM `payroll_allowance` pa WHERE pa.`payroll_id`=p.`payroll_id` AND pa.grossable=1 AND pa.`allowance_id`='".$allowance['allowance_id']."') AS '".$allowance['allowance_name']."'".PHP_EOL;
        }
        $sql .= ", p.`manual_addition` AS MADD, p.`overtime` AS OVT".PHP_EOL;
        $sql .= ", `gross_salary` as Gross".PHP_EOL;
        foreach($deductions as $deduction) {
            $sql .= ", (SELECT SUM(deduction_amount) FROM `payroll_deduction` pd WHERE pd.`payroll_id`=p.`payroll_id` AND pd.`deduction_id`='".$deduction['deduction_id']."') AS '".$deduction['deduction_code']."'".PHP_EOL;
        }
        $sql .= ", p.`manual_deduction` AS MDED".PHP_EOL;
        $sql .= ", p.`tax_deduction` AS TAX, p.`attendance_deduction` AS 'ATT Deduction', p.`payable_salary` AS 'Payable'".PHP_EOL;
        $sql .= ", ds.cheque_no as CHQ, ds.cheque_date as chq_date".PHP_EOL;
        $sql .= " FROM `vw_payroll` p".PHP_EOL;
        $sql .= " INNER JOIN `employee` e ON e.`employee_id` = p.`employee_id`".PHP_EOL;
        $sql .= " INNER JOIN `company` c ON c.`company_id` = p.`company_id`".PHP_EOL;
        //$sql .= " INNER JOIN `department` d ON d.`department_id` = p.`department_id`";
        //$sql .= " LEFT JOIN `designation` ds ON ds.`designation_id` = p.`designation_id`";
        //$sql .= " LEFT JOIN `deposit_slip` ds ON ds.`deposit_slip_id` = p.`deposit_slip_id`".PHP_EOL;
        //$sql .= " LEFT JOIN `deposit_slip_detail` dsd ON dsd.`deposit_slip_id` = ds.`deposit_slip_id` AND dsd.`employee_registration_id` = p.`employee_registration_id`".PHP_EOL;
        $sql .= " LEFT JOIN (".PHP_EOL;
        $sql .= " SELECT ic.`individual_cheque_id` AS document_id, ic.`document_identity`, icd.`source_table_id`, icd.`employee_registration_id`, icd.`employee_id`, '' as account_no, '' as account_title, icd.`cheque_date`, icd.`cheque_no`, icd.`cheque_amount` AS amount".PHP_EOL;
        $sql .= " FROM `individual_cheque_detail` icd".PHP_EOL;
        $sql .= " INNER JOIN `individual_cheque` ic ON ic.`individual_cheque_id` = icd.`individual_cheque_id` AND ic.`source_type`='payroll' AND ic.`company_id`='".$this->session->data['company_id']."'".PHP_EOL;
        $sql .= " UNION".PHP_EOL;
        $sql .= " SELECT bl.`bank_letter_id` AS document_id, bl.`document_identity`, bld.`source_table_id`, bld.`employee_registration_id`, bld.`employee_id`, bld.`bank_iban` as account_no, bld.`bank_title` as account_title, bl.`cheque_date`, bl.`cheque_no`, bld.`amount`".PHP_EOL;
        $sql .= " FROM `bank_letter_detail` bld".PHP_EOL;
        $sql .= " INNER JOIN `bank_letter` bl ON bl.`bank_letter_id`=bld.`bank_letter_id` AND bl.`source_type`='payroll' AND bl.`company_id`='".$this->session->data['company_id']."'".PHP_EOL;
        $sql .= " ) as ds on ds.source_table_id=p.payroll_id".PHP_EOL;
        $sql .= " WHERE " . $where.PHP_EOL;
        $sql .= " ORDER BY p.department_name, e.employee_code, document_date".PHP_EOL;
        //d($sql, true);
        $query = $this->db->query($sql);
        //d($query,true);
        return $query->rows;
    }

    public function getRegisterSummary($where) {
        $fiscal_year_id = $this->session->data['fiscal_year_id'];

        $sql = "SELECT DISTINCT allowance_id, allowance_name";
        $sql .= " FROM `payroll_allowance` pa";
        $sql .= " INNER JOIN `vw_payroll` p ON p.`payroll_id` = pa.`payroll_id`";
        $sql .= " WHERE " . $where;
        $query = $this->db->query($sql);
        $allowances = $query->rows;

        $sql = "SELECT DISTINCT deduction_id, deduction_code, deduction_name";
        $sql .= " FROM `payroll_deduction` pd";
        $sql .= " INNER JOIN `vw_payroll` p ON p.`payroll_id` = pd.`payroll_id`";
        $sql .= " WHERE " . $where;
        $query = $this->db->query($sql);
        $deductions = $query->rows;
        //d(array($sql, $deductions), true);

        $sql = "SELECT department_name, `Reg No.`, `Name`";
        $sql .= ", SUM(`S&A`) AS 'S&A', SUM(`Arrears`) AS 'Arrears'";
        foreach($allowances as $allowance) {
            $sql .= ", SUM(`".$allowance['allowance_name']."`) AS '".$allowance['allowance_name']."'";
        }
        $sql .= ", SUM(`MADD`) AS MADD, SUM(`OVT`) AS OVT, SUM(`Gross`) AS 'Gross'";
        foreach($deductions as $deduction) {
            $sql .= ", SUM(`".$deduction['deduction_code']."`) AS '".$deduction['deduction_code']."'";
        }
        $sql .= ", SUM(`MDED`) AS MDED, SUM(`TAX`) AS TAX, SUM(`ATT Deduction`) AS 'ATT Deduction', SUM(`Payable`) AS 'Payable'";
        $sql .= " FROM (";
        $sql .= "SELECT p.`payroll_id`, c.company_name, d.department_name, p.`document_date`, p.`document_title`, p.`employee_registration_id`, p.`employee_id`, p.`registration_code` as 'Reg No.', e.`full_name` as Name";
        $sql .= ", ((p.`basic_salary`+p.`arrears`+p.`other_allowance` + p.`house_rent_allowance`+p.`manual_addition`+p.`overtime`) - (p.`attendance_deduction`+p.`manual_deduction`)) as 'S&A', p.`basic_salary` as Salary, p.`arrears` as Arrears";
        foreach($allowances as $allowance) {
            $sql .= ", (SELECT allowance_amount FROM `payroll_allowance` pa WHERE pa.`payroll_id`=p.`payroll_id` AND pa.`allowance_id`='".$allowance['allowance_id']."') AS '".$allowance['allowance_name']."'";
        }
        $sql .= ", p.`manual_addition` AS MADD, p.`overtime` AS OVT";
        //$sql .= ", (p.`basic_salary`+p.`arrears`+p.`other_allowance`+p.`manual_addition`+p.`overtime`) as Gross";
        $sql .= ", p.gross_salary as Gross";
        foreach($deductions as $deduction) {
            $sql .= ", (SELECT SUM(deduction_amount) FROM `payroll_deduction` pd WHERE pd.`payroll_id`=p.`payroll_id` AND pd.`deduction_id`='".$deduction['deduction_id']."') AS '".$deduction['deduction_code']."'";
        }
        $sql .= ", p.`manual_deduction` AS MDED";
        $sql .= ", p.`tax_deduction` AS TAX, p.`attendance_deduction` AS 'ATT Deduction', p.`payable_salary` AS 'Payable', ds.cheque_no as CHQ";
        $sql .= " FROM `vw_payroll` p";
        $sql .= " INNER JOIN `employee` e ON e.`employee_id` = p.`employee_id`";
        $sql .= " INNER JOIN `company` c ON c.`company_id` = p.`company_id`";
        $sql .= " INNER JOIN `department` d ON d.`department_id` = p.`department_id`";
        $sql .= " LEFT JOIN `deposit_slip` ds ON ds.`deposit_slip_id` = p.`deposit_slip_id`";
        $sql .= " WHERE " . $where;
        $sql .= " ) pr ";
        $sql .= " GROUP BY department_name, `Reg No.`";
        $sql .= " ORDER BY department_name, `Reg No.`";
        //d($sql, true);
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getPendingEmployees() {
        $sql = "SELECT DISTINCT employee_registration_id, registration_code, employee_code, employee_name";
        $sql .= " FROM `vw_payroll`";
        $sql .= " WHERE deposit_slip_id = ''";
        $sql .= " AND company_id = '".$this->session->data['company_id']."'";

        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getPostedDocument($payroll_id) {
        $sql = "SELECT bno AS bucket_no, cheque_date, cheque_no, document_identity";
        $sql .= " FROM `bank_letter_detail` bld";
        $sql .= " INNER JOIN `bank_letter` bl ON bl.`bank_letter_id` = bld.`bank_letter_id`";
        $sql .= " WHERE `source_table` = 'Payroll' AND `source_table_id` = '$payroll_id'";
        $sql .= " UNION ALL";
        $sql .= " SELECT bno AS bucket_no, cheque_date, cheque_no, document_identity";
        $sql .= " FROM `individual_cheque_detail` icd";
        $sql .= " INNER JOIN `individual_cheque` ic ON ic.`individual_cheque_id` = icd.individual_cheque_id";
        $sql .= " WHERE `source_table` = 'Payroll' AND `source_table_id` = '$payroll_id'";

        $query = $this->db->query($sql);
        return $query->row;
    }
}
?>