<?php

class ModelPayrollSpecialAllowance extends HModel {

    protected function getTable() {
        return 'special_allowance';
    }

    protected function defaultColumns() {
        $sql = "sa.*, sat.`special_allowance_type`, sat.`budget_key`";
        $sql .= ", c.`company_name`, er.`department_id`, d.`department_name`";
        $sql .= ", er.`employee_id`, e.`employee_code`, e.`full_name` AS employee_name, e.`employee_image`, e.`its_no`";

        return $sql;
    }

    protected function getTableJoins() {
        $sql  = " FROM `special_allowance` sa";
        $sql .= " INNER JOIN `special_allowance_type` sat ON sat.`special_allowance_type_id` = sa.`special_allowance_type_id`";
        $sql .= " INNER JOIN `employee_registration` er ON er.`employee_registration_id` = sa.`employee_registration_id`";
        $sql .= " INNER JOIN `employee` e ON e.`employee_id` = er.`employee_id`";
        $sql .= " LEFT JOIN `company` c ON c.`company_id` = er.`company_id`";
        $sql .= " LEFT JOIN `department` d ON d.`department_id` = er.`department_id`";

        return $sql;
    }

    protected function getView() {
        return 'vw_special_allowance';
    }

    public function getLists($filter=NULL, $criteria=NULL) {
        $sql = "select count(*) as total ";
        $sql .= $this->getTableJoins();
        if($filter) {
            if(is_array($filter)) {
                //$table_columns = $this->getTableColumns($this->getTable());
                $implode = array();
                foreach($filter as $column => $value) {
                    //if(in_array($column,$table_columns)) {
                    $implode[] = "`$column`='$value'";
                    //}
                }
                if($implode)
                    $sql .= " WHERE " . implode(" AND ", $implode);
            } else {
                $sql .= " WHERE " . $filter;
            }

        }
        $query = $this->conn->query($sql);
        $total = $query->row['total'];

        $sql = "SELECT " . $this->defaultColumns();
        $sql .= ", (SELECT IFNULL(SUM(amount),0)";
        $sql .= " FROM `bank_letter_detail` bld";
        $sql .= " INNER JOIN `special_allowance_installments` sai ON sai.`special_allowance_installment_id` = bld.`source_table_id`";
        $sql .= " WHERE sai.special_allowance_id = sa.`special_allowance_id`";
        $sql .= " ) AS bl_amount";
        $sql .= " , (SELECT IFNULL(SUM(cheque_amount),0)";
        $sql .= " FROM `individual_cheque_detail` icd";
        $sql .= " INNER JOIN `special_allowance_installments` sai ON sai.`special_allowance_installment_id` = icd.`source_table_id`";
        $sql .= " WHERE sai.special_allowance_id = sa.`special_allowance_id`";
        $sql .= " ) AS ic_amount";
        $sql .= $this->getTableJoins();
        if($filter) {
            if(is_array($filter)) {
                //$table_columns = $this->getTableColumns($this->getTable());
                $implode = array();
                foreach($filter as $column => $value) {
                    //if(in_array($column,$table_columns)) {
                    $implode[] = "`$column`='$value'";
                    //}
                }
                if($implode)
                    $sql .= " WHERE " . implode(" AND ", $implode);
            } else {
                $sql .= " WHERE " . $filter;
            }

        }
        if (isset($criteria['orderby']) && $criteria['orderby']) {
            $sql .= $criteria['orderby'];
        } elseif (isset($criteria['order']) && $criteria['order']) {
            $sql .= " ORDER BY " . $criteria['order'];
            if(isset($criteria['sort']) && $criteria['sort']) {
                $sql .= " " . $criteria['sort'];
            } else {
                $sql .= " DESC";
            }
        }

        if (isset($criteria['start']) || isset($criteria['limit'])) {
            if ($criteria['start'] < 0) {
                $criteria['start'] = 0;
            }

            if ($criteria['limit'] < 1) {
                $criteria['limit'] = 20;
            }

            $sql .= " LIMIT " . (int) $criteria['start'] . "," . (int) $criteria['limit'];
        }

        //d($sql, true);
        $query = $this->conn->query($sql);
        $lists = $query->rows;

        return array('table_total' => $total, 'total' => $total, 'lists' => $lists);

    }

    public function getPaidAmount($special_allowance_id) {
        $sql  = " SELECT IFNULL(SUM(amount),0) as bl_amount";
        $sql .= " FROM `bank_letter_detail` bld";
        $sql .= " INNER JOIN `special_allowance_installments` sai ON sai.`special_allowance_installment_id` = bld.`source_table_id`";
        $sql .= " WHERE sai.special_allowance_id = '$special_allowance_id'";
        $query = $this->conn->query($sql);
        $bl_amount = $query->row['bl_amount'];

        $sql  = "SELECT IFNULL(SUM(cheque_amount),0) as ic_amount";
        $sql .= " FROM `individual_cheque_detail` icd";
        $sql .= " INNER JOIN `special_allowance_installments` sai ON sai.`special_allowance_installment_id` = icd.`source_table_id`";
        $sql .= " WHERE sai.special_allowance_id = '$special_allowance_id'";
        $query = $this->conn->query($sql);
        $ic_amount = $query->row['ic_amount'];

        return ($bl_amount+$ic_amount);
    }
    public function getMaxDocumentNo() {
        $sql = "SELECT MAX(document_no) as max_no FROM `".$this->getView()."`";
        $sql .= " WHERE `fiscal_year_id` = '".$this->session->data['fiscal_year_id']."'";
        //$sql .= " AND `company_id` = '".$this->session->data['company_id']."'";
        $query = $this->conn->query($sql);
        $record = $query->row;
        return ($record['max_no']?$record['max_no']+1:1);
    }

    public function getTotalAllowance($filter) {
        $sql = "SELECT SUM(`total_amount`) AS total_allowance";
        $sql .= " FROM `".$this->getView()."`";
        if($filter) {
            if(is_array($filter)) {
                $implode = array();
                foreach($filter as $column => $value) {
                    $implode[] = "`$column`='$value'";
                }
                if($implode)
                    $sql .= " WHERE " . implode(" AND ", $implode);
            } else {
                $sql .= " WHERE " . $filter;
            }
        }

        $query = $this->conn->query($sql);
        $row = $query->row;
        return is_null($row['total_allowance'])?0:$row['total_allowance'];
    }

    public function getEmployeeSpecialScholarshipAllowance($emp_id,$allowance_id)
    {
        $sql = "SELECT sac.special_allowance_category, sac.special_allowance_category_id, sac.special_allowance_type_id, es.scholarship_on, es.scholarship_value, es.relation FROM employee_scholarship es ";
        $sql .= " INNER JOIN special_allowance_category sac ";
        $sql .= " ON sac.special_allowance_category_id = es.scholarship_type_id ";
        $sql .= " WHERE sac.special_allowance_type_id = ".$allowance_id;
        $sql .= " AND es.employee_registration_id = '".$emp_id."' ";
        $query = $this->conn->query($sql);
        return $query->rows;
    }

    public function getEmployeeSpecialMedicalAllowance($emp_id,$allowance_id)
    {
        $sql = "SELECT sac.special_allowance_category, sac.special_allowance_category_id, sac.special_allowance_type_id, em.medical_on, em.medical_value, em.relation FROM employee_medical em ";
        $sql .= " INNER JOIN special_allowance_category sac ";
        $sql .= " ON sac.special_allowance_category_id = em.medical_type_id ";
        $sql .= " WHERE sac.special_allowance_type_id = ".$allowance_id;
        $sql .= " AND em.employee_registration_id = '".$emp_id."' ";
        $query = $this->conn->query($sql);
        return $query->rows;
    }

    public function getAllowanceCategoryScholarship($special_allowance_type_id,$employee_registration_id,$employee_family_id)
    {

        $sql = " SELECT sac.special_allowance_category, 
                sac.special_allowance_category_id, 
                sac.special_allowance_type_id, 
                es.scholarship_on, 
                es.scholarship_value, 
                es.relation,
                ef.`full_name` ";
        $sql .= " FROM employee_scholarship es ";
        $sql .= " INNER JOIN special_allowance_category sac ";
        $sql .= " ON sac.special_allowance_category_id = es.scholarship_type_id ";
        $sql .= " INNER JOIN employee_family AS ef ";
        $sql .= " ON ef.`relation` = es.`relation` ";
        $sql .= " WHERE sac.special_allowance_type_id IN (0,".$special_allowance_type_id.") ";
        $sql .= " AND es.employee_registration_id = '".$employee_registration_id."'";
        $sql .= " AND ef.`employee_family_id` = '".$employee_family_id."'";
        $query = $this->conn->query($sql);
        return $query->rows;
    }


    public function getAllowanceCategoryMedical($special_allowance_type_id,$employee_registration_id,$employee_family_id)
    {
        $sql = " SELECT sac.special_allowance_category, 
                        sac.special_allowance_category_id, 
                        sac.special_allowance_type_id, 
                        em.medical_on,
                        em.medical_value, 
                        em.relation,
                        ef.full_name ";
        $sql .= " FROM employee_medical em ";
        $sql .= " INNER JOIN special_allowance_category sac ";
        $sql .= " ON sac.special_allowance_category_id = em.medical_type_id ";
        $sql .= " INNER JOIN employee_family AS ef ";
        $sql .= " ON ef.`relation` = em.`relation` ";
        $sql .= " WHERE sac.special_allowance_type_id IN (0,".$special_allowance_type_id.") ";
        $sql .= " AND em.employee_registration_id = '".$employee_registration_id."'";
        $sql .= " AND ef.`employee_family_id` = '".$employee_family_id."'";
        $query = $this->conn->query($sql);
        return $query->rows;
    }

    public function getAllcategories($special_allowance_type_id)
    {
        $sql = " SELECT * FROM special_allowance_category ";
        $sql .= " WHERE special_allowance_type_id = ".$special_allowance_type_id;
        $query = $this->conn->query($sql);
        return $query->rows;

    }


    public function getEmployeeAllowancePolicy($allowance_type_id,$employee_registration_id,$employee_family_id)
    {

        $sql = " SELECT sac.special_allowance_category, 
                sac.special_allowance_category_id, 
                sac.special_allowance_type_id, 
                eap.allowance_on, 
                eap.allowance_value, 
                eap.relation,
                ef.full_name ";
        $sql .= " FROM employee_allowance_policy eap ";
        $sql .= " INNER JOIN special_allowance_category sac ";
        $sql .= " ON sac.special_allowance_category_id = eap.allowance_category_id ";
        $sql .= " INNER JOIN employee_family ef ";
        $sql .= " ON ef.relation = eap.relation ";
        $sql .= " WHERE sac.special_allowance_type_id IN (0,".$allowance_type_id.") ";
        $sql .= " AND eap.employee_registration_id = '".$employee_registration_id."'";
        $sql .= " AND ef.employee_family_id = '".$employee_family_id."'";
        // d($sql,true);
        $query = $this->conn->query($sql);
        return $query->rows;
    }


    public function getSpecialAllowanceInstallmentWise($filter)
    {
        $sql = " SELECT `sa`.`company_id`,
                        `sa`.`fiscal_year_id`,
                        `sa`.`special_allowance_id`,
                        `sa`.`document_identity`,
                        `sa`.`special_allowance_type_id`,
                        `sa`.`employee_registration_id`,
                        `sa`.`registration_code`,
                        `sa`.`is_taxable`,
                        `sa`.`total_amount`,
                        `sa`.`approved_status`,
                        `sa`.`approved_amount`,
                        `sai`.special_allowance_installment_id, 
                        `sai`.installment_amount, 
                        `er`.`employee_id`,
                        `er`.`employee_code`,
                        `er`.`department_id`,
                        `er`.`employee_name` ";
        $sql .= " FROM `special_allowance` `sa` ";
        $sql .= " LEFT JOIN `special_allowance_type` `sat` ";
        $sql .= " ON `sat`.`special_allowance_type_id` = `sa`.`special_allowance_type_id` ";
        $sql .= " LEFT JOIN `vw_employee_registration` `er` ";
        $sql .= " ON `er`.`employee_registration_id` = `sa`.`employee_registration_id` ";
        $sql .= " JOIN special_allowance_installments sai ";
        $sql .= " ON sai.special_allowance_id = sa.`special_allowance_id` ";
        $sql .= " WHERE sa.company_id = '".$this->session->data['company_id']."' ";
        $sql .= " AND sa.fiscal_year_id = '".$this->session->data['fiscal_year_id']."' ";
        $sql .= " AND sa.approved_status = 'Approved' ";
        $sql .= " AND sai.installment_date >= '".$filter['from_date']."'";
        $sql .= " AND sai.installment_date <= '".$filter['to_date']."'";
        //$sql .= " AND sa.is_post != 1 ";
        if($filter['department_id'])
        {
            $sql .= " AND er.department_id IN (".$filter['department_id'].") ";
        }
        if($filter['special_allowance_type_id'])
        {
            $sql .= " AND sa.special_allowance_type_id = '".$filter['special_allowance_type_id']."'";
        }
        $sql .= " ORDER BY `sa`.`document_identity` ";
        $query = $this->conn->query($sql);
        //d($query,true);
        return $query->rows;
    }

    public function getPaymentDetail($special_allowance_id) {
        $sql = "SELECT ic.`document_date`, ic.`document_identity`, ic.`document_title`";
        $sql .= " , icd.`cheque_date`, icd.`cheque_no`, icd.`cheque_amount` as amount";
        $sql .= " , CONCAT('payroll/individual_cheque/update&individual_cheque_id=',ic.individual_cheque_id) AS route";
        $sql .= " FROM `special_allowance_installments` sai";
        $sql .= " INNER JOIN `individual_cheque_detail` icd ON icd.`source_table_id` = sai.`special_allowance_installment_id`";
        $sql .= " INNER JOIN `individual_cheque` ic ON ic.`individual_cheque_id` = icd.`individual_cheque_id`";
        $sql .= " WHERE sai.`special_allowance_id` = '$special_allowance_id'";
        $sql .= " UNION";
        $sql .= " SELECT bl.`document_date`, bl.`document_identity`, bl.`document_title`";
        $sql .= " , bl.`cheque_date`, bl.`cheque_no`, bld.`amount`";
        $sql .= " , CONCAT('payroll/bank_letter/update&bank_letter_id=',bl.bank_letter_id) AS route";
        $sql .= " FROM `special_allowance_installments` sai";
        $sql .= " INNER JOIN `bank_letter_detail` bld ON bld.`source_table_id` = sai.`special_allowance_installment_id`";
        $sql .= " INNER JOIN `bank_letter` bl ON bl.`bank_letter_id` = bld.`bank_letter_id`";
        $sql .= " WHERE sai.`special_allowance_id` = '$special_allowance_id'";
        $query = $this->conn->query($sql);
        return $query->rows;
    }
}

?>