<?php

class ModelReportCertificateSerialNo extends HModel {
    protected $canAudit = false;
    protected function getTable() {
        return 'certificate_serial_no';
    }

    public function getNextNumber() {
        $parent_company_id = $this->session->data['parent_company_id'];
        $company_id = $this->session->data['company_id'];
        $fiscal_year_id = $this->session->data['fiscal_year_id'];

        $sql  = "SELECT MAX(`serial_no`) AS max_num";
        $sql .= " FROM `certificate_serial_no`";
        $sql .= " WHERE `fiscal_year_id` = '$fiscal_year_id'";
        if($parent_company_id != 0) {
            $sql .= " AND `parent_company_id` = '$parent_company_id'";
        } else {
            $sql .= " AND `company_id` = '$company_id'";
        }

        $query = $this->db->query($sql);
        $row = $query->row;
        $max_num = (is_null($row['max_num'])?1:($row['max_num']+1));
        return $max_num;
    }

    public function getCertificateEmployees($filter) {
        $company_id = $filter['company_id'];
        $employee_code = $filter['employee_code'];
        $registration_code = $filter['registration_code'];
        $department_id = $filter['department_id'];

        $sql = "SELECT DISTINCT e.`employee_id`".PHP_EOL;
        $sql .= " FROM `employee_registration` er".PHP_EOL;
        $sql .= " INNER JOIN `employee` e ON e.`employee_id` = er.`employee_id`".PHP_EOL;
        $sql .= " WHERE er.`company_id` = '$company_id'".PHP_EOL;
        if($employee_code) {
            $sql .= " AND e.`employee_code` = '$employee_code'".PHP_EOL;
        }
        if($registration_code) {
            $sql .= " AND er.`registration_code` = '$registration_code'".PHP_EOL;
        }
        if($department_id) {
            $sql .= " AND er.`department_id` IN ('".implode("','",$department_id)."')".PHP_EOL;
        }

        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getCertificate($filter) {
        $fiscal_year_id = $filter['fiscal_year_id'];
        $parent_company_id = $filter['parent_company_id'];
        $company_id = $filter['company_id'];
        $employees = $filter['employees'];

        $sql = "SELECT *";
        $sql .= ", (SELECT SUM(`allowance_amount`) FROM `payroll_allowance` pa INNER JOIN `payroll` p ON p.`payroll_id` = pa.`payroll_id` WHERE  p.`certificate_serial_id` = cs.`certificate_serial_no_id` AND pa.allowance_id = 14) AS medical_allowance";
        $sql .= " FROM `certificate_serial_no` cs";
        $sql .= " WHERE cs.fiscal_year_id = '$fiscal_year_id'";
        if($parent_company_id != 0) {
            $sql .= " AND cs.parent_company_id = '$parent_company_id'";
        } else {
            $sql .= " AND cs.company_id = '$company_id'";
        }
        $sql .= " AND cs.employee_id IN ('".implode("','", $employees)."')";
        $sql .= " ORDER BY serial_no";

        $query = $this->db->query($sql);
        return $query->rows;
    }

}
?>