<?php

class ModelReportStudentData extends HModel {

    protected function getTable() {
        return '_report_student_data';
    }

    public function getRecords($columns, $filter = array(), $show_empty='') {
        $start_date = $this->session->data['start_date'];
        $end_date = $this->session->data['end_date'];
        $age_at = $filter['age_at'];
        unset($filter['age_at']);
        $filter = implode(' AND ', $filter);
        $sort_order = array();
        $arrColumns = array();
        foreach($columns as $column) {
            $arrColumns[] = $column['column_name']." as '".$column['display_name']."'";
            if($column['display_name'] != 'Sr.') {
                $sort_order[] = $column['column_name'];
            }
        }

        $sql = "TRUNCATE TABLE `_report_student_data`".PHP_EOL;
        $this->db->query($sql);

        $sql = "INSERT INTO `_report_student_data`".PHP_EOL;
        $sql .= " SELECT st.mohallah_id, `mohallah_name`".PHP_EOL;
        $sql .= ", st.student_no, st.its_no, st.student_name".PHP_EOL;
        $sql .= ", IF(ISNULL(st.gender),'-Not Defined-',st.gender) AS gender".PHP_EOL;
        $sql .= ", st.dob, CAST(FORMAT(((TO_DAYS('".$age_at."') - TO_DAYS(`st`.`dob`)) / 365.25),2) AS DECIMAL(17,2)) AS `age`, ac.`age_limit_id` AS age_limit_id, ac.`title` AS age_group".PHP_EOL;
        $sql .= ", st.father_its_no, st.father_name, st.father_mobile_no, st.father_cnic, st.father_occupation_id, `father_occupation`".PHP_EOL;
        $sql .= ", st.mother_its_no, st.mother_name, st.mother_mobile_no, st.mother_occupation_id, `mother_occupation`".PHP_EOL;
        $sql .= ", st.sf_no, st.surname, st.residential_address, st.residential_phone_no, st.status".PHP_EOL;
        $sql .= ", `institute_category_id`, IF(ISNULL(`institute_category`),'-Not Defined-',`institute_category`) AS `institute_category`".PHP_EOL;
        $sql .= ", `school_id`, IF(ISNULL(`school_name`),'-Not Defined-',`school_name`) AS `school_name`".PHP_EOL;
        $sql .= ", `class_id`, IF(ISNULL(`class_name`),'-Not Defined-',`class_name`) AS `class_name`".PHP_EOL;
        $sql .= ", `section_id`, IF(ISNULL(`section_name`),'-Not Defined-',`section_name`) AS `section_name`".PHP_EOL;
        $sql .= ", st.madrassa_going, st.madrassa_id, IF(ISNULL(`madrassa_name`),'-Not Defined-',`madrassa_name`) AS `madrassa_name`".PHP_EOL;
        $sql .= ", CASE WHEN st.finance_support='Inactive' THEN 'Inactive' WHEN st.finance_support='Active' AND fa_date >= '".$start_date."' AND fa_date <= '".$end_date."' THEN 'NEW FA' ELSE 'OLD FA' END AS fa_status".PHP_EOL;
        $sql .= ", st.fa_date, st.monthly_income, st.earning_members, st.dependents, st.flat_area".PHP_EOL;
        $sql .= " FROM `vw_student` `st`".PHP_EOL;
//        $sql .= " LEFT JOIN `student_institute` `si` ON `si`.`student_id` = `st`.`student_id`".PHP_EOL;
//        $sql .= " LEFT JOIN `institute_category` `ic` ON `ic`.`institute_category_id` = `si`.`institute_category_id`".PHP_EOL;
//        $sql .= " LEFT JOIN `class` `c` ON `c`.`class_id` = `si`.`class_id`".PHP_EOL;
//        $sql .= " LEFT JOIN `school` `s` ON `s`.`school_id` = `si`.`school_id`".PHP_EOL;
//        $sql .= " LEFT JOIN `section` `sec` ON `sec`.`section_id` = `si`.`section_id`".PHP_EOL;
//        $sql .= " LEFT JOIN `mohallah` `moh` ON `moh`.`mohallah_id` = `st`.`mohallah_id`".PHP_EOL;
//        $sql .= " LEFT JOIN `occupation` `Focc` ON `Focc`.`occupation_id` = `st`.`father_occupation_id`".PHP_EOL;
//        $sql .= " LEFT JOIN `occupation` `Mocc` ON `Mocc`.`occupation_id` = `st`.`mother_occupation_id`".PHP_EOL;
//        $sql .= " LEFT JOIN `madrassa` `madrassa` ON `madrassa`.`madrassa_id` = `st`.`madrassa_id`".PHP_EOL;
//        $sql .= " LEFT JOIN mohallah_access ma ON ma.mohallah_id = st.mohallah_id".PHP_EOL;
        $sql .= " LEFT JOIN `age_limit` AS ac ON ac.`age_from` <= CAST(FORMAT(((TO_DAYS('".$age_at."') - TO_DAYS(`st`.`dob`)) / 365.25),2) AS DECIMAL(17,2)) AND ac.age_to >= CAST(FORMAT(((TO_DAYS('".$age_at."') - TO_DAYS(`st`.`dob`)) / 365.25),2) AS DECIMAL(17,2))".PHP_EOL;
        $sql .= " WHERE st.user_id = '".$this->session->data['user_id']."'".PHP_EOL;
        $sql .= " AND st.financial_year_id = '".$this->session->data['financial_year_id']."'".PHP_EOL;
        //d($sql, true);
        $this->db->query($sql);

        $sql = "SET @sr=0;".PHP_EOL;
        $this->db->query($sql);

        $sql = "SELECT DISTINCT " . implode(',',$arrColumns).PHP_EOL;
        $sql .= " FROM " .$this->getView($age_at). PHP_EOL;
        if($filter) {
            if(is_array($filter)) {
                //$table_columns = $this->getTableColumns($this->getTable());
                $implode = array();
                foreach($filter as $column => $value) {
                    //if(in_array($column,$table_columns)) {
                    $implode[] = "`$column`='$value'";
                    //}
                }
                if($implode)
                    $sql .= " WHERE " . implode(" AND ", $implode);
            } else {
                $sql .= " WHERE " . $filter;
            }
        }

        $sort_order = array_splice($sort_order, 0,3);
        if($sort_order) {
            $sql .= " ORDER BY " . implode(',',$sort_order);
        }
        //d($sql, true);
        $query = $this->db->query($sql);
        return $query->rows;
    }
}

?>