<?php

class ModelReportEOBI extends HModel {

    protected function getTable() {
        return 'payroll';
    }

    public function getReport($report_type, $where) {
        $sql = "SELECT er.`employee_registration_id`, er.`employee_code`, er.`registration_code`, er.`employee_name`, er.`dob`, er.`cnic_no`, er.`eobi_no`, er.`joining_date`, er.`leaving_date`, SUM(deduction_amount) AS eobi_deducted".PHP_EOL;
        $sql .= " FROM `vw_employee_registration` er ".PHP_EOL;
        $sql .= " INNER JOIN `payroll` p ON p.`company_id` = er.`company_id` AND p.`employee_registration_id` = er.`employee_registration_id`".PHP_EOL;
        $sql .= " LEFT JOIN `payroll_deduction` pd ON pd.`payroll_id` = p.`payroll_id` AND pd.`deduction_code` = 'EOBI'".PHP_EOL;
        $sql .= " WHERE $where".PHP_EOL;
        $sql .= " GROUP BY er.`employee_registration_id`".PHP_EOL;
        if($report_type=='deducted') {
            $sql .= " HAVING eobi_deducted > 0";
        } else {
            $sql .= " HAVING eobi_deducted = 0";
        }

        //d($sql, true);
        $query = $this->db->query($sql);
        //d(array($from_date, $to_date, $company_id, $sql, $query->rows), true);
        return $query->rows;
    }

    public function getActiveEmployee($where) {
        $sql = "SELECT er.`employee_registration_id`, er.`employee_code`, er.`registration_code`, er.`employee_name`, er.`dob`, er.`cnic_no`, er.`eobi_no`, er.`joining_date`, er.`leaving_date`, SUM(deduction_amount) AS eobi_deducted".PHP_EOL;
        $sql .= " FROM `vw_employee_registration` er ".PHP_EOL;
        $sql .= " INNER JOIN `payroll` p ON p.`company_id` = er.`company_id` AND p.`employee_registration_id` = er.`employee_registration_id`".PHP_EOL;
        $sql .= " LEFT JOIN `payroll_deduction` pd ON pd.`payroll_id` = p.`payroll_id` AND pd.`deduction_code` = 'EOBI'".PHP_EOL;
        $sql .= " WHERE $where".PHP_EOL;
        $sql .= " GROUP BY er.`employee_registration_id`".PHP_EOL;
        $sql .= " HAVING eobi_deducted > 0";

        //d($sql, true);
        $query = $this->db->query($sql);
        //d(array($from_date, $to_date, $company_id, $sql, $query->rows), true);
        return $query->rows;
    }

    public function getEOBIStatement($where) {
        $fiscal_year_id = $this->session->data['fiscal_year_id'];
        //$sql = "SELECT c.company_name, e.`eobi_no`, '' AS old_cnic_no, e.`cnic_no`, e.`full_name`, e.`gender`, e.`dob`, er.`joining_date`, er.`leaving_date`";
        $sql = "SELECT c.company_name, e.`eobi_no`, '' AS old_cnic_no, e.`cnic_no`, e.`full_name`, e.`gender`, e.`dob`, e.`eobi_date` as joining_date, IF(er.`status`='Active','',er.`leaving_date`) as leaving_date";
        $sql .= ", p.`document_date`, p.`document_title`, p.`department`, p.`designation`";
        $sql .= ", ROUND(365/12*COUNT(*)) AS no_of_days";
        $sql .= ", (SELECT a.gross_salary FROM `payroll` a INNER JOIN `payroll_deduction` ad ON ad.payroll_id=a.payroll_id WHERE a.employee_registration_id=p.`employee_registration_id` AND a.fiscal_year_id = '$fiscal_year_id' ORDER BY a.created_at DESC LIMIT 1) AS gross_salary";
        $sql .= ", SUM(IF(pd.deduction_amount=130,650,0)) AS employers_contribution, SUM(IF(pd.deduction_amount=130,130,0)) AS employee_contribution, SUM(IF(pd.deduction_amount=130,780,0)) AS total_contribution";
        $sql .= ", COUNT(*) AS total_eobi_salary";
        $sql .= " FROM `payroll` p";
        $sql .= " INNER JOIN `payroll_deduction` pd ON p.`payroll_id` = pd.`payroll_id` AND pd.`deduction_id`=8 AND pd.`deduction_amount`=130";
        $sql .= " INNER JOIN `company` c ON c.`company_id` = p.`company_id`";
        $sql .= " INNER JOIN `employee_registration` er ON er.`employee_registration_id` = p.`employee_registration_id`";
        $sql .= " INNER JOIN `employee` e ON e.`employee_id` = er.`employee_id`";
        $sql .= " WHERE ".$where;
        $sql .= " GROUP BY eobi_no, cnic_no, full_name";

        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getEOBINoSalary($company_id, $department_id, $from_date, $to_date) {
        //$sql = "SELECT e.`full_name`, e.`its_no`, e.`dob`, e.`gender`, e.`marital_status`, e.`mobile_no`, e.`phone_no`, e.`email`, e.cnic_no";
        $sql = "SELECT er.`employee_registration_id`, e.`employee_code`, er.`registration_code`, e.`full_name` as `employee_name`, e.`dob`, e.`cnic_no`, e.`eobi_no`, er.`joining_date`";
        $sql .= ", (SELECT COUNT(*)";
        $sql .= " FROM `payroll` p WHERE p.employee_registration_id = er.`employee_registration_id`";
        $sql .= " AND p.document_date >= '$from_date' AND p.document_date <='$to_date') AS total_payroll";
        $sql .= " FROM `employee_registration` er";
        $sql .= " INNER JOIN `employee` e ON e.`employee_id` = er.`employee_id`";
        $sql .= " WHERE er.company_id = $company_id AND er.`status` = 'Active'";
        $sql .= " HAVING total_payroll = 0";

        $query = $this->db->query($sql);
        return $query->rows;
    }

}

?>