<?php
class ModelReportIncomeTaxCertificate extends HModel {

    protected function getTable() {
        return 'payroll';
    }

    public function getEmployees($filter_type, $filter_value, $parent_company_id, $company_id) {
        $sql = "SELECT DISTINCT e.employee_id".PHP_EOL;
        $sql .= " FROM `payroll` p".PHP_EOL;
        $sql .= " INNER JOIN `company` c ON c.`company_id` = p.`company_id`".PHP_EOL;
        $sql .= " INNER JOIN `employee_registration` er ON er.`company_id` = p.`company_id` AND er.`employee_registration_id` = p.`employee_registration_id`".PHP_EOL;
        $sql .= " INNER JOIN `employee` e ON e.`employee_id` = er.`employee_id`".PHP_EOL;
        $sql .= " WHERE p.fiscal_year_id = '".$this->session->data['fiscal_year_id']."'".PHP_EOL;
        if($parent_company_id != 0) {
            $sql .= " AND c.`parent_company_id` = '".$parent_company_id."'".PHP_EOL;
        } else {
            $sql .= " AND c.`company_id` = '".$company_id."'".PHP_EOL;
        }
        if($filter_type=='employee_code' && $filter_value != '') {
            $sql .= " AND e.employee_code = '$filter_value'".PHP_EOL;
        } elseif ($filter_type=='registration_code' && $filter_value != '') {
            $sql .= " AND er.registration_code = '$filter_value'".PHP_EOL;
        } elseif ($filter_value !='') {
            $sql .= " AND er.department_id IN ('".implode("','", $filter_value)."')".PHP_EOL;
        }
        $sql .= "AND p.certificate_serial_id = ''".PHP_EOL;
//        $sql .= "AND e.employee_id NOT IN (".PHP_EOL;
//        $sql .= "SELECT DISTINCT employee_id FROM `certificate_serial_no`".PHP_EOL;
//        $sql .= " WHERE `fiscal_year_id` = '".$this->session->data['fiscal_year_id']."'".PHP_EOL;
//        if($parent_company_id != 0) {
//            $sql .= " AND `parent_company_id` = '".$parent_company_id."'".PHP_EOL;
//        } else {
//            $sql .= " AND `company_id` = '".$company_id."'".PHP_EOL;
//        }
//        $sql .= ")".PHP_EOL;
        //d($sql, true);
        $query = $this->db->query($sql);
        return $query->rows;

    }

//    public function getTaxEmployee($reportType, $parent_company_id, $company_id, $arrEmployees) {
//        $sql = "SELECT c.parent_company_id, c.company_id, e.employee_id, e.cnic_name, e.cnic_address, e.cnic_no, e.ntn_no";
//        $sql .= ", SUM(p.tax_deduction) AS tax_deduction";
//        $sql .= ", SUM(p.taxable_salary) AS taxable_salary";
//        $sql .= " FROM `payroll` p";
//        $sql .= " INNER JOIN `company` c ON c.`company_id` = p.`company_id`";
//        $sql .= " INNER JOIN `employee_registration` er ON er.`company_id` = p.`company_id` AND er.`employee_registration_id` = p.`employee_registration_id`";
//        $sql .= " INNER JOIN `employee` e ON e.`employee_id` = er.`employee_id`";
//        $sql .= " WHERE p.`fiscal_year_id` = '".$this->session->data['fiscal_year_id']."'";
//        $sql .= " WHERE e.`employee_id` IN (".implode("','", $arrEmployees).")";
//        if($parent_company_id != 0) {
//            $sql .= " AND `parent_company_id` = '".$parent_company_id."'";
//        } else {
//            $sql .= " AND `company_id` = '".$company_id."'";
//        }
//        $sql .= " GROUP BY e.employee_id";
//        if($reportType == 'with_tax') {
//            $sql .= "  having tax_deduction >  0 ";
//        } else {
//            $sql .= "  having tax_deduction =  0 ";
//        }
//        //$sql .= " GROUP BY cnic_name, cnic_address, cnic_no, ntn_no";
//        //d($sql, true);
//        $query = $this->db->query($sql);
//        return $query->rows;
//    }

    public function getTaxEmployee($parent_company_id, $company_id, $arrEmployees) {
        $sql = "SELECT c.parent_company_id, c.company_id, e.employee_id, e.cnic_name, e.cnic_address, e.cnic_no, e.ntn_no".PHP_EOL;
        $sql .= ", p.payroll_id".PHP_EOL;
        $sql .= ", p.tax_deduction".PHP_EOL;
        $sql .= ", p.taxable_salary".PHP_EOL;
        $sql .= ", p.certificate_serial_id".PHP_EOL;
        $sql .= " FROM `payroll` p".PHP_EOL;
        $sql .= " INNER JOIN `company` c ON c.`company_id` = p.`company_id`".PHP_EOL;
        $sql .= " INNER JOIN `employee_registration` er ON er.`company_id` = p.`company_id` AND er.`employee_registration_id` = p.`employee_registration_id`".PHP_EOL;
        $sql .= " INNER JOIN `employee` e ON e.`employee_id` = er.`employee_id`".PHP_EOL;
        $sql .= " WHERE p.`fiscal_year_id` = '".$this->session->data['fiscal_year_id']."'".PHP_EOL;
        $sql .= " AND e.`employee_id` IN ('".implode("','", $arrEmployees)."')".PHP_EOL;
        if($parent_company_id != 0) {
            $sql .= " AND c.`parent_company_id` = '".$parent_company_id."'".PHP_EOL;
        } else {
            $sql .= " AND c.`company_id` = '".$company_id."'".PHP_EOL;
        }
        $sql .= " ORDER BY e.`employee_id`";
        //d($sql, true);
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getTaxCertificate($department_id=array(), $registration_code='',$reportType='with_tax') {
        //$sql = "SELECT cs.serial_no, p.employee_registration_id, p.cnic_name, p.cnic_address, p.cnic_no, p.ntn_no, SUM(p.tax_deduction) as tax_deduction, SUM(p.taxable_salary) as taxable_salary";
        //$sql = "SELECT cs.serial_no, p.employee_registration_id, p.cnic_name, p.cnic_address, p.cnic_no, p.ntn_no, SUM(p.tax_deduction) as tax_deduction, SUM(((p.`gross_salary` + p.`house_rent_allowance`+p.`manual_addition`+p.`overtime`) - (p.`attendance_deduction`+p.`manual_deduction`))) as taxable_salary";
        $sql = "SELECT cs.serial_no, p.employee_registration_id, p.cnic_name, p.cnic_address, p.cnic_no, p.ntn_no, SUM(p.tax_deduction) as tax_deduction, SUM(((p.`gross_salary` + p.`house_rent_allowance`) - (p.`attendance_deduction`+p.`manual_deduction`))) as taxable_salary";
        $sql .= " , (SELECT SUM(`allowance_amount`) FROM `payroll_allowance` pa WHERE pa.allowance_id = 14 AND pa.`payroll_id`=p.`payroll_id`) AS medical_allowance ";
        $sql .= " FROM `vw_payroll` p ";
        $sql .= " INNER JOIN  `certificate_serial_no` cs ON cs.company_id=p.company_id AND cs.fiscal_year_id=p.fiscal_year_id AND cs.employee_registration_id=p.employee_registration_id";
        $sql .= " WHERE p.`company_id` = '".$this->session->data['company_id']."'";
        $sql .= " AND p.`fiscal_year_id` = '".$this->session->data['fiscal_year_id']."'";
        if($department_id) {
            $sql .= " AND p.`department_id` IN (".implode(',',$department_id).")";
        }
        if($registration_code) {
            $sql .= " AND p.`registration_code` = '".$registration_code."'";
        }

        //$sql .= " AND tax_challan_no != ''";
        $sql .= " GROUP BY p.employee_registration_id";
        if($reportType == 'with_tax')
        {
            $sql .= "  having SUM(p.tax_deduction) >  0 ";
        }else{
            $sql .= "  having SUM(p.tax_deduction) =  0 ";
        }

        //$sql .= " GROUP BY cnic_name, cnic_address, cnic_no, ntn_no";
        //d($sql, true);
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getTaxPayrolls($certificate_id) {
        $sql = "SELECT tax_challan_date, tax_challan_no, tax_challan_bank_id, tax_challan_branch, tax_deduction, b.bank_name";
        $sql .= " FROM `payroll` p";
        $sql .= " INNER JOIN `bank` b on b.bank_id = p.tax_challan_bank_id";
        $sql .= " WHERE `fiscal_year_id` = '".$this->session->data['fiscal_year_id']."'";
        $sql .= " AND `certificate_serial_id` = '$certificate_id'";
        $sql .= " AND `tax_deduction` >  0 ";

        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getCertificateReport($department_id) {
        $sql = "SELECT cs.*,er.`registration_code`,e.`employee_code`,e.`full_name`,d.`department_id`,d.`department_name`";
        $sql .= " FROM  certificate_serial_no cs";
        $sql .= " INNER JOIN `employee_registration` er ON er.`employee_registration_id` = cs.`employee_registration_id`";
        $sql .= " INNER JOIN `employee` e ON e.`employee_id` = er.`employee_id`";
        $sql .= " LEFT JOIN `department` d ON d.`department_id` = er.`department_id`";
        $sql .= " Where cs.`company_id` = '".$this->session->data['company_id']."'";
        $sql .= " AND cs.`fiscal_year_id` = '".$this->session->data['fiscal_year_id']."'";
        if($department_id != '')
        {
            $sql .= " AND d.`department_id` IN (".implode(',',$department_id).")";
        }
        $sql .= "Order By cs.serial_no";
        //d($sql, true);
        $query = $this->db->query($sql);
        return $query->rows;
    }
}

?>