<?php

class ModelReportSalaryComparison extends HModel {

    protected function getTable() {
        return 'payroll';
    }

    public function getRangeRecords($company_id, $from_date, $to_date, $department_id='') {
        $from_date = date('Y-m-01', strtotime($from_date));
        $begin = new DateTime($from_date);
        $end = new DateTime($to_date);

        $interval = DateInterval::createFromDateString('1 month');
        $period = new DatePeriod($begin, $interval, $end);

        $arrDates = [];
        foreach ($period as $dt) {
            $arrDates[] = [
                'value' => $dt->format("Y-m"),
                'display' => $dt->format("M Y"),
            ];
        }

        $sql = "SELECT d.department_name, er.`registration_code`, e.`full_name` AS employee_name".PHP_EOL;
        foreach($arrDates as $dt) {
            $sql .= " , SUM(IF(DATE_FORMAT(p.`document_date`,'%Y-%m')='".$dt['value']."',p.`gross_salary`,0)) AS '".$dt['display']."'".PHP_EOL;
        }
        $sql .= " FROM `payroll` p".PHP_EOL;
        $sql .= " INNER JOIN `employee_registration` er ON er.`employee_registration_id` = p.`employee_registration_id`".PHP_EOL;
        $sql .= " INNER JOIN `employee` e ON e.`employee_id` = er.`employee_id`".PHP_EOL;
        $sql .= " INNER JOIN `department` d ON d.department_id = er.`department_id`".PHP_EOL;
        $sql .= " WHERE p.company_id = '$company_id'".PHP_EOL;
        $sql .= " AND p.document_date >= '$from_date'".PHP_EOL;
        $sql .= " AND p.document_date <= '$to_date'".PHP_EOL;
        if($department_id) {
            $sql .= " AND er.department_id IN (".implode(",", $department_id).")".PHP_EOL;
        }
        $sql .= " GROUP BY d.department_name, er.`registration_code`, e.`full_name`";

        $query = $this->conn->query($sql);
        return $query->rows;
    }


    public function getDateRecords($company_id, $from_date, $to_date, $department_id='') {
        $sql = "SELECT d.department_name, er.`registration_code`, e.`full_name` AS employee_name".PHP_EOL;
        $sql .= " , SUM(IF(p.`document_date`='".$from_date."',p.`gross_salary`,0)) AS '".stdDate($from_date)."'".PHP_EOL;
        $sql .= " , SUM(IF(p.`document_date`='".$to_date."',p.`gross_salary`,0)) AS '".stdDate($to_date)."'".PHP_EOL;
        $sql .= " FROM `payroll` p".PHP_EOL;
        $sql .= " INNER JOIN `employee_registration` er ON er.`employee_registration_id` = p.`employee_registration_id`".PHP_EOL;
        $sql .= " INNER JOIN `employee` e ON e.`employee_id` = er.`employee_id`".PHP_EOL;
        $sql .= " INNER JOIN `department` d ON d.department_id = er.`department_id`".PHP_EOL;
        $sql .= " WHERE p.company_id = '$company_id'".PHP_EOL;
        $sql .= " AND (p.document_date = '$from_date' OR p.document_date = '$to_date')".PHP_EOL;
        if($department_id) {
            $sql .= " AND er.department_id IN (".implode(",", $department_id).")".PHP_EOL;
        }
        $sql .= " GROUP BY d.department_name, er.`registration_code`, e.`full_name`";

        //d([$company_id, $from_date, $to_date, $department_id, $sql], true);
        $query = $this->conn->query($sql);
        return $query->rows;
    }
}

?>