<?php

class ModelReportSecurityDeposit extends HModel {

    protected function getTable() {
        return 'payroll';
    }

    public function getReport($company_id, $from_document_date, $to_document_date, $deduction_id, $employee_status, $department_ids=null) {
        $begin = new DateTime( $from_document_date );
        $end = new DateTime( $to_document_date );
        $end = $end->modify( '+1 month' );
        $interval = DateInterval::createFromDateString('1 month');

        $period = new DatePeriod($begin, $interval, $end);
        $sql = "SELECT sh.shift_title as Shift, d.department_name as Department, e.full_name as Employee".PHP_EOL;
        $sql .= ", SUM(IF(p.`document_date`<'$to_document_date', pd.deduction_amount, 0)) AS 'Opening Balance'".PHP_EOL;
        foreach($period as $dt) {
            $start_date = $dt->format('Y-m-d');
            $end_date = $dt->format('Y-m-t');
            $display_month = $dt->format('M y');
            $sql .= ", SUM(IF(p.`document_date`>='$start_date' AND p.`document_date` <= '$end_date', pd.deduction_amount, 0)) AS '$display_month'".PHP_EOL;
        }
        $sql .= ", SUM(pd.deduction_amount) AS 'Total Balance'".PHP_EOL;
        $sql .= " FROM `payroll` p".PHP_EOL;
        $sql .= " LEFT JOIN `payroll_deduction` pd ON pd.payroll_id = p.`payroll_id` AND pd.deduction_id = $deduction_id".PHP_EOL;
        $sql .= " INNER JOIN `employee_registration` er ON er.employee_registration_id = p.`employee_registration_id`".PHP_EOL;
        $sql .= " INNER JOIN `department` d ON d.department_id = er.department_id".PHP_EOL;
        $sql .= " INNER JOIN `employee` e ON e.employee_id = er.employee_id".PHP_EOL;
        $sql .= " INNER JOIN `attendance_shift` sh ON sh.`attendance_shift_id` = er.`attendance_shift_id`".PHP_EOL;
        $sql .= " WHERE p.company_id=$company_id".PHP_EOL;
        $sql .= " AND p.document_date >= '$from_document_date' AND p.document_date <= '$to_document_date'".PHP_EOL;
        if($employee_status) {
            $sql .= " AND er.status='$employee_status'".PHP_EOL;
        }
        if($department_ids) {
            $sql .= " AND er.department_id IN ('".implode("','",$department_ids)."')".PHP_EOL;
        }
        $sql .= " GROUP BY p.`employee_registration_id`";
        $sql .= " ORDER BY department_name, full_name";

        $query = $this->db->query($sql);
        return $query->rows;
    }
}

?>