<?php

class ModelReportTaxDeduction extends HModel {

    protected function getTable() {
        return 'payroll';
    }

    public function getTaxDeduction($from_date, $to_date, $company_id=array()) {
        $sql =  " SELECT p.`company_id`,c.`company_name`,d.`department_name`, e.email ,e.`employee_code`,er.`registration_code`, '' AS 'Payment Section', CASE WHEN INSTR(e.ntn_no, '-')=8 THEN LEFT(e.ntn_no,INSTR(e.ntn_no, '-')-1) ELSE e.ntn_no END AS TaxPayer_NTN, e.`cnic_no` AS TaxPayer_CNIC, e.`cnic_name` AS TaxPayer_Name, e.`city` AS TaxPayer_City";
        $sql .= " , e.`cnic_address` AS TaxPayer_Address, '' AS TaxPayer_Status, e.`cnic_address` AS TaxPayer_Business_Name";
        //$sql .= " , SUM(p.`basic_salary`+p.`other_allowance`+p.`arrears`  + p.`house_rent_allowance`) AS Taxable_Amount";
        //$sql .= " , SUM((p.`basic_salary`+p.`arrears`+p.`taxable_allowance` + p.`house_rent_allowance`+p.`manual_addition`+p.`overtime`) - (p.`attendance_deduction`+p.`manual_deduction`)) AS Taxable_Amount";
        $sql .= " , SUM(p.gross_salary) AS Gross_Amount";
        $sql .= " , SUM(p.taxable_salary) AS Taxable_Amount";
        $sql .= " , SUM(p.`tax_deduction`) AS Tax_Amount";
        $sql .= " FROM `payroll` p";
        $sql .= " INNER JOIN `employee` e ON e.`employee_id` = p.`employee_id`";
        $sql .= " INNER JOIN `employee_registration` er ON e.`employee_id` = er.`employee_id` AND er.employee_registration_id = p.employee_registration_id";
        $sql .= " INNER JOIN company c ON c.`company_id` = p.`company_id`";
        $sql .= " LEFT JOIN  `department` d ON d.`department_id` = p.`department_id` AND d.`company_id` = p.`company_id` ";
        $sql .= " WHERE p.tax_deduction >= 0";
        //$sql .= " AND p.`company_id` = '".$this->session->data['company_id']."'";
        $sql .= " AND p.`document_date` >= '$from_date' AND p.`document_date` <= '$to_date'";
        if(!empty($company_id)) {
            $sql .= " AND p.`company_id` IN (".implode(',',$company_id).")";
        }
        $sql .= " GROUP BY p.`company_id`,p.`department_id`,e.`employee_code`";
        $sql .= " HAVING Tax_Amount > 0";
        $sql .= " Order BY c.company_name, d.department_name, e.`employee_code`,c.`company_name`,d.`department_name`";


        $query = $this->db->query($sql);
         // d($query,true);

        return $query->rows;
    }

        // commit by fahad //
//    public function getTaxDeduction($from_date, $to_date, $department_id=array()) {
//        $sql = "SELECT e.`employee_code`, '' AS 'Payment Section', e.`ntn_no` AS TaxPayer_NTN, e.`cnic_no` AS TaxPayer_CNIC, e.`cnic_name` AS TaxPayer_Name, e.`city` AS TaxPayer_City";
//        $sql .= " , e.`cnic_address` AS TaxPayer_Address, '' AS TaxPayer_Status, e.`cnic_address` AS TaxPayer_Business_Name";
//        $sql .= " , SUM(p.`basic_salary`+p.`arrears`+p.`other_allowance` + p.`house_rent_allowance`) AS Taxable_Amount, SUM(p.`tax_deduction`) AS Tax_Amount";
//        $sql .= " FROM `payroll` p";
//        $sql .= " INNER JOIN `employee` e ON e.`employee_id` = p.`employee_id`";
//        $sql .= " INNER JOIN `employee_registration` er ON e.`employee_id` = er.`employee_id` AND er.employee_registration_id = p.employee_registration_id";
//        $sql .= " WHERE p.tax_deduction > 0";
//        $sql .= " AND p.`company_id` = '".$this->session->data['company_id']."'";
//        $sql .= " AND p.`document_date` >= '$from_date' AND p.`document_date` <= '$to_date'";
//        if(!empty($department_id)) {
//            $sql .= " AND er.`department_id` IN (".implode(',',$department_id).")";
//        }
//        $sql .= " GROUP BY e.`employee_code`";
//
//        $query = $this->db->query($sql);
//        return $query->rows;
//    }

}

?>