<?php

class ModelReportWithholdingStatement extends HModel {

    protected function getTable() {
        return 'payroll';
    }

    public function getReport($from_date, $to_date, $company_id=array()) {
        $sql ="SELECT ntn_no AS registration_no, cnic_no AS identification_no, cnic_name AS `name`, document_date AS `transaction_date`, '64020004' AS `code`";
        $sql .= ", (p.`gross_salary` + p.`house_rent_allowance` - (p.`net_salary`-p.`payable_salary`)) AS `amount`, '' AS `exemption_code`, `tax_deduction` AS `tax_amount`";
        $sql .= " FROM `vw_payroll` p";
        $sql .= " WHERE 1=1";
        //$sql .= " AND pd.deduction_amount != 0";
        $sql .= " AND p.`document_date` >= '$from_date' AND p.`document_date` <= '$to_date'";
        $sql .= " AND p.`company_id` IN (".implode(',',$company_id).")";
        $sql .= " ORDER BY tax_deduction desc";

        $query = $this->db->query($sql);
        //d(array($from_date, $to_date, $company_id, $sql, $query->rows), true);
        return $query->rows;
    }

    public function getRecords($filter=NULL, $sort_order=NULL, $limit = '') {
        $sql  = "SELECT p.*".PHP_EOL;
        $sql .= ", `p`.`department` AS `department_name`".PHP_EOL;
        $sql .= ", `p`.`designation` AS `designation_name`".PHP_EOL;
        $sql .= ", `c`.`parent_company_id` AS `parent_company_id`".PHP_EOL;
        $sql .= ", `e`.`employee_code` AS `employee_code`".PHP_EOL;
        $sql .= ", `er`.`registration_code` AS `registration_code`".PHP_EOL;
        $sql .= ", `e`.`full_name` AS `employee_name`".PHP_EOL;
        $sql .= ", `e`.`dob` AS `dob`".PHP_EOL;
        $sql .= ", `er`.`joining_date` AS `joining_date`".PHP_EOL;
        $sql .= ", `e`.`mobile_no` AS `mobile_no`".PHP_EOL;
        $sql .= ", `e`.`phone_no` AS `phone_no`".PHP_EOL;
        $sql .= ", `e`.`email` AS `email`, `e`.`cnic_no` AS `cnic_no`, `e`.`cnic_name` AS `cnic_name`, `e`.`cnic_address` AS `cnic_address`".PHP_EOL;
        $sql .= ", `e`.`eobi_date` AS `eobi_date`, `e`.`ntn_no` AS `ntn_no`".PHP_EOL;
        $sql .= ", `d`.`party_id` AS `dept_party_id`, `d`.`ah_key` AS `dept_ah_key`, `d`.`budget_key` AS `dept_budget_key`".PHP_EOL;
        $sql .= ", `c`.`eobi_party_id` AS `eobi_party_id`, `c`.`eobi_ah_key` AS `eobi_ah_key`, `c`.`tax_party_id` AS `tax_party_id`, `c`.`tax_ah_key` AS `tax_ah_key`".PHP_EOL;
        $sql .= " FROM `payroll` p".PHP_EOL;
        $sql .= " LEFT JOIN `employee_registration` er ON er.`employee_registration_id` = p.`employee_registration_id`".PHP_EOL;
        $sql .= " LEFT JOIN `employee` e ON e.`employee_id` = er.`employee_id`".PHP_EOL;
        $sql .= " LEFT JOIN `company` c ON c.`company_id` = er.`company_id`".PHP_EOL;
        $sql .= " LEFT JOIN `department` d ON d.`department_id` = er.`department_id`".PHP_EOL;
        $sql .= " LEFT JOIN `designation` ds ON ds.`designation_id` = er.`designation_id`".PHP_EOL;
        $sql .= " LEFT JOIN `attendance_shift` s ON s.attendance_shift_id = er.`attendance_shift_id`".PHP_EOL;
        $sql .= " LEFT JOIN `bank` b ON b.`bank_id` = er.`bank_id`".PHP_EOL;
        if($filter) {
            if(is_array($filter)) {
                //$table_columns = $this->getTableColumns($this->getTable());
                $implode = array();
                foreach($filter as $column => $value) {
                    //if(in_array($column,$table_columns)) {
                    $implode[] = "`$column`='$value'";
                    //}
                }
                if($implode)
                    $sql .= " WHERE " . implode(" AND ", $implode);
            } else {
                $sql .= " WHERE " . $filter;
            }
        }

        if($sort_order) {
            $sql .= " ORDER BY " . implode(',',$sort_order);
        }

        if($limit) {
            $sql .= " LIMIT ".$limit;
        }
        //d($sql);
        $query = $this->conn->query($sql);
        return $query->rows;
    }
}

?>