<?php

class ModelSetupDepartment extends HModel {
    protected $isAdmin = true;

    protected function getTable() {
        return 'department';
    }

    protected function getView() {
        return 'vw_department';
    }

    protected function defaultColumns() {
        $sql = "d.*, c.company_name";
        $sql .= ", (SELECT COUNT(0) FROM `employee_registration` `er` WHERE `er`.`company_id` = `d`.`company_id` AND `er`.`department_id` = `d`.`department_id`) AS `total_registration`";

        return $sql;
    }

    protected function getTableJoins() {
        $sql  = " FROM `department` d";
        $sql .= " INNER JOIN `company` c ON c.`company_id` = d.`company_id`";

        return $sql;
    }
}

?>