<?php

class ModelSetupDepartmentAllowancePolicy extends HModel {
    protected function getTable() {
        return 'department_allowance_policy';
    }

    public function getRecords($filter=NULL, $sort_order=NULL, $limit=NULL) {
        $sql = "SELECT d.*, t.`special_allowance_type` AS allowance_type, IF(d.`allowance_category_id`=0,'ALL',c.`special_allowance_category`) AS allowance_category";
        $sql .= " FROM `department_allowance_policy` d";
        $sql .= " INNER JOIN `special_allowance_type` t ON t.`special_allowance_type_id`=d.`allowance_type_id`";
        $sql .= " LEFT JOIN `special_allowance_category` c ON c.`special_allowance_category_id` = d.`allowance_category_id`";

        if($filter) {
            if(is_array($filter)) {
                //$table_columns = $this->getTableColumns($this->getTable());
                $implode = array();
                foreach($filter as $column => $value) {
                    //if(in_array($column,$table_columns)) {
                    $implode[] = "$column='$value'";
                    //}
                }
                if($implode)
                    $sql .= " WHERE " . implode(" AND ", $implode);
            } else {
                $sql .= " WHERE " . $filter;
            }
        }

        if($sort_order) {
            $sql .= " ORDER BY " . implode(',',$sort_order);
        }

        if($limit) {
            $sql .= " LIMIT ".$limit;
        }

        $query = $this->conn->query($sql);
        return $query->rows;
    }


    public function getRecord($filter=NULL, $sort_order=NULL) {
        $sql = "SELECT d.*, t.`special_allowance_type` AS allowance_type, IF(d.`allowance_category_id`=0,'ALL',c.`special_allowance_category`) AS allowance_category";
        $sql .= " FROM `department_allowance_policy` d";
        $sql .= " INNER JOIN `special_allowance_type` t ON t.`special_allowance_type_id`=d.`allowance_type_id`";
        $sql .= " LEFT JOIN `special_allowance_category` c ON c.`special_allowance_category_id` = d.`allowance_category_id`";

        if($filter) {
            if(is_array($filter)) {
                //$table_columns = $this->getTableColumns($this->getTable());
                $implode = array();
                foreach($filter as $column => $value) {
                    //if(in_array($column,$table_columns)) {
                    $implode[] = "$column='$value'";
                    //}
                }
                if($implode)
                    $sql .= " WHERE " . implode(" AND ", $implode);
            } else {
                $sql .= " WHERE " . $filter;
            }
        }

        if($sort_order) {
            $sql .= " ORDER BY " . implode(',',$sort_order);
        }

        $query = $this->conn->query($sql);
        return $query->row;
    }
}

?>