/**
 * Created by Huzaifa on 9/18/15.
 */

$(document).on('ready', function() {
    $('#form').valid();
});

$(document).on('change', '#attendance_date', function() {
    $('#department_id').val('').trigger('change');
});

$(document).on('change', '#department_id', function() {
    var $department_id = $(this).val();
    var $attendance_date = $('#attendance_date').val();
    if($department_id=='' || $attendance_date=='') {
        $('#tblEmployee tbody').html('');
    } else {
        $.ajax({
            url: $URLGetEmployee,
            dataType: 'json',
            type: 'post',
            data: 'attendance_date='+$attendance_date+'&department_id='+$department_id,
            mimeType:"multipart/form-data",
            beforeSend: function() {

            },
            complete: function() {
                $('#loader').remove();
            },
            success: function(json) {
                if(json.success)
                {
                    $('#tblEmployee tbody').html(json.html);
                    $('#employee_count').val(json.employee_count)
                } else {
                    alert(json.error);
                }
            },
            error: function(xhr, ajaxOptions, thrownError) {
                console.log(xhr.responseText);
            }
        })
    }
});

function updateAttendanceType($row_no) {
    $('#employee_'+$row_no+'_attendance_type').val('Manual');
}

$(document).on('click','#btnDelete',function() {
    var $from_date = $('#adj_from_date').val();
    var $to_date = $('#adj_to_date').val();
    var $department_id = $('#adj_department_id').val();
    var $registration_code = $('#adj_registration_code').val();

    if($from_date=='') {
        alert('From Date is required');
        return;
    } else {
        var $fdate = moment($from_date,"DD-MM-YYYY");
        if($fdate.format("DD-MM-YYYY")!=$from_date) {
            alert("Invalid From Date");
            return;
        }
    }

    if($to_date=='') {
        alert('To Date is required');
        return;
    } else {
        var $tdate = moment($to_date,"DD-MM-YYYY");
        if($tdate.format("DD-MM-YYYY")!=$to_date) {
            alert("Invalid To Date");
            return;
        }
    }

    if($tdate < $fdate) {
        alert("From Date must be greater than To Date");
        return;
    }

    if($department_id=="" && $registration_code=="") {
        alert("Select Department or Registration Code");
        return;

    }

    var $data = {
        'from_date': $fdate.format("YYYY-MM-DD"),
        'to_date': $tdate.format("YYYY-MM-DD"),
        'department_id': $department_id,
        'registration_code': $registration_code
    };

    bootbox.confirm({
        title: "Sure to Delete?",
        message: "Attendance once deleted, cannot be undone.",
        buttons: {
            cancel: {
                label: '<i class="fa fa-times"></i> Cancel',
                className: 'btn-danger'
            },
            confirm: {
                label: '<i class="fa fa-check"></i> Confirm',
                className: 'btn-success'
            }
        },
        callback: function (result) {
            if(result) {
                $.ajax({
                    url: $URLDeleteAttendance,
                    dataType: 'json',
                    type: 'post',
                    data: $data,
                    mimeType:"multipart/form-data",
                    beforeSend: function() {},
                    complete: function() {},
                    success: function(json) {
                        if(json.success)
                        {
                            location.reload();
                        } else {
                            alert(json.error);
                        }
                    },
                    error: function(xhr, ajaxOptions, thrownError) {
                        console.log(xhr.responseText);
                    }
                });

                return false;
            }
        }
    });
});

$(document).on('click','#btnRecalculate',function() {
    var $from_date = $('#adj_from_date').val();
    var $to_date = $('#adj_to_date').val();
    var $department_id = $('#adj_department_id').val();
    var $registration_code = $('#adj_registration_code').val();

    if($from_date=='') {
        alert('From Date is required');
        return;
    } else {
        var $fdate = moment($from_date,"DD-MM-YYYY");
        if($fdate.format("DD-MM-YYYY")!=$from_date) {
            alert("Invalid From Date");
            return;
        }
    }

    if($to_date=='') {
        alert('To Date is required');
        return;
    } else {
        var $tdate = moment($to_date,"DD-MM-YYYY");
        if($tdate.format("DD-MM-YYYY")!=$to_date) {
            alert("Invalid To Date");
            return;
        }
    }

    if($tdate < $fdate) {
        alert("From Date must be greater than To Date");
        return;
    }

    if($department_id=="" && $registration_code=="") {
        alert("Select Department or Registration Code");
        return;

    }

    var $data = {
        'from_date': $fdate.format("YYYY-MM-DD"),
        'to_date': $tdate.format("YYYY-MM-DD"),
        'department_id': $department_id,
        'registration_code': $registration_code
    };

    $.ajax({
        url: $URLCalculateAttendance,
        dataType: 'json',
        type: 'post',
        data: $data,
        mimeType:"multipart/form-data",
        beforeSend: function() {
            bootbox.dialog({
                message: '<div class="text-center"><i class="fa fa-spin fa-spinner"></i> Updating ...</div>',
                closeButton: false,
                backdrop: true,
            })
        },
        complete: function() {},
        success: function(json) {
            if(json.success)
            {
                location.reload();
            } else {
                alert(json.error);
            }
        },
        error: function(xhr, ajaxOptions, thrownError) {
            console.log(xhr.responseText);
        }
    });
});