/**
 * Created by Huzaifa on 9/18/15.
 */

$(document).on('ready', function() {
    $('#form').valid();
})

function submitDocument() {
    $('button.btnSave').attr('disabled','disabled');
    if($('#form').valid()) {
        var $data = $('#form').serialize();

        $.ajax({
            url: $URLSaveAjax,
            dataType: 'json',
            type: 'post',
            data: $data,
            mimeType:"multipart/form-data",
            beforeSend: function() {

            },
            complete: function() {
                $('.btnSave').removeAttr('disabled');
                $('#loader').remove();
            },
            success: function(json) {
                if(json.success)
                {
                    $('#primary_key').val(json.primary_key);
                    if(json.redirect) {
                        window.location = json.redirect;
                    }
                } else {
                    alert(json.error);
                }
            },
            error: function(xhr, ajaxOptions, thrownError) {
                console.log(xhr.responseText);
            }
        })
    } else {
        $('.btnSave').removeAttr('disabled');
    }
}

$(document).on('change','#status', function() {
    var $value = $(this).val();
    if($value=='Approved') {
        $('#divRemarks').hide('slow');
        $('#divApproved').show('slow');
        setFieldFormat();
        var $leave_from = $('#leave_from').val();
        var $leave_to = $('#leave_to').val();
        $('#approved_from').val($leave_from).trigger('change');
        $('#approved_to').val($leave_to).trigger('change');
    } else if($value=='Rejected') {
        $('#divApproved').hide('slow');
        $('#divRemarks').show('slow');
        $('#approved_from').val('');
        $('#approved_to').val('');
    } else {
        $('#divRemarks').hide('slow');
        $('#divApproved').hide('slow');
        $('#approved_from').val('');
        $('#approved_to').val('');
    }
});