/**
 * Created by Huzaifa on 9/18/15.
 */

var $emp_allowance = {};

$(document).on('change','#employee_registration_id',function() {
    var $code = $('#employee_registration_id option:selected').data('registration_code');
    $('#tblSpecialAllowance').find('tbody').html('');
    if($employees[$code]) {
        var $data = $employees[$code];
        $('#registration_code').val($code);
        $('#employee_code').val($data['employee_code']);
        $('#employee_id').val($data['employee_id']);
    } else {
        $('#employee_code').val('');
        $('#employee_id').val('');
        $('#employee_registration_id').val('').trigger('change');
        alert("Invalid Employee Code");
    }
});

$(document).on('change','#registration_code',function() {
    var $code = $(this).val();
    // console.log($code);
    if($employees[$code]) {
        var $data = $employees[$code];
        $('#employee_code').val($data['employee_code']);
        $('#employee_id').val($data['employee_id']);
        $('#employee_registration_id').val($data['employee_registration_id']).trigger('change');
    } else {
        $families = {};
        $('#employee_code').val('');
        $('#employee_id').val('');
        $('#employee_registration_id').val('').trigger('change');
        alert("Invalid Employee Code");
    }
});

$(document).on('change','#special_allowance_type_id', function() {
    var $special_allowance_type_id = $(this).val();
    var $employee_registration_id = $('#employee_registration_id').val();
    $('#tblSpecialAllowance tbody').html('');
    if($special_allowance_type_id==2) {
        $('#divPeriod').show('slow');
    } else {
        $('#medical_from').val('');
        $('#medical_to').val('');
        $('#divPeriod').hide('slow');
    }

    var $data = {
        'special_allowance_type_id': $special_allowance_type_id,
        'employee_registration_id': $employee_registration_id
    };

     $.ajax({
        url: $URLGetAllowanceCategory,
        dataType: 'json',
        type: 'post',
        data: $data,
        mimeType:"multipart/form-data",
        beforeSend: function() {
            $('#tblPolicy').before('<span id="loader" class="pull-right"><i class="fa fa-spin fa-refresh"></i></span>')
        },
        complete: function() {
            $('#loader').remove();
        },
        success: function(json) {
            if(json.success)
            {
                $categories = json.categories;
                $('#tblPolicyScholarship tbody').html(json.html_policy);
                $policies = json.policies;
                $families = json.families;
            } else {
                alert(json.error);
            }
        },
        error: function(xhr, ajaxOptions, thrownError) {
            console.log(xhr.responseText);
        }
    });

});

$(document).on('click', '.btnAddAllowance', function() {
    console.log($families);
    console.log($categories);
    var $allowance_type_id = $('#special_allowance_type_id option:selected').val();
    if($allowance_type_id !=='') {
        if (Object.keys($families).length > 0) {
            $html = '<tr id="grid_row_id_'+$grid_row_allowance+'" data-row_id="'+$grid_row_allowance+'">';
            $html += '<td style="width: 15px;"><a class="btnRemoveAllowance btn btn-xs btn-danger" title="Remove" href="javascript:void(0);"><i class="fa fa-minus"></i></a></td>';
            $html += '<td>';
            $html += '<input type="hidden" class="form-control " id="detail_'+$grid_row_allowance+'_allowance_for" name="details['+$grid_row_allowance+'][allowance_for]" value="" />';
            $html += '<input type="hidden" class="form-control " id="detail_'+$grid_row_allowance+'_school_id" name="details['+$grid_row_allowance+'][school_id]" value="" />';
            $html += '<input type="hidden" class="form-control " id="detail_'+$grid_row_allowance+'_class_id" name="details['+$grid_row_allowance+'][class_id]" value="" />';
            $html += '<input type="hidden" class="form-control " id="detail_'+$grid_row_allowance+'_period_start_date" name="details['+$grid_row_allowance+'][period_end_date]" value="" />';
            $html += '<input type="hidden" class="form-control " id="detail_'+$grid_row_allowance+'_period_end_date" name="details['+$grid_row_allowance+'][period_end_date]" value="" />';
            $html += '<select onchange="updateRelation('+$grid_row_allowance+')" class="form-control" id="detail_'+$grid_row_allowance+'_employee_family_id" name="details['+$grid_row_allowance+'][employee_family_id]" >';
            $html += '<option>&nbsp;</option>';
            $.each($families,function($i,$family) {
                $html += '<option data-relation="'+$family['relation']+'" data-school_id="'+$family['school_id']+'" data-class_id="'+$family['class_id']+'" data-period_start_date="'+$family['period_start_date']+'" data-period_end_date="'+$family['period_end_date']+'" data-school="'+$family['school_name']+' - '+$family['class_name']+'" value="'+$family['employee_family_id']+'">'+$family['full_name']+'</option>';
            });
            $html += '</select>';
            $html += '</td>';
            $html += '<td>';
            $html += '<select class="form-control" id="detail_'+$grid_row_allowance+'_special_allowance_category_id" name="details['+$grid_row_allowance+'][special_allowance_category_id]" >';
            $.each($categories,function($i,$category) {
                $html += '<option value="'+$category['special_allowance_category_id']+'">'+$category['special_allowance_category']+'</option>';
            });
            $html += '</select>';
            $html += '</td>';
            $html += '<td><input onchange="calculateTotal();" type="text" class="form-control fPDecimal" id="detail_'+$grid_row_allowance+'_amount" name="details['+$grid_row_allowance+'][amount]" value="" /></td>';
            $html += '<td><input type="text" class="form-control" maxlength="60" id="detail_'+$grid_row_allowance+'_remarks" name="details['+$grid_row_allowance+'][remarks]" value="" /></td>';
            $html += '<td><input type="text" class="form-control dtpDate" id="detail_'+$grid_row_allowance+'_receipt_date" name="details['+$grid_row_allowance+'][receipt_date]" value="" /></td>';
            $html += '<td><input type="text" class="form-control" maxlength="21" id="detail_'+$grid_row_allowance+'_receipt_no" name="details['+$grid_row_allowance+'][receipt_no]" value="" /></td>';
            $html += '<td>';
            $html += '<input type="text" class="form-control" maxlength="21" id="detail_'+$grid_row_allowance+'_policy_amount" name="details['+$grid_row_allowance+'][policy_amount]" value="" readonly />';
            $html += '<input type="hidden" id="detail_'+$grid_row_allowance+'_policy_on" name="details['+$grid_row_allowance+'][policy_on]" value="" />';
            $html += '<input type="hidden" id="detail_'+$grid_row_allowance+'_policy_value" name="details['+$grid_row_allowance+'][policy_value]" value="" />';
            $html += '</td>';
            $html += '</tr>';

            $('#tblSpecialAllowance tbody').append($html);
            $('#detail_'+$grid_row_allowance+'_employee_family_id').trigger('change');

            $grid_row_allowance++;
            setFieldFormat();
        } else {
            alert('Family Member not defined.');
        }
    }

});


function updateRelation($allowance_id) {
    var $data = $('#detail_'+$allowance_id+'_employee_family_id option:selected').data();
    // console.log($data);
    $('#detail_'+$allowance_id+'_allowance_for').val($data['relation']);
    $('#detail_'+$allowance_id+'_school_id').val($data['school_id']);
    $('#detail_'+$allowance_id+'_class_id').val($data['class_id']);
    $('#detail_'+$allowance_id+'_period_start_date').val($data['period_start_date']);
    $('#detail_'+$allowance_id+'_period_end_date').val($data['period_end_date']);

    calculateTotal();
}

$(document).on('click','.btnRemoveAllowance',function() {
    var $row_id = $(this).parent().parent().data('grid_row_allowance');
    console.log($row_id);
    $('#grid_row_allowance_'+$row_id).remove();
});

function submitDocument() {
    $('button.btnSave').attr('disabled','disabled');
    if($('#form').valid()) {
        var $data = $('#form').serialize();

        $.ajax({
            url: $URLSaveAjax,
            dataType: 'json',
            type: 'post',
            data: $data,
            mimeType:"multipart/form-data",
            beforeSend: function() {

            },
            complete: function() {
                $('.btnSave').removeAttr('disabled');
                $('#loader').remove();
            },
            success: function(json) {
                if(json.success)
                {
                    $('#primary_key').val(json.primary_key);
                    if(json.redirect) {
                        //window.location = json.redirect;
                    }
                } else {
                    alert(json.error);
                }
            },
            error: function(xhr, ajaxOptions, thrownError) {
                console.log(xhr.responseText);
            }
        })
    } else {
        $('.btnSave').removeAttr('disabled');
    }
}

function calculateTotal() {
    // alert('hello');
    var $total_amount = 0;
    var $total_policy_amount = 0;
    $('#tblSpecialAllowance tbody tr').each(function(){
        var $row_id = $(this).data('row_id');
        var $relation = $('#detail_'+$row_id+'_allowance_for').val();
        var $category_id = $('#detail_'+$row_id+'_special_allowance_category_id option:selected').val();
        var $amount = $('#detail_'+$row_id+'_amount').val() | 0;

        if(typeof $policies[$relation] !== 'undefined') {
            if (typeof $policies[$relation][$category_id] !== 'undefined') {
                var $policy_on = $policies[$relation][$category_id]['allowance_on'];
                var $policy_value = $policies[$relation][$category_id]['allowance_value'];
            } else if (typeof $policies[$relation][0] !== 'undefined') {
                var $policy_on = $policies[$relation][0]['allowance_on'];
                var $policy_value = $policies[$relation][0]['allowance_value'];
            } else {
                var $policy_on = '';
                var $policy_value = 0;
            }
        } else {
            var $policy_on = '';
            var $policy_value = 0;
        }

        if($policy_on=='Fixed') {
            var $policy_amount = $amount;
        } else {
            var $policy_amount = (parseFloat($amount) * parseFloat($policy_value) / 100).toFixed(2);
        }
        $total_amount += parseFloat($amount);
        $total_policy_amount += parseFloat($policy_amount);

        $('#detail_'+$row_id+'_policy_amount').val($policy_amount);
        $('#detail_'+$row_id+'_policy_on').val($policy_on);
        $('#detail_'+$row_id+'_policy_value').val($policy_value);
    });

    $('#total_amount').val($total_amount);
}

function calculateTotalApprovedAmount() {
    // alert('changed');
    var $total_amount = 0;
    $('#tblSpecialAllowance tbody tr').each(function(){
        var $row_id = $(this).data('row_id');
        var $amount = $('#detail_'+$row_id+'_approved_amount').val() | 0;

        $total_amount += parseFloat($amount);
    });
    /*console.log($total_amount);*/

    $('#approved_amount').val($total_amount);
    validate_total_amount();
};

$(document).on('ready', function() {
    $('#form').valid();
    // $('#approved_status').trigger('change');
    //var $code = $('#registration_code').val();
    //$families = $employees[$code]['families'];
    var $special_allowance_type_id = $('#special_allowance_type_id').val();
    if($special_allowance_type_id!=2) {
        $('#divPeriod').hide();
    }
});
