/**
 * Created by Huzaifa on 9/18/15.
 */

$(document).on('ready', function() {
    $('#form').valid();
})

function submitDocument() {
    $('button.btnSave').attr('disabled','disabled');
    if($('#form').valid()) {
        var $data = $('#form').serialize();

        $.ajax({
            url: $URLSaveAjax,
            dataType: 'json',
            type: 'post',
            data: $data,
            mimeType:"multipart/form-data",
            beforeSend: function() {

            },
            complete: function() {
                $('.btnSave').removeAttr('disabled');
                $('#loader').remove();
            },
            success: function(json) {
                if(json.success)
                {
                    $('#primary_key').val(json.primary_key);
                    if(json.redirect) {
                        window.location = json.redirect;
                    }
                } else {
                    alert(json.error);
                }
            },
            error: function(xhr, ajaxOptions, thrownError) {
                console.log(xhr.responseText);
            }
        })
    } else {
        $('.btnSave').removeAttr('disabled');
    }
}

$(document).on('click','#btnSearch', function() {
    var $from_payroll_date = $('#from_payroll_date').val();
    var $to_payroll_date = $('#to_payroll_date').val();

    if($from_payroll_date != '' && $to_payroll_date !='') {
        var $data = $('#form').serialize();
        $.ajax({
            url: $URLGetAllowances,
            dataType: 'json',
            type: 'post',
            data: $data,
            mimeType:"multipart/form-data",
            beforeSend: function() {
                $('#btnSearch').html('<i class="fa fa-refresh fa-spin"></i>&nbsp;Search');
                $('#tblAllowances tbody').html('');
                $('#cheque_amount').val('');
            },
            complete: function() {
                $('#btnSearch').html('Search');
                $('#loader').remove();
            },
            success: function(json) {
                if(json.success)
                {
                    $('#tblAllowances tbody').html(json.html);
                    $('#total_amount').val(json.total_amount);

                    setFieldFormat();
                } else {
                    alert(json.error);
                }
            },
            error: function(xhr, ajaxOptions, thrownError) {
                console.log(xhr.responseText);
            }
        });
    } else {
        $('#tblAllowances tbody').html('');
    }
})

$(document).on('change','#pay_from_company_id', function() {
    var $ref_id = $('#pay_from_company_id option:selected').data('ref_id');
    console.log($ref_id);
    $('table .comp').val($ref_id);

})

function removeRow(obj) {
    $(obj).parent().parent().remove();
    calculateAmount();
}

function calculateAmount() {
    var $total_amount = 0;
    $('#tblAllowances tbody tr input.amount').each(function() {
        $total_amount += $(this).val() | 0;
    })

    $('#total_amount').val($total_amount);
}

function check(input) {
   if (input.value == 0) {
    alert('The Budget Key must not be zero.');
   }
 }