/**
 * Created by Huzaifa on 9/18/15.
 */
var _reports;
function fnAddToList($obj) {
    var $data = $($obj).parent().data();
    fnAddColumn($data);
}

function fnAddColumn($data) {
    var $_column_name = $data.column_name;
    var $_display_name = $data.display_name;
    var $_column_ratio = $data.column_ratio;

    var $html =  '';
    $html += '<a class="list-group-item" data-column_name="'+$data.column_name+'" data-display_name="'+$data.display_name+'" data-column_ratio="'+$data.column_ratio+'" href="javascript:void(0);">';
    $html += '  <button type="button" onclick="$(this).parent().remove();" class="btn btn-danger btn-xs pull-right">';
    $html += '    <i class="fa fa-remove"></i>';
    $html += '  </button>';
    $html += '  <button type="button" onclick="fnMoveUp(this);" class="btn btn-primary btn-xs pull-right">';
    $html += '    <i class="fa fa-arrow-up"></i></button>';
    $html += '  <button type="button" onclick="fnMoveDown(this);" class="btn btn-primary btn-xs pull-right">';
    $html += '    <i class="fa fa-arrow-down"></i>';
    $html += '  </button>';
    $html += '  <p class="list-group-item-text"><input type="text" value="'+$data.display_name+'" onchange="changeDisplayName(this);"/></p>';
    $html += '</a>';
    $('#_display_column .list-group').append($html);
}

function changeDisplayName($obj) {
    var $value = $($obj).val();
    var $objParent = $($obj).parent().parent()[0];
    $($objParent).attr('data-display_name',$value);
}

function fnMoveDown($obj) {
    var $currObj = $($obj).parent();
    var $nextObj = $($currObj).next('.list-group-item');
    if($nextObj.length > 0) {
        $($nextObj).after($currObj);
    }
}

function fnMoveUp($obj) {
    var $currObj = $($obj).parent();
    var $prevObj = $($currObj).prev('.list-group-item');
    if($prevObj.length > 0) {
        $($prevObj).before($currObj);
    }
}


$(document).on('click','#btnPDF', function() {
    if($('#_display_column .list-group a').length <= 0 ) {
        alert('Please select any column');
        return;
    }

    $display_columns = [];
    $('#_display_column .list-group a').each(function() {
        var $objColumn = {
            'column_ratio':$(this).data('column_ratio'),
            'column_name':$(this).data('column_name'),
            'display_name':$(this).data('display_name')
        };

        $display_columns.push($objColumn);
    });

    // alert($display_columns);

    $data = {
        'page_size': $('#page_size').val(),
        'page_orientation': $('#page_orientation').val(),
        'company_id': $('#company_id').val(),
        'department_id': $('#department_id').val(),
        'from_joining_date': $('#from_joining_date').val(),
        'to_joining_date': $('#to_joining_date').val(),
        'from_leaving_date': $('#from_leaving_date').val(),
        'to_leaving_date': $('#to_leaving_date').val(),
        'status_id': $('#status_id').val(),
        'eobi_status': $('#eobi_status').val(),
        'display_columns' : $display_columns
    };

    // console.log($data);

    var $parameter = $.param($data);
    window.open($URLPrintReport + '&' + $parameter,'_blank');
});

$(document).on('click','#btnSave', function() {
    if($('#report_title').val() == '' ) {
        alert('Report Title is required');
        return;
    }
    if($('#_display_column .list-group a').length <= 0 ) {
        alert('Please select any column');
        return;
    }

    var $display_columns = [];
    $('#_display_column .list-group a').each(function() {
        var $objColumn = {
            'column_name':$(this).data('column_name'),
            'display_name':$(this).data('display_name'),
            'column_ratio':$(this).data('column_ratio')
        };

        $display_columns.push($objColumn);
    });

    var $data = {
        'report_id': $('#report_id').val(),
        'report_title': $('#report_title').val(),
        'display_columns' : $display_columns
    };

    $.ajax({
        url: $URLSaveFormat,
        dataType: 'json',
        type: 'post',
        data: $data,
        mimeType:"multipart/form-data",
        beforeSend: function() {
            $('#btnSave').html('Save <i class="fa fa-refresh fa-spin"></i>');
        },
        complete: function() {
            $('#btnSave').html('Save');
        },
        success: function(json) {
            if(json.success){
                fetchCustomFormats();
            }
            else {
                alert(json.error);
            }
        },
        error: function(xhr, ajaxOptions, thrownError) {
            console.log(xhr.responseText);
        }
    });
});

function removeReport($obj) {
    var $report_id = $($obj).parent().data('report_id');
    $.ajax({
        url: $URLRemoveFormat,
        dataType: 'json',
        type: 'get',
        data: 'report_id='+$report_id,
        mimeType:"multipart/form-data",
        beforeSend: function() {
            $($obj).html('<i class="fa fa-refresh fa-spin"></i>');
        },
        complete: function() {

        },
        success: function(json) {
            if(json.success){
                fetchCustomFormats();
            }
            else {
                alert(json.error);
            }
        },
        error: function(xhr, ajaxOptions, thrownError) {
            console.log(xhr.responseText);
        }
    });
}

$(document).on('click','#_load_report .list-group-item p', function() {
    var $obj = this;
    var $report_id = $($obj).parent().data('report_id');

    var $data = _reports[$report_id];
    $('#report_title').val($data.report_title);
    $('#report_id').val($data.report_id);
    $('#_display_column .list-group').html('');
    var $columns = $data.display_columns;
    for(var idx in $columns) {
        fnAddColumn($columns[idx]);
    }


    console.log($report_id);
});

function fetchCustomFormats() {
    $.ajax({
        url: $URLLoadFormats,
        dataType: 'json',
        type: 'get',
        beforeSend: function() {
            $('#_load_report .list-group').html('');
            $('#_load_report').find('.panel-heading').find('.panel-title').after('<i id="loader" class="fa fa-refresh fa-spin pull-right"></i>');
        },
        complete: function() {
            $('#loader').remove();
        },
        success: function(json) {
            if(json.success){
                console.log(json);
                _reports = json.data;
                for(var idx in _reports) {
                    var $report_title = _reports[idx]['report_title'];
                    var $report_id = _reports[idx]['report_id'];

                    $html =  '';
                    $html += '<a class="list-group-item" data-report_id="'+$report_id+'" href="javascript:void(0);">';
                    $html += '  <button type="button" onclick="removeReport(this)" class="btn btn-danger btn-xs pull-right">';
                    $html += '    <i class="fa fa-remove"></i>';
                    $html += '  </button>';
                    $html += '  <p class="list-group-item-text">'+$report_title+'</p>';
                    $html += '</a>';
                    $('#_load_report .list-group').append($html);

                }
            }
            else {
                alert(json.error);
            }
        },
        error: function(xhr, ajaxOptions, thrownError) {
            console.log(xhr.responseText);
        }
    });
}

$(document).ready(function() {
    fetchCustomFormats();
});