/**
 * Created by Huzaifa on 9/18/15.
 */

var $payrolls;

$(document).on('ready', function() {
    $('#form').valid();
})

function submitDocument() {
    $('button.btnSave').attr('disabled','disabled');
    if($('#form').valid()) {
        var $data = $('#form').serialize();

        $.ajax({
            url: $URLSaveAjax,
            dataType: 'json',
            type: 'post',
            data: $data,
            mimeType:"multipart/form-data",
            beforeSend: function() {

            },
            complete: function() {
                $('.btnSave').removeAttr('disabled');
                $('#loader').remove();
            },
            success: function(json) {
                if(json.success)
                {
                    $('#primary_key').val(json.primary_key);
                    if(json.redirect) {
                        window.location = json.redirect;
                    }
                } else {
                    alert(json.error);
                }
            },
            error: function(xhr, ajaxOptions, thrownError) {
                console.log(xhr.responseText);
            }
        })
    } else {
        $('.btnSave').removeAttr('disabled');
    }
}

$(document).on('click','#btnCalculate', function(e) {
    e.preventDefault();
    if($('#form').valid()) {
        var $data = $('#form').serialize();
        //console.log($data);
        // +'&'+$.param({"payroll_file":$('#userfile')[0].files[0]})
        // $data.push({name: "payroll_file", value:$('#userfile')[0].files[0]});

        var myForm = document.getElementById('form');
        var formData = new FormData(myForm);
        // formData.append("document_date",$('#document_date').val());
        // formData.append("document_title",$('#document_title').val());
        // formData.append("department_id",$('#department_id').val());
        // formData.append("registration_code",$('#registration_code').val());
        // formData.append("from_date",$('#from_date').val());
        // formData.append("to_date",$('#to_date').val());
        // formData.append("all_present",$('#all_present').val());
        // formData.append("formdata", JSON.stringify($data));
        // formData.append('payroll_file', $('#userfile')[0].files[0]);
        //console.log(formData);
        $.ajax({
            url: $URLGetPayroll,
            //dataType: 'text',
            dataType: 'json',
            //dataType: 'jsonp',
            type: 'post',
            data:  formData,
            processData: false,
            contentType: false,
            //contentType: "application/json; charset=utf-8",
            mimeType:"multipart/form-data",
            beforeSend: function() {
                $('#tblPayroll tbody').html('');
                $('#btnCalculate').html('<i class="fa fa-refresh fa-spin"></i>&nbsp;Calculate');
            },
            complete: function() {
                $('#btnCalculate').html('Calculate');
            },
            success: function(json) {
                if(json.success)
                {
                    $('#divPayroll').html(json.html);
                    $payrolls = json.payrolls;
                    $('#divPayroll table').DataTable({
                        paging: false
                    });
                } else {
                    alert(json.error);
                }
            },
            error: function(xhr, ajaxOptions, thrownError) {
                console.log(xhr);
                console.log(ajaxOptions);
                console.log(thrownError);

            }
        })

    }
})

$(document).on('click','#btnDownload', function() {
    var $count = $('#tblPayroll').find('tbody').find('tr').length;
    if($count > 0 ) {
        window.open($URLDownloadExcel, '_blank');
        //window.location.assign($URLDownloadExcell);
    }
})

function displayPopup($obj) {
    var $row_id = $($obj).parent().parent().data('id');
    var $registration_id = $($obj).parent().parent().data('registration_id');

    $.ajax({
        url: $URLGetPayrollData,
        dataType: 'json',
        type: 'post',
        data: 'registration_id='+$registration_id,
        mimeType:"multipart/form-data",
        beforeSend: function() {
            //$('#tblPayroll tbody').html('');
            //$('#btnCalculate').html('<i class="fa fa-refresh fa-spin"></i>&nbsp;Calculate');
        },
        complete: function() {
            //$('#btnCalculate').html('Calculate');
        },
        success: function(json) {
            if(json.success)
            {
                var $payroll = json.payroll;

                var $html = '';
                $html += '<div class="panel panel-default">';
                $html += '<div class="panel-heading">Payroll Update</div>';
                $html += '<div class="panel-body">';
                $html += '<div class="col-sm-12" style="overflow-y: auto;">';
                $html += '  <div class="row">';
                $html += '      <div class="col-sm-3">';
                $html += '          <label>Sr.</label>';
                $html += '          <input type="text" class="form-control" id="sr_no" value="'+($row_id+1)+'" readonly/>';
                $html += '      </div>';
                $html += '      <div class="col-sm-3">';
                $html += '          <label>Emp. Code</label>';
                $html += '          <input type="text" class="form-control" id="employee_code" value="'+$payroll['employee_code']+'" readonly/>';
                $html += '          <input type="hidden" class="form-control" id="employee_registration_id" value="'+$payroll['employee_registration_id']+'" readonly/>';
                $html += '          <input type="hidden" class="form-control" id="employee_id" value="'+$payroll['employee_id']+'" readonly/>';
                $html += '      </div>';
                $html += '      <div class="col-sm-6">';
                $html += '          <label>Emp. Name</label>';
                $html += '          <input type="text" class="form-control" id="employee_name" value="'+$payroll['employee_name']+'" readonly/>';
                $html += '      </div>';
                $html += '  </div>';
                $html += '  <div class="row">';
                $html += '      <div class="col-sm-3">';
                $html += '          <label>Basic Salary</label>';
                $html += '          <input type="text" class="form-control" id="basic_salary" value="'+$payroll['basic_salary']+'" readonly />';
                $html += '      </div>';
                $html += '      <div class="col-sm-3">';
                $html += '          <label>House Rent Allowance</label>';
                $html += '          <input type="text" class="form-control" id="house_rent_allowance" value="'+$payroll['house_rent_allowance']+'" readonly/>';
                $html += '          <input type="hidden" class="form-control" id="house_rent_percent" value="'+$payroll['house_rent_percent']+'" readonly/>';
                $html += '      </div>';
                $html += '      <div class="col-sm-3">';
                $html += '          <label>Grossable Allowance</label>';
                $html += '          <input type="text" class="form-control" id="grossable_allowance" value="'+$payroll['grossable_allowance']+'" readonly/>';
                $html += '      </div>';
                $html += '      <div class="col-sm-3">';
                $html += '          <label>Taxable Allowance</label>';
                $html += '          <input type="text" class="form-control" id="taxable_allowance" value="'+$payroll['taxable_allowance']+'" readonly/>';
                $html += '      </div>';
                $html += '  </div>';
                $html += '  <div class="row">';
                $html += '      <div class="col-sm-3">';
                $html += '          <label>Arrears</label>';
                $html += '          <input onchange="calcTaxable();" type="text" class="form-control" id="arrears" value="'+$payroll['arrears']+'" />';
                $html += '      </div>';
                $html += '      <div class="col-sm-3">';
                $html += '          <label>Manual Addition</label>';
                $html += '          <input onchange="calcTaxable();" type="text" class="form-control" id="manual_addition" value="'+$payroll['manual_addition']+'" />';
                $html += '      </div>';
                $html += '      <div class="col-sm-3">';
                $html += '          <label>Overtime</label>';
                $html += '          <input onchange="calcTaxable();" type="text" class="form-control" id="overtime" value="'+$payroll['overtime']+'" />';
                $html += '      </div>';
                $html += '      <div class="col-sm-3">';
                $html += '          <label>Taxable Salary</label>';
                $html += '          <input type="text" class="form-control" id="taxable_salary" value="'+$payroll['taxable_salary']+'" readonly/>';
                $html += '      </div>';
                $html += '  </div>';
                $html += '  <div class="row">';
                $html += '      <div class="col-sm-3">';
                $html += '          <label>Gross Salary</label>';
                $html += '          <input type="text" class="form-control" id="gross_salary" value="'+$payroll['gross_salary']+'" readonly/>';
                $html += '      </div>';
                $html += '      <div class="col-sm-3">';
                $html += '          <label>Other Deduction</label>';
                $html += '          <input type="text" class="form-control" id="other_deduction" value="'+$payroll['other_deduction']+'" readonly/>';
                $html += '      </div>';
                $html += '      <div class="col-sm-3">';
                $html += '          <label>Manual Deduction</label>';
                $html += '          <input onchange="calcPayable();" type="text" class="form-control" id="manual_deduction" value="'+$payroll['manual_deduction']+'" />';
                $html += '      </div>';
                $html += '      <div class="col-sm-3">';
                $html += '          <label>Net Salary</label>';
                $html += '          <input type="text" class="form-control" id="net_salary" value="'+$payroll['net_salary']+'" readonly />';
                $html += '      </div>';
                $html += '  </div>';
                $html += '  <div class="row">';
                $html += '      <div class="col-sm-3">';
                $html += '          <label>Working Days</label>';
                $html += '          <input type="text" class="form-control" id="working_days" value="'+$payroll['working_days']+'" readonly/>';
                $html += '      </div>';
                $html += '      <div class="col-sm-3">';
                $html += '          <label>Total Present</label>';
                $html += '          <input type="text" class="form-control" id="total_present" value="'+$payroll['total_present']+'" readonly />';
                $html += '      </div>';
                $html += '      <div class="col-sm-3">';
                $html += '          <label>Total Absent</label>';
                $html += '          <input onchange="calcPayable();" type="text" class="form-control" id="total_absent" value="'+$payroll['total_absent']+'" />';
                $html += '      </div>';
                $html += '  </div>';
                $html += '  <div class="row">';
                $html += '      <div class="col-sm-3">';
                $html += '          <label>Attendance deduction</label>';
                $html += '          <input onchange="calcPayable();" type="text" class="form-control" id="attendance_deduction" value="'+$payroll['attendance_deduction']+'" />';
                $html += '          <input type="hidden" class="form-control" id="daily_deduction" value="'+$payroll['daily_deduction']+'" />';
                $html += '      </div>';
                $html += '      <div class="col-sm-3">';
                $html += '          <label>Tax Deduction</label>';
                $html += '          <input type="hidden" class="form-control" id="taxable" value="'+$payroll['taxable']+'" />';
                if($payroll['taxable']) {
                    $html += '          <input onchange="calcPayable();" type="text" class="form-control" id="tax_deduction" value="'+$payroll['tax_deduction']+'" />';
                } else {
                    $html += '          <input onchange="calcPayable();" type="text" class="form-control" id="tax_deduction" value="'+$payroll['tax_deduction']+'" readonly/>';
                }
                $html += '      </div>';
                $html += '      <div class="col-sm-3">';
                $html += '          <label>Payable Salary</label>';
                $html += '          <input type="text" class="form-control" id="payable_salary" value="'+$payroll['payable_salary']+'" readonly/>';
                $html += '      </div>';
                $html += '  </div>';
                $html += '</div>';
                $html += '</div>';
                $html += '</div>';

                var dialog = bootbox.dialog({
                    message: $html,
                    backdrop: true,
                    buttons: {
                        cancel: {
                            label: "Cancel",
                            className: 'btn-default'
                        },
                        ok: {
                            label: "Update",
                            className: 'btn-info',
                            callback: function() {
                                var $data = {
                                    'employee_registration_id' : $payroll['employee_registration_id'],
                                    'employee_id' : $payroll['employee_id'],
                                    'document_date': $('#document_date').val(),
                                    'arrears': $('#arrears').val(),
                                    'manual_addition': $('#manual_addition').val(),
                                    'overtime': $('#overtime').val(),
                                    'manual_deduction': $('#manual_deduction').val(),
                                    'total_absent': $('#total_absent').val(),
                                    'tax_deduction': $('#tax_deduction').val(),
                                };
                                //console.log($data);
                                $.ajax({
                                    url: $URLUpdatePayrollData,
                                    dataType: 'json',
                                    type: 'post',
                                    data: $data,
                                    mimeType:"multipart/form-data",
                                    beforeSend: function() {
                                        //$('#tblPayroll tbody').html('');
                                        //$('#btnCalculate').html('<i class="fa fa-refresh fa-spin"></i>&nbsp;Calculate');
                                        $payrolls=[];
                                    },
                                    complete: function() {
                                        //$('#btnCalculate').html('Calculate');
                                    },
                                    success: function(json) {
                                        if(json.success)
                                        {
                                            dialog.modal('hide');
                                            $('#divPayroll').html(json.html);
                                            $payrolls = json.payrolls;

                                            $('#divPayroll table').DataTable({
                                                paging: false
                                            });
                                        } else {
                                            alert(json.error);
                                        }
                                    },
                                    error: function(xhr, ajaxOptions, thrownError) {
                                        console.log(xhr.responseText);
                                    }
                                });

                                return false;
                            }
                        }
                    }
                });
            } else {
                alert(json.error);
            }
        },
        error: function(xhr, ajaxOptions, thrownError) {
            console.log(xhr.responseText);
        }
    })

}

function calcTaxable() {
    var $basic_salary = $('#basic_salary').val();
    var $house_rent_allowance = $('#house_rent_allowance').val();
    var $grossable_allowance = $('#grossable_allowance').val();
    var $taxable_allowance = $('#taxable_allowance').val();
    var $arrears = $('#arrears').val();
    var $manual_addition = $('#manual_addition').val();
    var $overtime = $('#overtime').val();

    var $gross_salary = parseFloat($basic_salary)+parseFloat($grossable_allowance)+parseFloat($arrears)+parseFloat($manual_addition)+parseFloat($overtime);
    var $taxable_salary = parseFloat($basic_salary)+parseFloat($house_rent_allowance)+parseFloat($taxable_allowance)+parseFloat($arrears)+parseFloat($manual_addition)+parseFloat($overtime);
    $('#gross_salary').val($gross_salary);
    $('#taxable_salary').val($taxable_salary);

    var $data = {
        'employee_registration_id' : $('#employee_registration_id').val(),
        'employee_id' : $('#employee_id').val(),
        'document_date' : $('#document_date').val(),
        'taxable' : $('#taxable').val(),
        'taxable_salary' : $taxable_salary,
    };
    $.ajax({
        url: $URLGetTaxAmount,
        dataType: 'json',
        type: 'post',
        data: $data,
        mimeType:"multipart/form-data",
        beforeSend: function() {
            //$('#tblPayroll tbody').html('');
            //$('#btnCalculate').html('<i class="fa fa-refresh fa-spin"></i>&nbsp;Calculate');
        },
        complete: function() {
            //$('#btnCalculate').html('Calculate');
        },
        success: function(json) {
            if(json.success)
            {
                $('#tax_deduction').val(json.tax_deduction);
                calcPayable();
            } else {
                alert(json.error);
            }
        },
        error: function(xhr, ajaxOptions, thrownError) {
            console.log(xhr.responseText);
        }
    });

}

function calcPayable() {
    var $gross_salary = $('#gross_salary').val();
    var $taxable_salary = $('#taxable_salary').val();
    var $other_deduction = $('#other_deduction').val();
    var $manual_deduction = $('#manual_deduction').val();

    var $net_salary = parseFloat($gross_salary)-parseFloat($other_deduction)-parseFloat($manual_deduction);
    var $tax_deduction = $('#tax_deduction').val();

    var $working_days = $('#working_days').val();
    var $total_absent = $('#total_absent').val();
    var $total_present = $working_days - $total_absent;
    var $daily_deduction = $('#daily_deduction').val();

    var $attendance_deduction = ($daily_deduction*$total_absent).toFixed(0);
    if($attendance_deduction > ($net_salary - $tax_deduction)) {
        $attendance_deduction = ($net_salary - $tax_deduction);
    }

    var $payable_salary = (parseFloat($net_salary)-parseFloat($attendance_deduction)-parseFloat($tax_deduction)).toFixed(0);

    var $data = {
        'gross_salary' : $gross_salary,
        'taxable_salary' : $taxable_salary,
        'other_deduction' : $other_deduction,
        'manual_deduction' : $manual_deduction,
        'net_salary' : $net_salary,
        'working_days' : $working_days,
        'total_absent' : $total_absent,
        'total_present' : $total_present,
        'daily_deduction' : $daily_deduction,
        'attendance_deduction' : $attendance_deduction,
        'payable_salary' : $payable_salary,
    };

    console.log($data);

    $('#gross_salary').val($gross_salary);
    $('#taxable_salary').val($taxable_salary);
    $('#net_salary').val($net_salary);
    $('#attendance_deduction').val($attendance_deduction);
    $('#payable_salary').val($payable_salary);
    $('#total_present').val($total_present);

}

function calculatePayable($id) {
    var $basic_salary = $('#payroll_'+$id+'_basic_salary').val();
    var $other_allowance = $('#payroll_'+$id+'_other_allowance').val();
    var $arrears = $('#payroll_'+$id+'_arrears').val();
    //var $gross_salary = $('#payroll_'+$id+'_gross_salary').val();
    var $gross_salary = (parseFloat($basic_salary) + parseFloat($other_allowance) + parseFloat($arrears));
    var $tax_deduction = $('#payroll_'+$id+'_tax_deduction').val();
    var $other_deduction = $('#payroll_'+$id+'_other_deduction').val();
    var $manual_addition = $('#payroll_'+$id+'_manual_addition').val();
    var $manual_deduction = $('#payroll_'+$id+'_manual_deduction').val();
    var $overtime = $('#payroll_'+$id+'_overtime').val();
    var $net_salary = parseFloat($gross_salary)-parseFloat($tax_deduction)-parseFloat($other_deduction)+parseFloat($manual_addition)+parseFloat($overtime)-parseFloat($manual_deduction);
    var $total_present = $('#payroll_'+$id+'_total_present').val();
    var $working_days = $('#payroll_'+$id+'_working_days').val();
    var $total_absent = $working_days - $total_present;
    var $deduction_amount = ($gross_salary/$working_days*$total_absent).toFixed(0);
    //var $payable_salary = ($net_salary/$working_days*$total_present).toFixed(0);
    var $payable_salary = ($net_salary-$deduction_amount).toFixed(0);

    $('#payroll_'+$id+'_gross_salary').val($gross_salary);
    $('#payroll_'+$id+'_total_absent').val($total_absent);
    $('#payroll_'+$id+'_attendance_deduction').val($deduction_amount);
    $('#payroll_'+$id+'_net_salary').val($net_salary);
    $('#payroll_'+$id+'_payable_salary').val($payable_salary);

    calculateTotal();
}

function getTaxDescription($obj) {
    //var $registration_id = $($obj).parent().parent().parent().parent().data('registration_id');
    var $registration_id = $($obj).parent().parent().data('registration_id');
    var $taxDescriptions = $payrolls[$registration_id]['tax_description'];
    console.log($taxDescriptions);
    if (typeof $taxDescriptions !== 'undefined' && $taxDescriptions.length > 0) {
        // the array is defined and has at least one element
        $html = '';
        $html += '<table id="taxDescription" class="table table-striped">';
        $($taxDescriptions).each(function($i, $data) {
            $html += '  <tr>';
            if($data['break']) {
                $html += '      <td class="text-left" style="border-bottom: 1px solid black;">'+$data['description']+'</td>';
                $html += '      <td class="text-right" style="border-bottom: 1px solid black;">'+$data['value']+'</td>';
            } else {
                $html += '      <td class="text-left">'+$data['description']+'</td>';
                $html += '      <td class="text-right">'+$data['value']+'</td>';
            }
            $html += '  </tr>';
        });
        $html += '</table>';

        var dialog = bootbox.dialog({
            message: $html,
            backdrop: true
        });
    }
}

function displayDeduction($obj) {
    //var $registration_id = $($obj).parent().parent().parent().parent().data('registration_id');
    var $registration_id = $($obj).parent().parent().data('registration_id');
    var $deductions = $payrolls[$registration_id]['deductions'];
    if (typeof $deductions !== 'undefined' && $deductions.length > 0) {
        // the array is defined and has at least one element
        $html = '';
        $html += '<table id="tblDeductions" class="table table-striped">';
        $html += '<thead>';
        $html += '<tr>';
        $html += '<th>Ref</th>';
        $html += '<th>Deduction</th>';
        $html += '<th>Amount</th>';
        $html += '</tr>';
        $html += '</thead>';
        $html += '<tbody>';
        var $total_amount = 0;
        $($deductions).each(function($i, $deduction) {
            var $amount = parseFloat($deduction['deduction_amount']);
            $total_amount += $amount;
            $html += '<tr>';
            $html += '<td class="text-left">'+$deduction['ref_document']+'</td>';
            $html += '<td class="text-left">'+$deduction['deduction_name']+' ['+$deduction['deduction_code']+']</td>';
            $html += '<td class="text-right">'+$deduction['deduction_amount']+'</td>';
            $html += '<tr>';
        });
        $html += '</tbody>';
        $html += '</table>';

        var dialog = bootbox.dialog({
            message: $html,
            backdrop: true
        });
    }
}

function displayAllowance($obj) {
    //var $registration_id = $($obj).parent().parent().parent().parent().data('registration_id');
    var $registration_id = $($obj).parent().parent().data('registration_id');
    var $allowances = $payrolls[$registration_id]['allowances'];
    if (typeof $allowances !== 'undefined' && $allowances.length > 0) {
        // the array is defined and has at least one element
        $html = '';
        $html += '<table id="tblallowances" class="table table-striped">';
        $html += '<thead>';
        $html += '<tr>';
        $html += '<th>Allowance</th>';
        $html += '<th>Amount</th>';
        $html += '</tr>';
        $html += '</thead>';
        $html += '<tbody>';
        var $total_amount = 0;
        $($allowances).each(function($i, $allowance) {
            var $amount = parseFloat($allowance['allowance_amount']);
            $total_amount += $amount;
            $html += '<tr>';
            $html += '<td class="text-left">'+$allowance['allowance_name']+'</td>';
            $html += '<td class="text-right">'+$allowance['allowance_amount']+'</td>';
            $html += '<tr>';
        });
        $html += '</tbody>';
        $html += '</table>';

        var dialog = bootbox.dialog({
            message: $html,
            backdrop: true
        });
    }
}

function calculateTotal() {
    var $total_house_rent_allowance=0;
    var $total_basic_salary=0;
    var $total_other_allowance=0;
    var $total_arrears=0;
    var $total_gross_salary=0;
    var $total_tax_deduction=0;
    var $total_other_deduction=0;
    var $total_manual_addition=0;
    var $total_manual_deduction=0;
    var $total_overtime=0;
    var $total_net_salary=0;
    var $total_payable_salary=0;
    var $total_taxable_salary=0;
    $('#tblPayroll tbody tr').each(function() {
        var $id = $(this).data('id');
        var $registration_id = $(this).data('registration_id');
        if(typeof $id !='undefined') {
            var $checked = $('#payroll_'+$id+'_selected').is(':checked');
            if($checked) {
                $total_house_rent_allowance += parseFloat($payrolls[$registration_id]['house_rent_allowance'] | 0);
                $total_basic_salary += parseFloat($payrolls[$registration_id]['basic_salary'] | 0);
                $total_other_allowance += parseFloat($payrolls[$registration_id]['other_allowance'] | 0);
                $total_arrears += parseFloat($payrolls[$registration_id]['arrears'] | 0);
                $total_gross_salary += parseFloat($payrolls[$registration_id]['gross_salary'] | 0);
                $total_tax_deduction += parseFloat($payrolls[$registration_id]['tax_deduction'] | 0);
                $total_other_deduction += parseFloat($payrolls[$registration_id]['other_deduction'] | 0);
                $total_manual_addition += parseFloat($payrolls[$registration_id]['manual_addition'] | 0);
                $total_manual_deduction += parseFloat($payrolls[$registration_id]['manual_deduction'] | 0);
                $total_overtime += parseFloat($payrolls[$registration_id]['overtime'] | 0);
                $total_net_salary += parseFloat($payrolls[$registration_id]['net_salary'] | 0);
                $total_payable_salary += parseFloat($payrolls[$registration_id]['payable_salary'] | 0);
                $total_taxable_salary += parseFloat($payrolls[$registration_id]['taxable_salary'] | 0);

                var $data = {
                    total_house_rent_allowance: $total_house_rent_allowance,
                    total_basic_salary: $total_basic_salary,
                    total_other_allowance: $total_other_allowance,
                    total_arrears: $total_arrears,
                    total_gross_salary: $total_gross_salary,
                    total_tax_deduction: $total_tax_deduction,
                    total_other_deduction: $total_other_deduction,
                    total_manual_addition: $total_manual_addition,
                    total_manual_deduction: $total_manual_deduction,
                    total_overtime: $total_overtime,
                    total_net_salary: $total_net_salary,
                    total_payable_salary: $total_payable_salary
                };

                console.log($data);
            }
        }
    });

    $('#total_sa').text($total_house_rent_allowance + $total_gross_salary);
    $('#total_basic_salary').text($total_basic_salary);
    $('#total_other_allowance').text($total_other_allowance);
    $('#total_arrears').text($total_arrears);
    $('#total_gross_salary').text($total_gross_salary);
    $('#total_tax_deduction').text($total_tax_deduction);
    $('#total_other_deduction').text($total_other_deduction);
    $('#total_manual_addition').text($total_manual_addition);
    $('#total_manual_deduction').text($total_manual_deduction);
    $('#total_overtime').text($total_overtime);
    $('#total_net_salary').text($total_net_salary);
    $('#total_payable_salary').text($total_payable_salary);
    $('#total_taxable_salary').text($total_taxable_salary);
}

$(document).on('click','input[type=checkbox]',function() {
    calculateTotal();
});