/**
 * Created by Huzaifa on 9/18/15.
 */

$(document).on('ready', function() {
    $('#form').valid();
})

function submitDocument() {
    $('button.btnSave').attr('disabled','disabled');
    if($('#form').valid()) {
        var $data = $('#form').serialize();

        $.ajax({
            url: $URLSaveAjax,
            dataType: 'json',
            type: 'post',
            data: $data,
            mimeType:"multipart/form-data",
            beforeSend: function() {

            },
            complete: function() {
                $('.btnSave').removeAttr('disabled');
                $('#loader').remove();
            },
            success: function(json) {
                if(json.success)
                {
                    $('#primary_key').val(json.primary_key);
                    if(json.redirect) {
                        window.location = json.redirect;
                    }
                } else {
                    alert(json.error);
                }
            },
            error: function(xhr, ajaxOptions, thrownError) {
                console.log(xhr.responseText);
            }
        })
    } else {
        $('.btnSave').removeAttr('disabled');
    }
}

$(document).on('change','#deduction_id', function() {
    var $company_account_id = $(this).find('option:selected').data('company_account_id');
    $('#company_account_id').val($company_account_id).trigger('change');
})

$(document).on('change','#total_amount', function() {
    var $value = $(this).val();
    if($value>0) {
        $('#total_installment').prop('readonly', false);
    } else {
        $('#total_installment').val(0).prop('readonly', true);
    }
})

$(document).on('change','#employee_registration_id',function() {
    var $data = $('#employee_registration_id option:selected').data();
    $('#registration_code').val($data['registration_code']);
    $('#employee_code').val($data['employee_code']);
    $('#employee_id').val($data['employee_id']);

});

$(document).on('change', '#start_date, #total_amount, #total_installment', function() {
    var $start_date = $('#start_date').val();
    var $total_amount = $('#total_amount').val();
    var $total_installment = $('#total_installment').val();

    if($start_date=='' || $total_amount=='' || $total_installment=='') {
        $('#tblLoanInstallment tbody').html('');
    } else {
        var $data = {
            'start_date': $start_date,
            'total_amount': $total_amount,
            'total_installment': $total_installment,
            'total_installment_amount': $total_amount
        }

        $.ajax({
            url: $URLGetInstallment,
            dataType: 'json',
            type: 'post',
            data: $data,
            mimeType:"multipart/form-data",
            beforeSend: function() {

            },
            complete: function() {
                $('#loader').remove();
            },
            success: function(json) {
                if(json.success)
                {
                    $('#tblLoanInstallment tbody').html(json.html);
                    //$('#total_installment_amount').val(parseFloat(json.running_amount).toFixed(2));
                    calculateTotal();
                    setFieldFormat();

                    $grid_row_installment = json.grid_row_installment;

                } else {
                    alert(json.error);
                }
            },
            error: function(xhr, ajaxOptions, thrownError) {
                console.log(xhr.responseText);
            }
        })
    }
})





$(document).on('click','.btnRemoveGrid', function() {
    var $row_id = $(this).parent().parent().data('grid_row_installment');

    $(this).parent().parent().remove();
    calculateTotal();
});

$(document).on('click','.btnAddInstallment', function() {
    $html = '';
    $html += '<tr id="grid_row_installment_'+$grid_row_installment+'" data-grid_row_installment="'+$grid_row_installment+'">';
    $html += '<td>';
    $html += '<input type="text" class="form-control dtpDate" id="installment_'+$grid_row_installment+'_installment_date" name="installments['+$grid_row_installment+'][installment_date]" value="" />';
    $html += '</td>';
    $html += '<td>';
    $html += '<input onchange="calculateTotal();" type="text" class="form-control text-right fPDecimal" id="installment_'+$grid_row_installment+'_installment_amount" name="installments['+$grid_row_installment+'][installment_amount]" value="" />';
    $html += '</td>';
    $html += '<td><select class="form-control" id="installment_'+$grid_row_installment+'_adjustment_type" name="installments['+$grid_row_installment+'][adjustment_type]" >';
    $html += '<option value="Payroll">Payroll</option>';
    $html += '<option value="Cash" >Cash</option>';
    $html += '<option value="Transfer" >Transfer</option>';
    $html += '</select>';
    $html += '</td>';
    $html += '<td>';
    $html += '<input type="text" class="form-control" id="installment_'+$grid_row_installment+'_remarks" name="installments['+$grid_row_installment+'][installment_remarks]" value="" />';
    $html += '</td>';
    $html += '<td><a title="Remove" class="btnRemoveGrid btn btn-xs btn-danger" href="javascript:void(0);"><i class="fa fa-times"></i></a></td>';
    $html += '</tr>';

    $('#tblLoanInstallment').append($html);
    setFieldFormat();
    $grid_row_installment++;

});
function calculateTotal() {
    var $total_installment = 0;
    var $total_amount = $('#total_amount').val();
    $('#total_amount').val(parseFloat($total_amount).toFixed(2));
    var $total_amount = 0;
    $('#tblLoanInstallment tbody tr').each(function() {
        $total_installment +=1;

        var $row_id = $(this).data('grid_row_installment');
        var $row_id2 = $(this).data('grid_row_total_amount');
        var $installment_amount = $('#installment_'+$row_id+'_installment_amount').val();

        $total_amount += parseFloat($installment_amount);

    })

    $('#total_installment_amount').val($total_amount.toFixed(2));
    $('#total_installment').val($total_installment);

}
