/**
 * Created by Huzaifa on 9/18/15.
 */

var $payrolls;

$(document).on('ready', function() {
    $('#form').valid();
});

function submitDocument() {
    $('button.btnSave').attr('disabled','disabled');
    if($('#form').valid()) {
        var $data = $('#form').serialize();

        $.ajax({
            url: $URLSaveAjax,
            dataType: 'json',
            type: 'post',
            data: $data,
            mimeType:"multipart/form-data",
            beforeSend: function() {

            },
            complete: function() {
                $('.btnSave').removeAttr('disabled');
                $('#loader').remove();
            },
            success: function(json) {
                if(json.success)
                {
                    $('#primary_key').val(json.primary_key);
                    if(json.redirect) {
                        window.location = json.redirect;
                    }
                } else {
                    alert(json.error);
                }
            },
            error: function(xhr, ajaxOptions, thrownError) {
                console.log(xhr.responseText);
            }
        })
    } else {
        $('.btnSave').removeAttr('disabled');
    }
}

$(document).on('click','#btnCalculate', function() {
    var $bank_id = $('#bank_id').val();
    var $department_id = $('#department_id').val();
    var $registration_code = $('#registration_code').val();

    if($department_id===null && $registration_code==="") {
        alert('Department or Reg. No. required.');
    } else {
        var $data = {
            'bank_id': $bank_id,
            'department_id': $department_id,
            'registration_code': $registration_code,
        };
        $.ajax({
            url: $URLGetEmployeeData,
            dataType: 'json',
            type: 'post',
            data: $data,
            mimeType:"multipart/form-data",
            beforeSend: function() {
                $('#tblPayroll tbody').html('');
                $('#btnCalculate').html('<i class="fa fa-refresh fa-spin"></i>&nbsp;Calculate');
            },
            complete: function() {
                $('#btnCalculate').html('Calculate');
            },
            success: function(json) {
                if(json.success)
                {
                    $('#tblManualAllowance tbody').html(json.html);
                    $payrolls = json.payrolls;
                } else {
                    alert(json.error);
                }
            },
            error: function(xhr, ajaxOptions, thrownError) {
                console.log(xhr.responseText);
            }
        })
    }
});

$(document).on('click','#chk_all',function() {
    var $is_seleted = $(this).is(':checked');
    $('#tblManualAllowance').find('tbody').find('tr').each(function(i,obj) {
        var $index = $(obj).data('index');
        if($is_seleted) {
            $('#detail_'+$index+'_selected').prop('checked',true);
            $('#detail_'+$index+'_allowance_amount').prop('readonly',false);
        } else {
            $('#detail_'+$index+'_selected').prop('checked',false);
            $('#detail_'+$index+'_allowance_amount').val(0);
            $('#detail_'+$index+'_allowance_amount').prop('readonly',true);
        }
    });
});

$(document).on('click','.check_box',function() {
    var $index = $(this).parent().parent().data('index');
    var $is_seleted = $(this).is(':checked');
    if($is_seleted) {
        $('#detail_'+$index+'_allowance_amount').prop('readonly',false);
    } else {
        $('#detail_'+$index+'_allowance_amount').val(0);
        $('#detail_'+$index+'_allowance_amount').prop('readonly',true);
    }
});


$(document).on('change','.fPDecimal', function() {
    var $total_amount = 0;
    $('#tblManualAllowance').find('tbody').find('tr').each(function() {
        var $index = $(this).data('index');
        var $is_selected = $('#detail_'+$index+'_selected').is(':checked');
        var $amount = $('#detail_'+$index+'_allowance_amount').val();

        if($is_selected) {
            $total_amount += parseFloat($amount);
        }
        console.log($index, $is_selected, $amount, $total_amount);
    });


    $('#total_allowance').val($total_amount);
});