/**
 * Created by Huzaifa on 9/18/15.
 */

var $payrolls;

$(document).on('ready', function() {
    $('#form').valid();
});

function submitDocument() {
    $('button.btnSave').attr('disabled','disabled');
    if($('#form').valid()) {
        var $data = $('#form').serialize();

        $.ajax({
            url: $URLSaveAjax,
            dataType: 'json',
            type: 'post',
            data: $data,
            mimeType:"multipart/form-data",
            beforeSend: function() {

            },
            complete: function() {
                $('.btnSave').removeAttr('disabled');
                $('#loader').remove();
            },
            success: function(json) {
                if(json.success)
                {
                    $('#primary_key').val(json.primary_key);
                    if(json.redirect) {
                        window.location = json.redirect;
                    }
                } else {
                    alert(json.error);
                }
            },
            error: function(xhr, ajaxOptions, thrownError) {
                console.log(xhr.responseText);
            }
        })
    } else {
        $('.btnSave').removeAttr('disabled');
    }
}

$(document).on('click','#btnCalculate', function() {
    if($('#form').valid()) {
        var $data = $('#form').serialize();

        $.ajax({
            url: $URLGetPayroll,
            dataType: 'json',
            type: 'post',
            data: $data,
            mimeType:"multipart/form-data",
            beforeSend: function() {
                $('#tblPayroll tbody').html('');
                $('#btnCalculate').html('<i class="fa fa-refresh fa-spin"></i>&nbsp;Calculate');
            },
            complete: function() {
                $('#btnCalculate').html('Calculate');
            },
            success: function(json) {
                if(json.success)
                {
                    $('#tblPayroll tbody').html(json.html);
                    $payrolls = json.payrolls;
                } else {
                    alert(json.error);
                }
            },
            error: function(xhr, ajaxOptions, thrownError) {
                console.log(xhr.responseText);
            }
        })
    }
});

function calculatePayable($id) {
    var $employee_registration_id = $('#payroll_'+$id+'_employee_registration_id').val();
    var $basic_salary = $('#payroll_'+$id+'_basic_salary').val();
    var $document_date = $('#document_date').val();
    var $from_date = $('#from_date').val();
    var $to_date = $('#to_date').val();
    var $exclude_payroll = $('#exclude_payroll').is(':checked');

    $.ajax({
        url: $URLGetTaxAmount,
        dataType: 'json',
        type: 'post',
        data: 'row_id='+$id+'&employee_registration_id='+$employee_registration_id+'&basic_salary='+$basic_salary+'&document_date='+$document_date+'&from_date='+$from_date+'&to_date='+$to_date+'&exclude_payroll='+$exclude_payroll,
        mimeType:"multipart/form-data",
        beforeSend: function() {
            $payrolls = [];
        },
        complete: function() {
            $('#btnCalculate').html('Calculate');
        },
        success: function(json) {
            if(json.success) {
                console.log(json.payrolls);
                $payrolls = json.payrolls;
                var $row_id = json.row_id;
                var $basic_salary = parseFloat(json.basic_salary).toFixed(2);
                var $tax_amount = parseFloat(json.remaining_tax_amount).toFixed(2);
                var $payable_amount = ($basic_salary - $tax_amount).toFixed(2);

                $('#payroll_'+$row_id+'_gross_salary').val($basic_salary);
                $('#payroll_'+$row_id+'_taxable_salary').val($basic_salary);
                $('#payroll_'+$row_id+'_net_salary').val($basic_salary);
                $('#payroll_'+$row_id+'_tax_deduction').val($tax_amount);
                $('#payroll_'+$row_id+'_payable_salary').val($payable_amount);

                calculateTotal();
            } else {
                alert(json.error);
            }
        },
        error: function(xhr, ajaxOptions, thrownError) {
            console.log(xhr.responseText);
        }
    })
}

function updatePayable($id) {
    var $net_salary = $('#payroll_'+$id+'_net_salary').val();
    var $tax_deduction = $('#payroll_'+$id+'_tax_deduction').val();
    var $payable_amount = (parseFloat($net_salary) - parseFloat($tax_deduction)).toFixed(2);
    $('#payroll_'+$id+'_payable_salary').val($payable_amount);

    calculateTotal();
}

function getTaxDescription($obj) {
    var $registration_id = $($obj).parent().parent().parent().parent().data('registration_id');
    var $taxDescriptions = $payrolls[$registration_id]['tax_description'];
    if (typeof $taxDescriptions !== 'undefined' && $taxDescriptions.length > 0) {
        // the array is defined and has at least one element
        $html = '';
        $html += '<table id="taxDescription" class="table table-striped">';
        $($taxDescriptions).each(function($i, $data) {
            //var $value = parseFloat($value['amount']);
            $html += '  <tr>';
            if($data['break']) {
                $html += '      <td class="text-left" style="border-bottom: 1px solid black;">'+$data['description']+'</td>';
                $html += '      <td class="text-right" style="border-bottom: 1px solid black;">'+$data['value']+'</td>';
            } else {
                $html += '      <td class="text-left">'+$data['description']+'</td>';
                $html += '      <td class="text-right">'+$data['value']+'</td>';
            }
            $html += '  </tr>';
        });
        $html += '</table>';

        var dialog = bootbox.dialog({
            message: $html,
            backdrop: true
        });
    }
}

function calculateTotal() {
    var $total_house_rent_allowance=0;
    var $total_basic_salary=0;
    var $total_other_allowance=0;
    var $total_arrears=0;
    var $total_gross_salary=0;
    var $total_tax_deduction=0;
    var $total_other_deduction=0;
    var $total_manual_addition=0;
    var $total_manual_deduction=0;
    var $total_overtime=0;
    var $total_net_salary=0;
    var $total_payable_salary=0;
    $('#tblPayroll tbody tr').each(function() {
        var $id = $(this).data('id');
        if(typeof $id !='undefined') {
            var $checked = $('#payroll_'+$id+'_selected').is(':checked');
            if($checked) {
                $total_house_rent_allowance += parseFloat($('#payroll_'+$id+'_house_rent_allowance').val() | 0);
                $total_basic_salary += parseFloat($('#payroll_'+$id+'_basic_salary').val() | 0);
                $total_other_allowance += parseFloat($('#payroll_'+$id+'_other_allowance').val() | 0);
                $total_arrears += parseFloat($('#payroll_'+$id+'_arrears').val() | 0);
                $total_gross_salary += parseFloat($('#payroll_'+$id+'_gross_salary').val() | 0);
                $total_tax_deduction += parseFloat($('#payroll_'+$id+'_tax_deduction').val() | 0);
                $total_other_deduction += parseFloat($('#payroll_'+$id+'_other_deduction').val() | 0);
                $total_manual_addition += parseFloat($('#payroll_'+$id+'_manual_addition').val() | 0);
                $total_manual_deduction += parseFloat($('#payroll_'+$id+'_manual_deduction').val() | 0);
                $total_overtime += parseFloat($('#payroll_'+$id+'_overtime').val() | 0);
                $total_net_salary += parseFloat($('#payroll_'+$id+'_net_salary').val() | 0);
                $total_payable_salary += parseFloat($('#payroll_'+$id+'_payable_salary').val() | 0);
            }
        }
    });
    //console.log($total_tax_deduction);
    $('#total_sa').text($total_house_rent_allowance + $total_gross_salary);
    $('#total_basic_salary').text($total_basic_salary);
    $('#total_other_allowance').text($total_other_allowance);
    $('#total_arrears').text($total_arrears);
    $('#total_gross_salary').text($total_gross_salary);
    $('#total_tax_deduction').text($total_tax_deduction);
    $('#total_other_deduction').text($total_other_deduction);
    $('#total_manual_addition').text($total_manual_addition);
    $('#total_manual_deduction').text($total_manual_deduction);
    $('#total_overtime').text($total_overtime);
    $('#total_net_salary').text($total_net_salary);
    $('#total_payable_salary').text($total_payable_salary);
}

$(document).on('click','input[type=checkbox]',function() {
    calculateTotal();
})