/**
 * Created by Huzaifa on 9/18/15.
 */
var $ref_documents;

$(document).on('ready', function() {
    $('#form').valid();
});

$(document).on('change','#employee_registration_id',function() {
    var $employee_registration_id = $(this).val();
    var $obj = $(this).find('option:selected').data();
    $('#employee_code').val($obj['employee_code']);
    $('#employee_address').val($obj['employee_address']);
    $('#employee_name').val($obj.data['text']);

    $('#ref_documents').html('').trigger('change');
    $ref_documents=null;
    $.ajax({
        url: $URLGetReferenceDocuments,
        dataType: 'json',
        type: 'post',
        data: 'employee_registration_id='+$employee_registration_id,
        mimeType:"multipart/form-data",
        beforeSend: function() {
            $('#ref_document').before('<i id="loader" class="fa-refresh fa-spin"></i>');
        },
        complete: function() {
            $('#loader').remove();
        },
        success: function(json) {
            if(json.success)
            {
                $ref_documents = json.documents;
                var $html = '<option value="">&nbsp;</option>';
                $.each($ref_documents,function($i,$doc) {
                    $html += '<option value="'+$i+'">'+$doc['document_identity']+'</option>';
                });

                $('#ref_document').html($html).trigger('change');
            } else {
                alert(json.error);
            }
        },
        error: function(xhr, ajaxOptions, thrownError) {
            console.log(xhr.responseText);
        }
    })

});

$(document).on('change','#ref_document', function() {
    var $id = $(this).val();
    if($id!='') {
        var obj = $ref_documents[$id];
        console.log(obj);
        $('#ref_document_identity').val(obj.document_identity);
        $('#source_table').val(obj.source_table);
        $('#source_table_id').val(obj.source_table_id);
        $('#payment_for').val(obj.payment_for);
        $('#transfer_type').val(obj.transfer_type);
        $('#bank_title').val(obj.bank_title);
        $('#amount').val(obj.amount);
        $('#bank_name').val(obj.bank_name);
        $('#cheque_date').val(obj.cheque_date);
        $('#cheque_no').val(obj.cheque_no);
    } else {
        $('#ref_document_identity').val('');
        $('#source_table').val('');
        $('#source_table_id').val('');
        $('#payment_for').val('');
        $('#transfer_type').val('');
        $('#bank_title').val('');
        $('#amount').val('');
        $('#bank_name').val('');
        $('#cheque_date').val('');
        $('#cheque_no').val('');
    }
});