/**
 * Created by Huzaifa on 9/18/15.
 */

$(document).on('ready', function() {
    $('#form').valid();
    calculateOtherAllowance();
    calculateOtherDeduction();
})

function submitDocument() {
    $('button.btnSave').attr('disabled','disabled');
    if($('#form').valid()) {
        var $data = $('#form').serialize();

        $.ajax({
            url: $URLSaveAjax,
            dataType: 'json',
            type: 'post',
            data: $data,
            mimeType:"multipart/form-data",
            beforeSend: function() {

            },
            complete: function() {
                $('.btnSave').removeAttr('disabled');
                $('#loader').remove();
            },
            success: function(json) {
                if(json.success)
                {
                    $('#primary_key').val(json.primary_key);
                    if(json.redirect) {
                        window.location = json.redirect;
                    }
                } else {
                    alert(json.error);
                }
            },
            error: function(xhr, ajaxOptions, thrownError) {
                console.log(xhr.responseText);
            }
        })
    } else {
        $('.btnSave').removeAttr('disabled');
    }
}

function calculateOtherAllowance() {
    var $total_allowance = 0;
    var $grossable_allowance =0;
    var $taxable_allowance=0;
    $('#tblPayrollAllowance tbody tr').each(function() {
        var $row_id = $(this).data('allowance_row');
        var $allowance_amount = $('#payroll_allowance_'+$row_id+'_allowance_amount').val();
        var $is_grossable = $('#payroll_allowance_'+$row_id+'_grossable').prop('checked');
        var $is_taxable = $('#payroll_allowance_'+$row_id+'_taxable').prop('checked');

        $total_allowance += parseFloat($allowance_amount);
        if($is_grossable==true) {
            $grossable_allowance += parseFloat($allowance_amount);
        }
        if($is_taxable==true) {
            $taxable_allowance += parseFloat($allowance_amount);
        }

    });

    $('#other_allowance').val($total_allowance);
    $('#grossable_allowance').val($grossable_allowance);
    $('#taxable_allowance').val($taxable_allowance);

    //calculatePayable();
    calcTaxable();
}

function calculateOtherDeduction() {
    var $total_deduction = 0;
    $('#tblPayrollDeduction tbody tr').each(function() {
        var $row_id = $(this).data('deduction_row');
        var $deduction_amount = $('#payroll_deduction_'+$row_id+'_deduction_amount').val();

        $total_deduction += parseFloat($deduction_amount);
    });

    $('#other_deduction').val($total_deduction);

    //calculatePayable();
    calcPayable();
}

function calculatePayable() {
    var $working_days = $('#working_days').val() | 0;
    var $basic_salary = $('#basic_salary').val() | 0;
    var $house_rent_allowance = $('#house_rent_allowance').val() | 0;
    var $other_allowance = $('#other_allowance').val() | 0;
    var $arrears = $('#arrears').val() | 0;
    var $grossable_allowance = $('#grossable_allowance').val() | 0;
    var $taxable_allowance = $('#taxable_allowance').val() | 0;
    var $tax_deduction = $('#tax_deduction').val() | 0;
    var $other_deduction = $('#other_deduction').val() | 0;
    var $manual_addition = $('#manual_addition').val() | 0;
    var $manual_deduction = $('#manual_deduction').val() | 0;
    var $overtime = $('#overtime').val() | 0;
    var $total_present = $('#total_present').val() | 0;

    var $gross_salary = parseFloat($basic_salary)+parseFloat($grossable_allowance)+parseFloat($arrears)+parseFloat($manual_addition)+parseFloat($overtime);
    var $taxable_salary = parseFloat($basic_salary)+parseFloat($house_rent_allowance)+parseFloat($taxable_allowance)+parseFloat($arrears)+parseFloat($manual_addition)+parseFloat($overtime);
   // var $net_salary = (parseFloat($gross_salary)-parseFloat($tax_deduction)-parseFloat($other_deduction)-parseFloat($manual_deduction)).toFixed(2);
    var $net_salary = (parseFloat($gross_salary)-parseFloat($other_deduction)-parseFloat($manual_deduction)).toFixed(2);
    var $total_absent = (parseInt($working_days)-parseInt($total_present)).toFixed(0);
    //var $attendance_deduction = (parseFloat($gross_salary)/30 *parseInt($total_absent)).toFixed(0);
    var $attendance_deduction = (parseFloat($gross_salary)/(parseFloat($working_days)) *parseInt($total_absent)).toFixed(0);
    var $payable_salary = (parseFloat($net_salary)-parseFloat($attendance_deduction)-parseFloat($tax_deduction)).toFixed(2);

    //console.log($working_days, $total_absent, $attendance_deduction,$net_salary, $payable_salary);
    $('#gross_salary').val($gross_salary);
    $('#taxable_salary').val($taxable_salary);
    $('#net_salary').val($net_salary);
    $('#payable_salary').val($payable_salary);
    $('#total_absent').val($total_absent);
    $('#attendance_deduction').val($attendance_deduction);

}

function calcTaxable() {
    var $basic_salary = $('#basic_salary').val();
    var $house_rent_allowance = $('#house_rent_allowance').val();
    var $grossable_allowance = $('#grossable_allowance').val();
    var $taxable_allowance = $('#taxable_allowance').val();
    var $arrears = $('#arrears').val();
    var $manual_addition = $('#manual_addition').val();
    var $overtime = $('#overtime').val();

    var $gross_salary = parseFloat($basic_salary)+parseFloat($grossable_allowance)+parseFloat($arrears)+parseFloat($manual_addition)+parseFloat($overtime);
    var $taxable_salary = parseFloat($basic_salary)+parseFloat($house_rent_allowance)+parseFloat($taxable_allowance)+parseFloat($arrears)+parseFloat($manual_addition)+parseFloat($overtime);
    $('#gross_salary').val($gross_salary);
    $('#taxable_salary').val($taxable_salary);

    var $data = {
        'employee_registration_id' : $('#employee_registration_id').val(),
        'employee_id' : $('#employee_id').val(),
        'document_date' : $('#document_date').val(),
        'taxable' : $('#taxable').val(),
        'taxable_salary' : $taxable_salary,
    };
    $.ajax({
        url: $URLGetTaxAmount,
        dataType: 'json',
        type: 'post',
        data: $data,
        mimeType:"multipart/form-data",
        beforeSend: function() {
            //$('#tblPayroll tbody').html('');
            //$('#btnCalculate').html('<i class="fa fa-refresh fa-spin"></i>&nbsp;Calculate');
        },
        complete: function() {
            //$('#btnCalculate').html('Calculate');
        },
        success: function(json) {
            if(json.success)
            {
                $('#tax_deduction').val(json.tax_deduction);
                calcPayable();
            } else {
                alert(json.error);
            }
        },
        error: function(xhr, ajaxOptions, thrownError) {
            console.log(xhr.responseText);
        }
    });

}

function calcPayable() {
    var $gross_salary = $('#gross_salary').val();
    var $taxable_salary = $('#taxable_salary').val();
    var $other_deduction = $('#other_deduction').val();
    var $manual_deduction = $('#manual_deduction').val();

    var $net_salary = parseFloat($gross_salary)-parseFloat($other_deduction)-parseFloat($manual_deduction);
    var $tax_deduction = $('#tax_deduction').val();

    var $working_days = $('#working_days').val();
    var $total_absent = $('#total_absent').val();
    var $total_present = $working_days - $total_absent;
    var $daily_deduction = $('#daily_deduction').val();

    var $attendance_deduction = ($daily_deduction*$total_absent).toFixed(0);
    if($attendance_deduction > ($net_salary - $tax_deduction)) {
        $attendance_deduction = ($net_salary - $tax_deduction);
    }

    var $payable_salary = (parseFloat($net_salary)-parseFloat($attendance_deduction)-parseFloat($tax_deduction)).toFixed(0);

    var $data = {
        'gross_salary' : $gross_salary,
        'taxable_salary' : $taxable_salary,
        'other_deduction' : $other_deduction,
        'manual_deduction' : $manual_deduction,
        'net_salary' : $net_salary,
        'working_days' : $working_days,
        'total_absent' : $total_absent,
        'total_present' : $total_present,
        'daily_deduction' : $daily_deduction,
        'attendance_deduction' : $attendance_deduction,
        'payable_salary' : $payable_salary,
    };

    $('#gross_salary').val($gross_salary);
    $('#taxable_salary').val($taxable_salary);
    $('#net_salary').val($net_salary);
    $('#attendance_deduction').val($attendance_deduction);
    $('#payable_salary').val($payable_salary);
    $('#total_present').val($total_present);

}
