/**
 * Created by Huzaifa on 9/18/15.
 */

$(document).on('ready', function() {
    $('#btnSearch').on('click',function() {
        // alert('hello');
        var $department_id =  $('#department_id').val();
        var $total_increment_percent =  $('#total_increment_percent').val();
        var $total_increment_amount =  $('#total_increment_amount').val();
        var $wef_date =  $('#wef_date').val();
        var $employee_registration_id =  $('#employee_registration_id').val();
        if($('#is_selected').is(":checked"))
        {
            var $is_selected = 1;
        } else {
            var $is_selected = 0;
        }

        if(($total_increment_amount != '' && $total_increment_percent != '') || ($total_increment_amount == '' && $total_increment_percent == ''))
        {
            alert('Enter Either Increment % or Increment Amount');
        } else if($wef_date=='') {
            alert('W.E.F Date is required');
        }
        else
        {
            $.ajax({
                url: $URLGetData,
                dataType: 'json',
                type: 'post',
                data: 'department_id='+$department_id+'&total_increment_percent='+$total_increment_percent+'&total_increment_amount='+$total_increment_amount+'&is_selected='+$is_selected+'&wef_date='+$wef_date+'&employee_registration_id='+$employee_registration_id,
                mimeType:"multipart/form-data",
                beforeSend: function() {
                    $('#btnSearch').find('i').removeClass('fa-floppy-o').addClass('fa-refresh fa-spin');
                },
                complete: function() {
                    $('#btnSearch').find('i').removeClass('fa-refresh fa-spin').addClass('fa-floppy-o');
                },
                success: function(json) {
                    if(json.success)
                    {
                        $("#tblSalaryIncrement tbody").html('');
                        $("#tblSalaryIncrement tbody").append(json.html);
                        console.log(json);
                    } else {
                        alert(json.error);
                    }
                },
                error: function(xhr, ajaxOptions, thrownError) {
                    console.log(xhr.responseText);
                }
            });
        }
    });

    $('#is_selected').on('click',function() {
        // alert('hello');
        if($('#is_selected').is(":checked"))
        {
            var $size = $('#tblSalaryIncrement tr').length;
            for($i = 0; $i < ($size-1); $i++)
            {
                $('#is_select_'+$i).prop('checked', true);
            }
        }
        else
        {
            var $size = $('#tblSalaryIncrement tr').length;
            for($i = 0; $i < ($size-1); $i++)
            {
                $('#is_select_'+$i).prop('checked', false);
            }
        }
    })
});

function getHistory(e,$key)
{
    e.preventDefault();
    var $employee_registration_id = $('#employee_registration_id_'+$key).val();
    $.ajax({
        url: $URLGetSalaryHistory,
        dataType: 'json',
        type: 'post',
        data: 'employee_registration_id='+$employee_registration_id,
        mimeType:"multipart/form-data",
        beforeSend: function() {
            $('#tblSalaryIncrement').before('<i id="loader" class="fa fa-refresh fa-spin"></i>');
        },
        complete: function() {
            $('#loader').remove();
        },
        success: function(json) {
            if(json.success)
            {
                console.log(json);
                $("#modal-body").html('');
                $("#modal-body").append(json.html);
                $('#myModal').modal('show');
            } else {
                alert(json.error);
            }
        },
        error: function(xhr, ajaxOptions, thrownError) {
            console.log(xhr.responseText);
        }
    });
}

function calculateAmount($obj)
{
    var id = $($obj).parent().data('id');
    // alert(id);
    $increment_percent = $('#increment_percent_'+id).val();
    $basic_salary  = $('#basic_salary_'+id).val();
    $amount = ($basic_salary/100) * $increment_percent;
    $amount = Math.round($amount);
    $('#increment_amount_'+id).val($amount);
    var $new_salary = parseFloat($amount) + parseFloat($basic_salary);
    $('#new_salary_'+id).val($new_salary);

    getArrears(id);
}

function calculateNewSalary($obj)
{
    var id = $($obj).parent().data('id');
    $new_salary = $('#new_salary_'+id).val();
    $basic_salary  = $('#basic_salary_'+id).val();
    $amount = parseFloat($new_salary) - parseFloat($basic_salary);
    $amount = Math.round($amount);
    $('#increment_amount_'+id).val($amount);
    $('#increment_amount_'+id).trigger('change');
}

function calculatePercent($obj)
{
    var id = $($obj).parent().data('id');
    $amount = $('#increment_amount_'+id).val();
    $amount = Math.round($amount);
    $basic_salary  = $('#basic_salary_'+id).val();
    $percent = ($amount *100)/$basic_salary;
    $percent = Math.round($percent);
    $('#increment_percent_'+id).val($percent);
    var $new_salary = parseFloat($amount) + parseFloat($basic_salary);
    $('#new_salary_'+id).val($new_salary);

    getArrears(id);
}

function getArrears(id) {
    var $wef_date = $('#wef_date').val();
    var $employee_registration_id = $('#employee_registration_id_'+id).val();
    var $new_basic = $('#new_salary_'+id).val();

    var $data = {
        row_id: id,
        wef_date: $wef_date,
        employee_registration_id: $employee_registration_id,
        new_basic: $new_basic
    };
    $.ajax({
        url: $URLGetArrears,
        dataType: 'json',
        type: 'post',
        data: $data,
        mimeType:"multipart/form-data",
        beforeSend: function() {
            $('#tblSalaryIncrement').before('<i id="loader" class="fa fa-refresh fa-spin"></i>');
        },
        complete: function() {
            $('#loader').remove();
        },
        success: function(json) {
            if(json.success)
            {
                $('#arrears_'+id).val(json.arrears);
            } else {
                alert(json.error);
            }
        },
        error: function(xhr, ajaxOptions, thrownError) {
            console.log(xhr.responseText);
        }
    });
}

function save() {
    // $('#form').attr('action', $UrlSave).submit();
    var $size = $('#tblSalaryIncrement tr').length;
    var $count = 0;
    for($i = 0; $i < ($size-1); $i++)
    {
        if($('#is_select_'+$i).is(":checked")){
            $count++;
        }
    }
    if($count > 0) {
        $('#form').submit();
    } else {
        alert('Please select at least one employee');
    }
}

function finalize() {
    $('#form').attr('action', $UrlFinalize).submit();
    $('#form').submit();
}

