/**
 * Created by Huzaifa on 9/18/15.
 */

var $families = {};
var $emp_allowance = {};

$(document).on('change','#registration_code',function() {
    var $code = $(this).val();
    // console.log($code);
    if($employees[$code]) {
        var $data = $employees[$code];
        $families = $employees[$code]['families'];
        $('#employee_code').val($data['employee_code']);
        $('#employee_id').val($data['employee_id']);
        $('#employee_registration_id').val($data['employee_registration_id']).trigger('change');
    } else {
        $families = {};
        $('#employee_code').val('');
        $('#employee_id').val('');
        $('#employee_registration_id').val('').trigger('change');
        alert("Invalid Employee Code");
    }
});

$(document).on('change','#employee_registration_id',function() {
    var $data = $('#employee_registration_id option:selected').data();
    if($data) {
        $('#registration_code').val($data['registration_code']);
        $('#employee_code').val($data['employee_code']);
        $('#employee_id').val($data['employee_id']);
        getAllowanceType();
    } else {
        $families = [];
        $('#registration_code').val('');
        $('#employee_code').val('');
        $('#employee_id').val('');
        alert("Invalid Employee Code");
    }
});

function getAllowanceType() {
    var $employee_registration_id = $('#employee_registration_id option:selected').val();
    $.ajax({
        url: $URLGetAllowanceType,
        dataType: 'json',
        type: 'post',
        data: '&employee_registration_id='+$employee_registration_id,
        mimeType:"multipart/form-data",
        beforeSend: function() {
            $('#employee_registration_id').before('<i id="loader" class="fa fa-spinner fa-spin"></i>')
        },
        complete: function() {
            $('#loader').remove();
        },
        success: function(json) {
            if(json.success)
            {
                $('#special_allowance_type_id').html(json.html);

                // console.log(json);
            } else {
                alert(json.error);
            }
        },
        error: function(xhr, ajaxOptions, thrownError) {
            console.log(xhr.responseText);
        }
    })
}

$(document).on('change','#special_allowance_type_id', function() {
    var $special_allowance_type_id = $(this).val();
    var $employee_registration_id = $('#employee_registration_id').val();
    $('#tblSpecialAllowance tbody').html('');
    if($special_allowance_type_id==2) {
        $('#divPeriod').show('slow');
    } else {
        $('#medical_from').val('');
        $('#medical_to').val('');
        $('#divPeriod').hide('slow');
    }

    var $data = {
        'special_allowance_type_id': $special_allowance_type_id,
        'employee_registration_id': $employee_registration_id
    };

    $.ajax({
        url: $URLGetAllowanceCategory,
        dataType: 'json',
        type: 'post',
        data: $data,
        mimeType:"multipart/form-data",
        beforeSend: function() {
            $('#special_allowance_type_id').before('<span id="loader" class="pull-right"><i class="fa fa-spin fa-refresh"></i></span>')
        },
        complete: function() {
            $('#loader').remove();
        },
        success: function(json) {
            if(json.success)
            {
                $categories = json.categories;
                $('#tblPolicyScholarship tbody').html(json.html_policy);
                $policies = json.policies;
                $families = json.families;
            } else {
                alert(json.error);
            }
        },
        error: function(xhr, ajaxOptions, thrownError) {
            console.log(xhr.responseText);
        }
    });

});

$(document).on('click', '.btnAddAllowance', function() {
    var $allowance_type_id = $('#special_allowance_type_id option:selected').val();
    if($allowance_type_id !=='') {
        if (Object.keys($families).length > 0) {
            $html = '<tr id="grid_row_id_'+$grid_row_allowance+'" data-row_id="'+$grid_row_allowance+'">';
            $html += '<td style="width: 15px;"><a class="btnRemoveAllowance btn btn-xs btn-danger" title="Remove" href="javascript:void(0);"><i class="fa fa-minus"></i></a></td>';
            $html += '<td>';
            $html += '<input type="hidden" class="form-control " id="detail_'+$grid_row_allowance+'_allowance_for" name="details['+$grid_row_allowance+'][allowance_for]" value="" />';
            $html += '<input type="hidden" class="form-control " id="detail_'+$grid_row_allowance+'_school_id" name="details['+$grid_row_allowance+'][school_id]" value="" />';
            $html += '<input type="hidden" class="form-control " id="detail_'+$grid_row_allowance+'_class_id" name="details['+$grid_row_allowance+'][class_id]" value="" />';
            $html += '<input type="hidden" class="form-control " id="detail_'+$grid_row_allowance+'_period_start_date" name="details['+$grid_row_allowance+'][period_end_date]" value="" />';
            $html += '<input type="hidden" class="form-control " id="detail_'+$grid_row_allowance+'_period_end_date" name="details['+$grid_row_allowance+'][period_end_date]" value="" />';
            $html += '<select required onchange="updateRelation('+$grid_row_allowance+')" class="form-control" id="detail_'+$grid_row_allowance+'_employee_family_id" name="details['+$grid_row_allowance+'][employee_family_id]" >';
            $html += '<option>&nbsp;</option>';
            $.each($families,function($i,$family) {
                $html += '<option data-relation="'+$family['relation']+'" data-school_id="'+$family['school_id']+'" data-class_id="'+$family['class_id']+'" data-period_start_date="'+$family['period_start_date']+'" data-period_end_date="'+$family['period_end_date']+'" data-school="'+$family['school_name']+' - '+$family['class_name']+'" value="'+$family['employee_family_id']+'">'+$family['full_name']+'</option>';
            });
            $html += '</select>';
            $html += '<label class="error" for="detail_'+$grid_row_allowance+'_employee_family_id"></label>';
            $html += '</td>';
            $html += '<td>';
            $html += '<select required onchange="calculatePolicyAmount('+$grid_row_allowance+');" class="form-control" id="detail_'+$grid_row_allowance+'_special_allowance_category_id" name="details['+$grid_row_allowance+'][special_allowance_category_id]" >';
            $.each($categories,function($i,$category) {
                $html += '<option value="'+$category['special_allowance_category_id']+'">'+$category['special_allowance_category']+'</option>';
            });
            $html += '</select>';
            $html += '<label class="error" for="detail_'+$grid_row_allowance+'_special_allowance_category_id"></label>';
            $html += '</td>';
            $html += '<td><input required onchange="calculatePolicyAmount('+$grid_row_allowance+');" type="text" class="form-control fPDecimal" id="detail_'+$grid_row_allowance+'_amount" name="details['+$grid_row_allowance+'][amount]" value="" /></td>';
            $html += '<td><input type="text" class="form-control" maxlength="60" id="detail_'+$grid_row_allowance+'_remarks" name="details['+$grid_row_allowance+'][remarks]" value="" /></td>';
            $html += '<td><input type="text" class="form-control dtpDate" id="detail_'+$grid_row_allowance+'_receipt_date" name="details['+$grid_row_allowance+'][receipt_date]" value="" /></td>';
            $html += '<td><input type="text" class="form-control" maxlength="21" id="detail_'+$grid_row_allowance+'_receipt_no" name="details['+$grid_row_allowance+'][receipt_no]" value="" /></td>';
            $html += '<td>';
            $html += '<input type="text" class="form-control" maxlength="21" id="detail_'+$grid_row_allowance+'_policy_amount" name="details['+$grid_row_allowance+'][policy_amount]" value="" readonly />';
            $html += '<input type="hidden" id="detail_'+$grid_row_allowance+'_policy_on" name="details['+$grid_row_allowance+'][policy_on]" value="" />';
            $html += '<input type="hidden" id="detail_'+$grid_row_allowance+'_policy_value" name="details['+$grid_row_allowance+'][policy_value]" value="" />';
            $html += '</td>';
            $html += '<td>';
            $html += '<input onchange="calculateTotal();" type="text" class="form-control" maxlength="21" id="detail_'+$grid_row_allowance+'_approved_amount" name="details['+$grid_row_allowance+'][approved_amount]" value="" />';
            $html += '</td>';
            $html += '</tr>';

            $('#tblSpecialAllowance tbody').append($html);
            $('#detail_'+$grid_row_allowance+'_employee_family_id').trigger('change');

            $grid_row_allowance++;
            setFieldFormat();
        } else {
            alert('Family Member not defined.');
        }
    }

});

function updateRelation($allowance_id) {
    var $data = $('#detail_'+$allowance_id+'_employee_family_id option:selected').data();
    // console.log($data);
    $('#detail_'+$allowance_id+'_allowance_for').val($data['relation']);
    $('#detail_'+$allowance_id+'_school_id').val($data['school_id']);
    $('#detail_'+$allowance_id+'_class_id').val($data['class_id']);
    $('#detail_'+$allowance_id+'_period_start_date').val($data['period_start_date']);
    $('#detail_'+$allowance_id+'_period_end_date').val($data['period_end_date']);
}

$(document).on('click','.btnRemoveAllowance',function() {
    var $row_id = $(this).parent().parent().data('row_id');
    console.log($row_id);
    $('#grid_row_id_'+$row_id).remove();
});

function calculatePolicyAmount($row_id) {
    var $relation = $('#detail_'+$row_id+'_allowance_for').val();
    var $category_id = $('#detail_'+$row_id+'_special_allowance_category_id').val();
    var $amount = $('#detail_'+$row_id+'_amount').val() | 0;
    if(typeof $policies[$relation] !== 'undefined') {
        if (typeof $policies[$relation][$category_id] !== 'undefined') {
            var $policy_on = $policies[$relation][$category_id]['allowance_on'];
            var $policy_value = $policies[$relation][$category_id]['allowance_value'];
        } else if (typeof $policies[$relation][0] !== 'undefined') {
            var $policy_on = $policies[$relation][0]['allowance_on'];
            var $policy_value = $policies[$relation][0]['allowance_value'];
        } else {
            var $policy_on = '';
            var $policy_value = 0;
        }
    } else {
        var $policy_on = '';
        var $policy_value = 0;
    }

    if($policy_on=='Fixed') {
        var $policy_amount = $amount;
    } else {
        var $policy_amount = (parseFloat($amount) * parseFloat($policy_value) / 100).toFixed(2);
    }

    var $approved_amount = $policy_amount;

    $('#detail_'+$row_id+'_policy_amount').val($policy_amount);
    $('#detail_'+$row_id+'_approved_amount').val($approved_amount);

    calculateTotal();
}

function calculateTotal() {
    var $total_amount = 0;
    var $total_approved_amount = 0;
    $('#tblSpecialAllowance tbody tr').each(function(){
        var $row_id = $(this).data('row_id');
        var $amount = $('#detail_'+$row_id+'_amount').val() | 0;
        var $approved_amount = $('#detail_'+$row_id+'_approved_amount').val() | 0;

        $total_amount += parseFloat($amount);
        $total_approved_amount += parseFloat($approved_amount);
    });

    $('#total_amount').val($total_amount);
    $('#approved_amount').val($total_approved_amount);
}

$(document).on('change','#approved_status',function() {
    var $status = $(this).val();
    // alert($status);
    if($status == 'Approved') {
            var $approved_amount = $('#approved_amount').val();
            $html = '<tr data-row_id="'+$grid_row_installments+'">';
            $html += '<td><input required type="text" class="form-control dtpDate" name="installments['+$grid_row_installments+'][installment_date]" id="installment_'+$grid_row_installments+'_installment_date" value="" /></td>';
            $html += '<td><input required onchange="calculateTotalInstallments(this);" class="form-control" type="text" name="installments['+$grid_row_installments+'][installment_amount]" id="installment_'+$grid_row_installments+'_installment_amount" value="'+$approved_amount+'" /></td>';
            $html += '</tr>';
            $('#tblInstallment tbody').html($html);
            $grid_row_installments++;
            $('#installmentDiv').show();    
    } else {
        $('#installmentDiv tbody').html('');
        $('#installmentDiv').hide();
    }
});

function addRowInstallment() {
    $html = '<tr data-row_id="'+$grid_row_installments+'">';
    $html += '<td><input required type="text" class="form-control dtpDate" name="installments['+$grid_row_installments+'][installment_date]" id="installment_'+$grid_row_installments+'_installment_date" value="" /></td>';
    $html += '<td><input required onchange="calculateTotalInstallments(this);" class="form-control" type="text" name="installments['+$grid_row_installments+'][installment_amount]" id="installment_'+$grid_row_installments+'_installment_amount" value="" /></td>';
    $html += '</tr>';
    $('#tblInstallment tr:last').after($html);
    $grid_row_installments++;
}

function calculateTotalInstallments($obj) {
    // alert($grid_row_installments);
    var $row_id = $($obj).parent().parent().data('row_id');
    var $amount = $('#installment_amount' + $row_id).val();
    // alert($row_id);
    $total = 0;
    for($i = 0; $i < $grid_row_installments; $i++)
    {
        $total += parseFloat($('#installment_amount' + $i).val());
    }
    $approved_amount = parseFloat($('#approved_amount').val());
    if($total < $approved_amount)
    {
        alert('Installment amount should be equal to approved amount');
    }
    if($total > $approved_amount)
    {
     alert('Installment amount can\'t be greater than approved amount');
    }
    // alert($total);
}

function submitDocument() {
    $('button.btnSave').attr('disabled','disabled');
    if($('#form').valid()) {
        var $is_valid = true;
        var $approved_status = $('#approved_status').val();
        if($approved_status=='Approved') {
            var $approved_amount = $('#approved_amount').val();
            var $total_installment_amount = 0.00;
            $('#tblInstallment').find('tbody').find('tr').each(function() {
                var $row_id = $(this).data('row_id');
                var $amount = $('#installment_'+$row_id+'_installment_amount').val();
                $total_installment_amount = parseFloat($total_installment_amount) + parseFloat($amount);
				console.log($row_id, $amount, $total_installment_amount);
            });

            $approved_amount = parseFloat($approved_amount).toFixed(2);
            $total_installment_amount = parseFloat($total_installment_amount).toFixed(2);
            console.log($approved_amount, $total_installment_amount);
            if($approved_amount != $total_installment_amount) {
                $is_valid = false;
                alert('Total Installment must equals Approved Amount.')
            }
        }

        if($is_valid) {
            $('#form').submit();
        }
    } else {
        $('.btnSave').removeAttr('disabled');
    }
}

function getPolicy() {
    var $data = {
        'employee_registration_id': $('#employee_registration_id').val()
    };

    $.ajax({
        url: $URLGetPolicy,
        dataType: 'json',
        type: 'post',
        data: $data,
        mimeType:"multipart/form-data",
        beforeSend: function() {
            $('#tblPolicy').before('<span id="loader" class="pull-right"><i class="fa fa-spin fa-refresh"></i></span>')
        },
        complete: function() {
            $('#loader').remove();
        },
        success: function(json) {
            if(json.success)
            {
               
                $('#tblPolicyScholarship tbody').html(json.html);
            } else {
                alert(json.error);
            }
        },
        error: function(xhr, ajaxOptions, thrownError) {
            console.log(xhr.responseText);
        }
    });
}

function validate_total_amount(){
    var $total_amount = parseFloat($('#total_amount').val());
    var $approved_amount = parseFloat($('#approved_amount').val());

    if($approved_amount > $total_amount){
        alert('Approved amount shall not be greater than total amount');
    }
}


function calculateTotalApprovedAmount() {
    // alert('changed');
    var $total_amount = 0;
    $('#tblSpecialAllowance tbody tr').each(function(){
        var $row_id = $(this).data('row_id');
        var $amount = $('#detail_'+$row_id+'_approved_amount').val() | 0;

        $total_amount += parseFloat($amount);
    });
    /*console.log($total_amount);*/

    $('#approved_amount').val($total_amount);
    validate_total_amount();
};

$(document).on('ready', function() {
    $('#form').valid();
    // $('#approved_status').trigger('change');
    //var $code = $('#registration_code').val();
    //$families = $employees[$code]['families'];
    var $special_allowance_type_id = $('#special_allowance_type_id').val();
    if($special_allowance_type_id!=2) {
        $('#divPeriod').hide();
    }
});
