/**
 * Created by Huzaifa on 9/18/15.
 */

$(document).on('ready', function() {
    $('#form').valid();
});

$(document).on('click','#btnSearch', function() {
    var $valid = true;
    var $document_date = $('#document_date').val();
    var $enayat_event_id = $('#enayat_event_id').val();

    if($document_date=='' || $enayat_event_id == '') {
        alert('Select Date and Event');
        $valid = false;
    }

    if($valid) {
        var $document_date = $('#document_date').val();
        var $enayat_event_id = $('#enayat_event_id').val();
        var $department_id = $('#department_id').val();
        var $employee_registration_id = $('#employee_registration_id').val();

        $data = {
            document_date: $document_date,
            enayat_event_id: $enayat_event_id,
            department_id: $department_id,
            employee_registration_id: $employee_registration_id
        };
        $.ajax({
            url: $URLGetEmployees,
            dataType: 'json',
            type: 'post',
            data: $data,
            mimeType:"multipart/form-data",
            beforeSend: function() {
                //$('#tblSpecialEnayat tbody').html('');
                $('#btnSearch').find('i').removeClass('fa-plus').addClass('fa-refresh fa-spin');
            },
            complete: function() {
                $('#btnSearch').find('i').removeClass('fa-refresh fa-spin').addClass('fa-plus');
                $('#department_id').val(null).trigger('change');
                $('#employee_registration_id').val('').trigger('change');
            },
            success: function(json) {
                if(json.success)
                {
                    fillDetails(json.employees);
                } else {
                    alert(json.error);
                }
            },
            error: function(xhr, ajaxOptions, thrownError) {
                console.log(xhr.responseText);
            }
        });
    }
});

function fillDetails($employees) {
    $.each($employees, function(index,$employee) {
        var exists = $('tr[data-registration_id="'+$employee.employee_registration_id+'"]').length;
        if(!exists) {
            var $amount = $('#master_amount').val();
            $html = '';
            $html += '<tr id="grid_row_'+$grid_row+'" data-registration_id="'+$employee['employee_registration_id']+'">';
            $html += '<td>';
            $html += '<button onclick="removeRow('+$grid_row+');" type="button" class="btn btn-xs btn-danger"><i class="fa fa-times"></i></button>';
            $html += '</td>';
            $html += '<td>';
            $html += '<input type="hidden" id="employee_'+$grid_row+'_employee_registration_id" name="employees['+$grid_row+'][employee_registration_id]" value="'+$employee['employee_registration_id']+'" />';
            $html += '<input type="hidden" id="employee_'+$grid_row+'_employee_id" name="employees['+$grid_row+'][employee_id]" value="'+$employee['employee_id']+'" />';
            $html += '<input type="text" class="form-control" id="employee_'+$grid_row+'_employee_name" name="employees['+$grid_row+'][employee_name]" value="'+$employee['registration_code']+' - '+$employee['employee_name']+'" readonly/>';
            $html += '</td>';
            $html += '<td>';
            $html += '<input onchange="calcTotal();" type="text" class="form-control text-right amount" id="employee_'+$grid_row+'_amount" name="employees['+$grid_row+'][amount]" value="'+$amount+'" />';
            $html += '</td>';

            $('#tblSpecialEnayat').find('tbody').append($html);
            $grid_row++;
        }
    });

    calcTotal();
}

function removeRow($row_id) {
    $('#tblSpecialEnayat').find('#grid_row_'+$row_id).remove();
    calcTotal();
}

function calcTotal() {
    var $total_employee=0;
    var $total_amount=0;
    $('#tblSpecialEnayat .amount').each(function() {
        var $amount = parseFloat($(this).val()) | 0;

        $total_amount += $amount;
        $total_employee++;
    });

    $('#total_amount').val($total_amount);
    $('#total_employee').val($total_employee);
}