/**
 * Created by Huzaifa on 9/18/15.
 */

var $payrolls;

$(document).on('ready', function() {
    $('#form').valid();
})

function submitDocument() {
    $('button.btnSave').attr('disabled','disabled');
    if($('#form').valid()) {
        var $data = $('#form').serialize();

        $.ajax({
            url: $URLSaveAjax,
            dataType: 'json',
            type: 'post',
            data: $data,
            mimeType:"multipart/form-data",
            beforeSend: function() {

            },
            complete: function() {
                $('.btnSave').removeAttr('disabled');
                $('#loader').remove();
            },
            success: function(json) {
                if(json.success)
                {
                    $('#primary_key').val(json.primary_key);
                    if(json.redirect) {
                        window.location = json.redirect;
                    }
                } else {
                    alert(json.error);
                }
            },
            error: function(xhr, ajaxOptions, thrownError) {
                console.log(xhr.responseText);
            }
        })
    } else {
        $('.btnSave').removeAttr('disabled');
    }
}

$(document).on('click','#btnCalculate', function() {
    if($('#form').valid()) {
        var $data = $('#form').serialize();

        $.ajax({
            url: $URLGetTaxData,
            dataType: 'json',
            type: 'post',
            data: $data,
            mimeType:"multipart/form-data",
            beforeSend: function() {
                $('#divPayrollTax').html('');
                $('#btnCalculate').html('<i class="fa fa-refresh fa-spin"></i>&nbsp;Calculate');
            },
            complete: function() {
                $('#btnCalculate').html('Calculate');
            },
            success: function(json) {
                if(json.success)
                {
//                    console.log(json);
                    $('#divPayrollTax').html(json.html);
                    setFieldFormat();

                    $('#divPayrollTax table').DataTable({
                        paging: false
                    });
                } else {
                    alert(json.error);
                }
            },
            error: function(xhr, ajaxOptions, thrownError) {
                console.log(xhr.responseText);
            }
        })
    }
});
