/**
 * Created by Huzaifa on 9/18/15.
 */
$(document).on('change','#company_id', function() {
    var $company_id = $(this).val();

    $.ajax({
        url: $URLGetDepartments,
        dataType: 'json',
        type: 'post',
        data: 'company_id='+$company_id,
        beforeSend: function() {
            $('#department_id').before('<i id="loader" class="fa fa-spin fa-refresh"></i>');
        },
        complete: function() {
            $('#loader').remove();
        },
        success: function(json) {
            if(json.success)
            {
                $('#department_id').html(json.departments);
            } else {
                alert(json.error);
            }
        },
        error: function(xhr, ajaxOptions, thrownError) {
            console.log(xhr.responseText);
        }
    });
});

function fnAddToList($obj) {
    $data = $($obj).parent().data();
    fnAddColumn($data);
}

function fnAddColumn($data) {
    $_column_name = $data.column_name;
    $_display_name = $data.display_name;
    $_column_ratio = $data.column_ratio;

    $html =  '';
    $html += '<a class="list-group-item" data-column_name="'+$data.column_name+'" data-display_name="'+$data.display_name+'" data-column_ratio="'+$data.column_ratio+'" href="javascript:void(0);">';
    $html += '  <button type="button" onclick="$(this).parent().remove();" class="btn btn-danger btn-xs pull-right">';
    $html += '    <i class="fa fa-remove"></i>';
    $html += '  </button>';
    $html += '  <button type="button" onclick="fnMoveUp(this);" class="btn btn-primary btn-xs pull-right">';
    $html += '    <i class="fa fa-arrow-up"></i></button>';
    $html += '  <button type="button" onclick="fnMoveDown(this);" class="btn btn-primary btn-xs pull-right">';
    $html += '    <i class="fa fa-arrow-down"></i>';
    $html += '  </button>';
    $html += '  <p class="list-group-item-text">'+$data.display_name+'</p>';
    $html += '</a>';
    $('#_display_column .list-group').append($html);
}

function fnMoveDown($obj) {
    var $currObj = $($obj).parent();
    var $nextObj = $($currObj).next('.list-group-item');
    if($nextObj.length > 0) {
        $($nextObj).after($currObj);
    }
}

function fnMoveUp($obj) {
    var $currObj = $($obj).parent();
    var $prevObj = $($currObj).prev('.list-group-item');
    if($prevObj.length > 0) {
        $($prevObj).before($currObj);
    }
}


$(document).on('click','#btnPDF', function() {
    if($('#_display_column .list-group a').length <= 0 ) {
        alert('Please select any column');
        return;
    }

    $display_columns = [];
    $('#_display_column .list-group a').each(function() {
        var $objColumn = {
            'column_ratio':$(this).data('column_ratio'),
            'column_name':$(this).data('column_name'),
            'display_name':$(this).data('display_name')
        };

        $display_columns.push($objColumn);
    });

    // alert($display_columns);

    $data = {
        'page_size': $('#page_size').val(),
        'page_orientation': $('#page_orientation').val(),
        'company_id': $('#company_id').val(),
        'department_id': $('#department_id').val(),
        'from_joining_date': $('#from_joining_date').val(),
        'to_joining_date': $('#to_joining_date').val(),
        'from_leaving_date': $('#from_leaving_date').val(),
        'to_leaving_date': $('#to_leaving_date').val(),
        'status_id': $('#status_id').val(),
        'eobi_status': $('#eobi_status').val(),
        'display_columns' : $display_columns
    };

    // console.log($data);

    var $parameter = $.param($data);
    window.open($URLPrintReport + '&' + $parameter,'_blank');
});

$(document).on('click','#btnExcel', function() {
    if($('#_display_column .list-group a').length <= 0 ) {
        alert('Please select any column');
        return;
    }

    $display_columns = [];
    $('#_display_column .list-group a').each(function() {
        var $objColumn = {
            'column_ratio':$(this).data('column_ratio'),
            'column_name':$(this).data('column_name'),
            'display_name':$(this).data('display_name')
        };

        $display_columns.push($objColumn);
    });

    // alert($display_columns);

    $data = {
        'company_id': $('#company_id').val(),
        'department_id': $('#department_id').val(),
        'from_joining_date': $('#from_joining_date').val(),
        'to_joining_date': $('#to_joining_date').val(),
        'from_leaving_date': $('#from_leaving_date').val(),
        'to_leaving_date': $('#to_leaving_date').val(),
        'status_id': $('#status_id').val(),
        'eobi_status': $('#eobi_status').val(),
        'display_columns' : $display_columns
    };

    // console.log($data);

    var $parameter = $.param($data);
    window.open($URLPrintExcel + '&' + $parameter,'_blank');
});

