/**
 * Created by Huzaifa on 9/18/15.
 */

$(document).on('click','#btnFilter', function() {
    var $data = $('#form').serialize();

    $.ajax({
        url: $URLGetReport,
        dataType: 'json',
        type: 'post',
        data: $data,
        mimeType:"multipart/form-data",
        beforeSend: function() {
            $('#tblReport tbody').html('');
        },
        complete: function() {
            $('#loader').remove();
        },
        success: function(json) {
            if(json.success)
            {
                //fillTable(json.employees);
                $('#tblReport').find('tbody').html(json.html);
            } else {
                alert(json.error);
            }
        },
        error: function(xhr, ajaxOptions, thrownError) {
            console.log(xhr.responseText);
        }
    });
});

function fillTable($employees) {
    $.each($employees, function(i, employee) {
        var $tr = $('<tr>').append(
            $('<td>').text(i),
            $('<td>').text(employee.registration_code),
            $('<td>').text(employee.employee_name),
            $('<td>').text(employee.paid_salary),
            $('<td>').text(employee.paid_allowance),
            $('<td>').text(employee.current_salary),
            $('<td>').text(employee.remaining_salary),
            $('<td>').text(employee.taxable_salary),
            $('<td>').text(employee.tax_amount),
            $('<td>').text(employee.tax_paid),
            $('<td>').text(employee.remaining_tax),
            $('<td>').text(employee.total_departments)
        ).appendTo('#tblReport tbody');
    });
}

$(document).on('click','#btnPrint',function() {
    $('#form').attr('action',$URLPrintReport);
    $('#form').submit();
});

$(document).on('click','#btnExcel',function() {
    $('#form').attr('action',$URLExcelReport);
    $('#form').submit();
});
