/**
 * Created by Huzaifa on 9/18/15.
 */

$(document).ready(function() {
    $("#message").wysihtml5();
    $('#btnGetEmployee').tooltip('show');
    $('#btnHelpMessage').popover();
});

$(document).on('click','#btnGetEmployee',function() {
    var $department_id = $('#department_id option:selected').val();
    console.log($department_id);
    $.ajax({
        url: $UrlGetEmployees,
        dataType: 'json',
        type: 'post',
        data: 'department_id='+$department_id,
        mimeType:"multipart/form-data",
        beforeSend: function() {
            $('#tblMembers tbody').html('');
            $('#btnGetEmployee i').removeClass('fa-users').addClass('fa-refresh').addClass('fa-spin');
        },
        complete: function() {
            $('#btnGetEmployee i').removeClass('fa-refresh').removeClass('fa-spin').addClass('fa-users');
            $('#btnSendEmail').removeClass('hide');
            $('#loader').remove();
        },
        success: function(json) {
            if(json.success)
            {
                $('#tblMembers tbody').html(json.html);
            } else {
                alert(json.error);
            }
        },
        error: function(xhr, ajaxOptions, thrownError) {
            console.log(xhr.responseText);
        }
    })
});


$(document).on('click','#btnSendEmail',function() {
    sendEmail(0);
});


function sendEmail($row_id) {
    var objTR = $('#tblMembers').find('tbody').find('#row_'+$row_id);
    if(objTR.length) {
        var $subject = $('#subject').val();
        var $message = $('#message').val();
        var $registration_code = $('#employee_'+$row_id+'_registration_code').val();
        var $employee_name = $('#employee_'+$row_id+'_employee_name').val();
        var $email = $('#employee_'+$row_id+'_email').val();
        if($email == '') {
            $('#tblMembers').find('tbody').find('#row_'+$row_id).css('background-color','red');
            sendEmail(parseInt($row_id+1));
        } else {
            var $data = {
                id: $row_id,
                registration_code: $registration_code,
                employee_name: $employee_name,
                email: $email,
                subject: $subject,
                message: $message
            };


            $.ajax({
                url: $UrlSendEmail,
                dataType: 'json',
                type: 'post',
                data: $data,
                mimeType:"multipart/form-data",
                beforeSend: function() {
                    $('#tblMembers').find('tbody').find('#row_'+$row_id).css('background-color','yellow');
                },
                complete: function() {
                },
                success: function(json) {
                    if(json.success)
                    {
                        $('#tblMembers').find('tbody').find('#row_'+$row_id).css('background-color','green');
                        sendEmail(json.next_id);
                    } else {
                        alert(json.error);
                    }
                },
                error: function(xhr, ajaxOptions, thrownError) {
                    console.log(xhr.responseText);
                }
            })
        }
    }
}