<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <base href="<?php echo $base; ?>"/>
    <title><?php echo CONFIG_APPLICATION_NAME ?> | <?php echo $lang['heading_title']; ?></title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <!-- Bootstrap 3.3.5 -->
    <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.4.0/css/font-awesome.min.css">
    <!-- Ionicons -->
    <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
    <!-- Theme style -->
    <link rel="stylesheet" href="dist/css/AdminLTE.css">
    <!-- iCheck -->
    <link rel="stylesheet" href="plugins/iCheck/square/blue.css">

    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->

    <!-- Custom CSS to increase tooltip width -->
    <style>
        .tooltip-inner {
            max-width: 300px; /* Set your desired width */
            white-space: normal; /* Allow text to wrap */
            text-align: left;
        }
    </style>
</head>
<body class="hold-transition login-page">
<div class="login-box">
    <div class="login-logo">
        <a href="javascript:void(0);"><b><?php echo $lang['heading_title']; ?></b></a>
    </div><!-- /.login-logo -->
    <div class="login-box-body">
        <p class="login-box-msg"><?php echo $lang['text_password']; ?></p>
        <form action="<?php echo $action; ?>" method="post" enctype="multipart/form-data" id="form">
            <fieldset>
                <div class="form-group">
                    <label><?php echo $lang['label_login_name']; ?></label>
                    <input type="text" class="form-control" id="login_name" name="login_name" value="<?php echo $login_name; ?>" readonly/>
                    <input type="hidden" class="form-control" id="user_id" name="user_id" value="<?php echo $user_id; ?>" readonly/>
                </div>
                <div class="form-group">
                    <label><?php echo $lang['label_password']; ?></label>
                    <div class="input-group">
                        <input type="password" class="form-control" id="login_password" name="login_password" value="" />
                        <div class="input-group-addon">
                            <i class="fa fa-exclamation" id="tooltip-password" data-toggle="tooltip" title="<b>Rule</b></br>1. Password do not contain UserName</br>2. One Capital Letter</br>3. One Small Letter</br>4. One Number</br>5. One Special Character</br>6. Minimum 8 Characters"></i>
                        </div>
                    </div>
                    <label for="login_password" class="error text-red" style="display: none;">&nbsp;</label>
                    <input type="hidden" class="form-control" id="password_strength" name="password_strength" value="" />
                    <label for="password_strength" class="error text-red" style="display: none;">&nbsp;</label>
                    <div class="pwstrength_viewport_progress"></div>
                </div>
                <div class="form-group">
                    <div class="form-group">
                        <label><?php echo $lang['label_confirm_password']; ?></label>
                        <input type="password" class="form-control" id="confirm_password" name="confirm_password" value="" />
                        <label for="confirm_password" class="error text-red" style="display: none;">&nbsp;</label>
                    </div>
                </div>
                <a onclick="$('#form').submit();" class="btn btn-primary btn-block btn-flat"><span><?php echo $lang['button_submit']; ?></span></a>
            </fieldset>
            <?php if ($redirect) { ?>
            <input type="hidden" name="redirect" value="<?php echo $redirect; ?>"/>
            <?php } ?>
        </form>
    </div><!-- /.login-box-body -->
</div><!-- /.login-box -->

<!-- jQuery 2.1.4 -->
<script src="plugins/jQuery/jQuery-2.1.4.min.js"></script>
<!-- Bootstrap 3.3.5 -->
<script src="bootstrap/js/bootstrap.min.js"></script>
<!-- PWStrength -->
<script src="plugins/PWStrength/pwstrength-bootstrap.min.js"></script>
<script type="text/javascript" src="plugins/validate/jquery.validate.min.js"></script>
<script>
    jQuery('#form').validate(<?php echo $strValidation; ?>);

    jQuery(document).ready(function () {
        "use strict";
        var options = {};
        options.ui = {
            bootstrap3: true,
            container: ".login-box-body",
            showVerdictsInsideProgressBar: true,
            viewports: {
                progress: ".pwstrength_viewport_progress"
            }
        };
        options.common = {
            debug: true,
            usernameField: "#login_name",
            onKeyUp: function (evt, data) {
                console.log(data);
                $('#password_strength').val(data.verdictLevel);
            },
            onScore: function (options, word, totalScoreCalculated) {
                console.log(totalScoreCalculated);
                // Fall back to the score that was calculated by the rules engine.
                // Must pass back the score to set the total score variable.
                return totalScoreCalculated;
            }
        };
        $('#login_password').pwstrength(options);

        $('#tooltip-password').tooltip({html: true});
    });
</script>
</body>
</html>