<!DOCTYPE html>
<html>
<?php echo $header; ?>
<body class="hold-transition skin-blue sidebar-mini sidebar-collapse">
<div class="wrapper">
    <?php echo $page_header; ?>
    <?php echo $column_left; ?>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1><?php echo $lang['heading_title']; ?></h1>
            <div class="row">
                <div class="col-sm-6">
                    <ol class="breadcrumb">
                        <?php foreach($breadcrumbs as $breadcrumb): ?>
                        <li>
                            <a href="<?php echo $breadcrumb['href']; ?>">
                                <i class="<?php echo $breadcrumb['class']; ?>"></i>
                                <?php echo $breadcrumb['text']; ?>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ol>
                </div>
                <div class="col-sm-6">
                    <div class="pull-right">
                        <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                            <i class="fa fa-undo"></i>
                            &nbsp;<?php echo $lang['cancel']; ?>
                        </a>
                        <a class="btn btn-primary" href="javascript:void(0);" onclick="$('#form').submit();">
                            <i class="fa fa-floppy-o"></i>
                            &nbsp;<?php echo $lang['save']; ?>
                        </a>
                    </div>
                </div>
            </div>
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-sm-12">
                    <div class="box">
                        <div class="box-header">
                            <?php if ($error_warning) { ?>
                            <div class="alert alert-danger alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $error_warning; ?>
                            </div>
                            <?php } ?>
                            <?php  if ($success) { ?>
                            <div class="alert alert-success alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $success; ?>
                            </div>
                            <?php  } ?>
                        </div><!-- /.box-header -->
                        <div class="box-body">
                            <div class="col-sm-12">
                                <form action="<?php echo $action_save; ?>" method="post" enctype="multipart/form-data" id="form">
                                    <div class="row">
                                        <div class="col-sm-4">
                                            <div class="form-group">
                                                <label><span class="required">*</span>&nbsp;<?php echo $lang['employee_name']; ?></label>
                                                <input type="hidden" name="employee_code" id="employee_code" value="<?php echo $employee_code?>" />
                                                <input type="hidden" name="employee_name" id="employee_name" value="<?php echo $employee_name?>" />
                                                <select class="form-control" id="employee_id" name="employee_id">
                                                    <option data-employee_code="" data-employee_name="" value="">&nbsp;</option>
                                                    <?php foreach($employees as $employee): ?>
                                                    <option data-employee_code="<?php echo $employee['employee_code']; ?>" data-employee_name="<?php echo $employee['full_name']; ?>" value="<?php echo $employee['employee_id']; ?>" <?php echo ($employee_id==$employee['employee_id']?'selected':''); ?> ><?php echo $employee['employee_code'].': '.$employee['full_name']. ($employee['its_no']==''?'':' - '.$employee['its_no']); ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                                <label class="error" for="employee_id"></label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-sm-4">
                                            <div class="form-group">
                                                <label><span class="required">*</span>&nbsp;<?php echo $lang['vaccine_type']; ?></label>
                                                <select class="form-control" id="vaccine_type" name="vaccine_type">
                                                    <option value="">&nbsp;</option>
                                                    <?php foreach($vaccines as $vaccine): ?>
                                                    <option value="<?php echo $vaccine['vaccine_name']; ?>" <?php echo ($vaccine_type==$vaccine['vaccine_name']?'selected':''); ?>><?php echo $vaccine['vaccine_name']; ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                                <label class="error" for="vaccine_type"></label>
                                            </div>
                                        </div>
                                        <div class="col-sm-4">
                                            <div class="form-group">
                                                <label><span class="required">*</span>&nbsp;<?php echo $lang['dose1_date']; ?></label>
                                                <input type="text" class="form-control dtpDate" id="dose1_date" name="dose1_date" value="<?php echo $dose1_date; ?>"/>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-sm-4">
                                            <div class="form-group">
                                                <label><span class="required">*</span>&nbsp;<?php echo $lang['dose2_date']; ?></label>
                                                <input type="text" class="form-control dtpDate" id="dose2_date" name="dose2_date" value="<?php echo $dose2_date; ?>"/>
                                            </div>
                                        </div>
                                        <div class="col-sm-4">
                                            <div class="form-group">
                                                <label><span class="required">*</span>&nbsp;<?php echo $lang['certificate_no']; ?></label>
                                                <input type="text" class="form-control" id="certificate_no" name="certificate_no" value="<?php echo $certificate_no; ?>"/>
                                            </div>
                                        </div>
                                        <div class="col-sm-4">
                                            <div class="form-group">
                                                <label><span class="required">*</span>&nbsp;<?php echo $lang['certificate_image']; ?></label>
                                                <?php if($certificate_image): ?>
                                                <div class="input-group">
                                                    <input type="file" class="form-control" name="certificate_image" accept="image/png, image/gif, image/jpeg" />
                                                    <div class="input-group-btn">
                                                        <button type="button" class="btn btn-default" onclick="showCertificate('<?php echo $href_certificate; ?>');"><i class="fa fa-file-image-o"></i> View</button>
                                                    </div>
                                                </div>
                                                <?php else: ?>
                                                <input type="file" class="form-control" name="certificate_image" accept="image/png, image/gif, image/jpeg" />
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <div class="box-footer">
                            <div class="pull-right">
                                <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                                    <i class="fa fa-undo"></i>
                                    &nbsp;<?php echo $lang['cancel']; ?>
                                </a>
                                <a class="btn btn-primary" href="javascript:void(0);" onclick="$('#form').submit();">
                                    <i class="fa fa-floppy-o"></i>
                                    &nbsp;<?php echo $lang['save']; ?>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <script type="text/javascript" src="plugins/validate/jquery.validate.min.js"></script>
    <script type="text/javascript" src="plugins/validate/jquery.validate.file.js"></script>
    <script type="text/javascript">
        function showCertificate($image_url) {
            bootbox.dialog({
                title: 'Covid Certificate',
                message: '<img src="'+$image_url+'" alt="Covid Certificate"/>'
            });
        }
        $(document).on('change','#employee_id', function() {
            var $data = $(this).find('option:selected').data();

            $('#employee_code').val($data.employee_code);
            $('#employee_name').val($data.employee_name);
        });

        var $strValidation = <?php echo $strValidation ?>;
        jQuery("#form").validate($strValidation);
    </script>
    <?php echo $page_footer; ?>
    <?php echo $column_right; ?>
</div><!-- ./wrapper -->
<?php echo $footer; ?>
</body>
</html>