<!DOCTYPE html>
<html>
<?php echo $header; ?>
<body class="hold-transition skin-blue sidebar-mini sidebar-collapse">
<div class="wrapper">
    <?php echo $page_header; ?>
    <?php echo $column_left; ?>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1><?php echo $lang['heading_title']; ?></h1>
            <div class="row">
                <div class="col-sm-6">
                    <ol class="breadcrumb">
                        <?php foreach($breadcrumbs as $breadcrumb): ?>
                        <li>
                            <a href="<?php echo $breadcrumb['href']; ?>">
                                <i class="<?php echo $breadcrumb['class']; ?>"></i>
                                <?php echo $breadcrumb['text']; ?>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ol>
                </div>
            </div>
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-sm-12">
                    <div class="box">
                        <div class="box-header">
                            <?php if ($error_warning) { ?>
                            <div class="alert alert-danger alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $error_warning; ?>
                            </div>
                            <?php } ?>
                            <?php  if ($success) { ?>
                            <div class="alert alert-success alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $success; ?>
                            </div>
                            <?php  } ?>
                            <div class="alert alert-warning">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                Please make sure that there is no pending leaves within the period. There will be no effect later.
                            </div>
                        </div><!-- /.box-header -->
                        <div class="box-body">
                            <ul class="nav nav-pills" style="border-bottom: 1px solid #3c8dbc;">
                                <li class="hide"><a href="#tabDownloadFile" data-toggle="tab"><?php echo $lang['download_file']; ?></a></li>
                                <li class="active"><a href="#tabCSVAttendance" data-toggle="tab"><?php echo $lang['csv_attendance']; ?></a></li>
                                <li><a href="#tabManualAttendance" data-toggle="tab"><?php echo $lang['manual_attendance']; ?></a></li>
                                <li><a href="#tabAdjustment" data-toggle="tab"><?php echo $lang['adjustment']; ?></a></li>
                            </ul>
                            <div class="tab-content" style="margin-top: 15px;">
                                <div class="tab-pane hide" id="tabDownloadFile">
                                    <form action="<?php echo $action_download_file; ?>" method="post" enctype="multipart/form-data" id="frmDownloadFile">
                                        <div class="row">
                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <h3>Instruction</h3>
                                                    <p>Attendance File should be in required CSV (comma separated value).</p>
                                                    <p>First row should contain heading as defined.</p>
                                                </div>
                                                <div class="form-group">
                                                    <label><span class="required">*</span>&nbsp;<?php echo $lang['from_date']; ?></label>
                                                    <input type="text" class="form-control dtpDate" id="from_date" name="from_date" value="<?php echo $from_date; ?>"/>
                                                </div>
                                                <div class="form-group">
                                                    <label><span class="required">*</span>&nbsp;<?php echo $lang['to_date']; ?></label>
                                                    <input type="text" class="form-control dtpDate" id="to_date" name="to_date" value="<?php echo $to_date; ?>"/>
                                                </div>
                                                <div class="form-group">
                                                    <label><span class="required">*</span>&nbsp;<?php echo $lang['department']; ?></label>
                                                    <select class="form-control" id="department_id" name="department_id">
                                                        <option value="">&nbsp;</option>
                                                        <?php foreach($departments as $department): ?>
                                                        <option value="<?php echo $department['department_id']; ?>" <?php echo ($department['department_id']==$department_id?'selected="true"':''); ?>><?php echo $department['department_name']; ?></option>
                                                        <?php endforeach; ?>
                                                    </select>
                                                    <label for="department_id" class="error" style="display: none;">&nbsp;</label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-sm-offset-6 col-sm-6">
                                                <div class="pull-right">
                                                    <a class="btn btn-primary" href="javascript:void(0);" onclick="$('#frmDownloadFile').submit();">
                                                        <i class="fa fa-cloud-download"></i>
                                                        &nbsp;<?php echo $lang['download']; ?>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                                <div class="tab-pane active" id="tabCSVAttendance">
                                    <form action="<?php echo $action_save_csv_file; ?>" method="post" enctype="multipart/form-data" id="frmCSVAttendance">
                                        <div class="row">
                                            <div class="col-sm-4">
                                                <div class="form-group">
                                                    <label><span class="required">*</span>&nbsp;<?php echo $lang['from_date']; ?></label>
                                                    <input type="text" class="form-control dtpDate" id="from_date" name="from_date" value="<?php echo $from_date; ?>"/>
                                                </div>
                                                <div class="form-group">
                                                    <label><span class="required">*</span>&nbsp;<?php echo $lang['to_date']; ?></label>
                                                    <input type="text" class="form-control dtpDate" id="to_date" name="to_date" value="<?php echo $to_date; ?>"/>
                                                </div>
                                                <div class="form-group">
                                                    <label><span class="required">*</span>&nbsp;<?php echo $lang['csv_file']; ?></label>
                                                    <input type="file" class="form-control" id="csv_file" name="csv_file" value="<?php echo $csv_file; ?>" accept=".csv"/>
                                                </div>
                                            </div>
                                            <div class="col-sm-4">
                                                <div class="form-group">
                                                    <h3>Instruction</h3>
                                                    <p>Attendance File should be in required CSV (comma separated value).</p>
                                                    <p>First row should contain heading as defined.</p>
                                                    <p><strong>Date should be in {yyyy-mm-dd} format</strong></p>
                                                    <p><strong>Sample File:</strong>&nbsp;&nbsp;<a target="_blank" href="<?php echo $href_csv_sample_file; ?>" title="Download">Click Here</a></p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-sm-offset-6 col-sm-6">
                                                <div class="pull-right">
                                                    <a class="btn btn-primary" href="javascript:void(0);" onclick="$('#frmCSVAttendance').submit();">
                                                        <i class="fa fa-floppy-o"></i>
                                                        &nbsp;<?php echo $lang['save']; ?>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                                <div class="tab-pane" id="tabManualAttendance">
                                    <form action="<?php echo $action_save; ?>" method="post" enctype="multipart/form-data" id="form">
                                        <div class="row">
                                            <div class="col-sm-4">
                                                <div class="form-group">
                                                    <label><span class="required">*</span>&nbsp;<?php echo $lang['attendance_date']; ?></label>
                                                    <input type="text" class="form-control dtpDate" id="attendance_date" name="attendance_date" value="<?php echo $attendance_date; ?>"/>
                                                </div>
                                            </div>
                                            <div class="col-sm-4">
                                                <div class="form-group">
                                                    <label><span class="required">*</span>&nbsp;<?php echo $lang['department']; ?></label>
                                                    <select class="form-control" id="department_id" name="department_id">
                                                        <option value="">&nbsp;</option>
                                                        <?php foreach($departments as $department): ?>
                                                        <option value="<?php echo $department['department_id']; ?>" <?php echo ($department['department_id']==$department_id?'selected="true"':''); ?>><?php echo $department['department_name']; ?></option>
                                                        <?php endforeach; ?>
                                                    </select>
                                                    <label for="department_id" class="error" style="display: none;">&nbsp;</label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-sm-12">
                                                <table id="tblEmployee" class="table table-bordered table-striped">
                                                    <thead>
                                                    <tr>
                                                        <th>Sr.</th>
                                                        <th><?php echo $lang['registration_code']; ?></th>
                                                        <th><?php echo $lang['employee_name']; ?></th>
                                                        <th><?php echo $lang['shift_in']; ?></th>
                                                        <th><?php echo $lang['shift_out']; ?></th>
                                                        <th><?php echo $lang['time_in']; ?></th>
                                                        <th><?php echo $lang['time_out']; ?></th>
                                                        <th><?php echo $lang['status']; ?></th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>

                                                    </tbody>
                                                </table>
                                                <input type="hidden" id="employee_count" name="employee_count" value="" />
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-sm-offset-6 col-sm-6">
                                                <div class="pull-right">
                                                    <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                                                        <i class="fa fa-undo"></i>
                                                        &nbsp;<?php echo $lang['cancel']; ?>
                                                    </a>
                                                    <a class="btn btn-primary" href="javascript:void(0);" onclick="$('#form').submit();">
                                                        <i class="fa fa-floppy-o"></i>
                                                        &nbsp;<?php echo $lang['save']; ?>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                                <div class="tab-pane" id="tabAdjustment">
                                    <form action="<?php echo $action_save; ?>" method="post" enctype="multipart/form-data" id="form">
                                        <div class="row">
                                            <div class="col-sm-3">
                                                <div class="form-group">
                                                    <label for="adj_from_date"><span class="required">*</span>&nbsp;<?php echo $lang['from_date']; ?></label>
                                                    <input type="text" class="form-control dtpDate" id="adj_from_date" name="adj_from_date" value=""/>
                                                </div>
                                            </div>
                                            <div class="col-sm-3">
                                                <div class="form-group">
                                                    <label for="adj_to_date"><span class="required">*</span>&nbsp;<?php echo $lang['to_date']; ?></label>
                                                    <input type="text" class="form-control dtpDate" id="adj_to_date" name="adj_to_date" value=""/>
                                                </div>
                                            </div>
                                            <div class="col-sm-3">
                                                <div class="form-group">
                                                    <label for="adj_department_id"><span class="required">*</span>&nbsp;<?php echo $lang['department']; ?></label>
                                                    <select class="form-control" id="adj_department_id" name="adj_department_id">
                                                        <option value="">&nbsp;</option>
                                                        <?php foreach($departments as $department): ?>
                                                        <option value="<?php echo $department['department_id']; ?>"><?php echo $department['department_name']; ?></option>
                                                        <?php endforeach; ?>
                                                    </select>
                                                    <label for="adj_department_id" class="error" style="display: none;">&nbsp;</label>
                                                </div>
                                            </div>
                                            <div class="col-sm-3">
                                                <div class="form-group">
                                                    <label for="adj_registration_code"><span class="required">*</span>&nbsp;<?php echo $lang['registration_code']; ?></label>
                                                    <input type="text" class="form-control" id="adj_registration_code" name="adj_registration_code" value=""/>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-sm-offset-6 col-sm-6">
                                                <div class="pull-right">
                                                    <?php if($can_delete==1): ?>
                                                    <button type="button" id="btnDelete" class="btn btn-danger">
                                                        <i class="fa fa-trash-o"></i>
                                                        Delete Attendance
                                                    </button>
                                                    <?php endif; ?>
                                                    <?php if($can_update==1): ?>
                                                    <button type="button" id="btnRecalculate" class="btn btn-info">
                                                        <i class="fa fa-adjust"></i>
                                                        Recalculate
                                                    </button>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <script type="text/javascript" src="../admin/view/js/employee/employee_attendance.js"></script>
    <script type="text/javascript" src="plugins/validate/jquery.validate.min.js"></script>
    <script>
        jQuery('#frmDownloadFile').validate(<?php echo $strDownloadFile; ?>);
        jQuery('#frmCSVAttendance').validate(<?php echo $strCSVValidation; ?>);
        jQuery('#form').validate(<?php echo $strValidation; ?>);


        var $URLGetEmployee = '<?php echo $href_get_employee; ?>';
        var $URLDeleteAttendance = '<?php echo $href_delete_attendance; ?>';
        var $URLCalculateAttendance = '<?php echo $href_calculate_attendance; ?>';
    </script>
    <?php echo $page_footer; ?>
    <?php echo $column_right; ?>
</div><!-- ./wrapper -->
<?php echo $footer; ?>
</body>
</html>