<!DOCTYPE html>
<html>
<?php echo $header; ?>
<body class="hold-transition skin-blue sidebar-mini sidebar-collapse">
<div class="wrapper">
    <?php echo $page_header; ?>
    <?php echo $column_left; ?>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1><?php echo $lang['heading_title']; ?></h1>
            <div class="row">
                <div class="col-sm-6">
                    <ol class="breadcrumb">
                        <?php foreach($breadcrumbs as $breadcrumb): ?>
                        <li>
                            <a href="<?php echo $breadcrumb['href']; ?>">
                                <i class="<?php echo $breadcrumb['class']; ?>"></i>
                                <?php echo $breadcrumb['text']; ?>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ol>
                </div>
                <div class="col-sm-6">
                    <div class="pull-right">
                        <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                            <i class="fa fa-undo"></i>
                            &nbsp;<?php echo $lang['cancel']; ?>
                        </a>
                        <button type="button" class="btn btn-primary btnSave" onclick="submitDocument();">
                            <i class="fa fa-floppy-o"></i>
                            &nbsp;<?php echo $lang['save']; ?>
                        </button>
                    </div>
                </div>
            </div>
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-sm-12">
                    <div class="box">
                        <div class="box-header">
                            <?php if ($error_warning) { ?>
                            <div class="alert alert-danger alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $error_warning; ?>
                            </div>
                            <?php } ?>
                            <?php  if ($success) { ?>
                            <div class="alert alert-success alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $success; ?>
                            </div>
                            <?php  } ?>
                        </div><!-- /.box-header -->
                        <div class="box-body">
                            <form action="<?php echo $action_save; ?>" method="post" enctype="multipart/form-data" id="form">
                                <input type="hidden" id="primary_key" name="primary_key" value="<?php echo $employee_registration_id; ?>" />
                                <ul class="nav nav-pills" style="border-bottom: 1px solid #3c8dbc;">
                                    <li class="active"><a  href="#tabRegistration" data-toggle="tab"><?php echo $lang['registration']; ?></a></li>
                                    <li><a href="#tabSalary" data-toggle="tab"><?php echo $lang['salary']; ?></a></li>
                                    <li><a href="#tabScholarshipMedical" data-toggle="tab"><?php echo $lang['policies']; ?></a></li>
                                </ul>
                                <div class="tab-content" style="margin-top: 15px;">
                                    <div class="tab-pane active" id="tabRegistration">
                                        <div class="row">
                                            <div class="col-sm-4">
                                                <div class="form-group">
                                                    <label><span class="required">*</span>&nbsp;<?php echo $lang['registration_code']; ?></label>
                                                    <input type="text" id="registration_code" name="registration_code" value="<?php echo $registration_code; ?>" class="form-control" readonly/>
                                                </div>
                                                <div class="form-group">
                                                    <label><span class="required">*</span>&nbsp;<?php echo $lang['department']; ?></label>
                                                    <select class="form-control" id="department_id" name="department_id">
                                                        <option value="">&nbsp;</option>
                                                        <?php foreach($departments as $department): ?>
                                                        <option value="<?php echo $department['department_id']; ?>" <?php echo ($department['department_id']==$department_id?'selected="true"':''); ?>><?php echo $department['department_name']; ?></option>
                                                        <?php endforeach; ?>
                                                    </select>
                                                    <label for="department_id" class="error" style="display: none;">This field is required.</label>
                                                </div>
                                                <div class="form-group">
                                                    <label><span class="required">*</span>&nbsp;<?php echo $lang['employee_code']; ?></label>
                                                    <input type="hidden" class="form-control" id="employee_id" name="employee_id" value="<?php echo $employee_id; ?>" />
                                                    <input type="text" class="form-control" id="employee_code" name="employee_code" value="<?php echo $employee_code; ?>" />
                                                </div>
                                                <div class="form-group">
                                                    <label><span class="required">*</span>&nbsp;<?php echo $lang['employee_name']; ?></label>
                                                    <input type="text" class="form-control" id="employee_name" name="employee_name" value="<?php echo $employee_name; ?>" readonly/>
                                                </div>
                                                <div class="form-group">
                                                    <label><span class="required">*</span>&nbsp;<?php echo $lang['designation']; ?></label>
                                                    <select class="form-control" id="designation_id" name="designation_id">
                                                        <option value="">&nbsp;</option>
                                                        <?php foreach($designations as $designation): ?>
                                                        <option value="<?php echo $designation['designation_id']; ?>" <?php echo ($designation['designation_id']==$designation_id?'selected="true"':''); ?>><?php echo $designation['designation_name']; ?></option>
                                                        <?php endforeach; ?>
                                                    </select>
                                                    <label for="designation_id" class="error" style="display: none;">This field is required.</label>
                                                </div>
                                            </div>
                                            <div class="col-sm-3">
                                                <div class="form-group">
                                                    <label><span class="required">*</span>&nbsp;<?php echo $lang['attendance_shift']; ?></label>
                                                    <select id="attendance_shift_id" name="attendance_shift_id" class="form-control">
                                                        <?php foreach($attendance_shifts as $shift): ?>
                                                        <option value="<?php echo $shift['attendance_shift_id']; ?>" <?php echo ($shift['attendance_shift_id']==$attendance_shift_id?'selected="true"':''); ?>><?php echo $shift['shift_title']; ?></option>
                                                        <?php endforeach; ?>
                                                    </select>
                                                </div>
                                                <div class="form-group">
                                                    <label><span class="required">*</span>&nbsp;<?php echo $lang['attendance_code']; ?></label>
                                                    <input type="text" id="attendance_code" name="attendance_code" value="<?php echo $attendance_code; ?>" class="form-control" />
                                                </div>
                                                <div class="form-group">
                                                    <label><span class="required">*</span>&nbsp;<?php echo $lang['joining_date']; ?></label>
                                                    <input type="text" id="joining_date" name="joining_date" value="<?php echo $joining_date; ?>" class="form-control dtpDate" />
                                                </div>
                                                <div class="form-group">
                                                    <label><span class="required">*</span>&nbsp;<?php echo $lang['status']; ?></label>
                                                    <select class="form-control" id="status" name="status">
                                                        <option value="Active" <?php echo ($status=='Active'?'selected="true"':''); ?>>Active</option>
                                                        <option value="Inactive" <?php echo ($status=='Inactive'?'selected="true"':''); ?>>Inactive</option>
                                                    </select>
                                                    <label for="status" class="error" style="display: none;">This field is required.</label>
                                                </div>
                                                <div class="form-group" id="divLeavingDate" <?php echo ($status=='Active'?'style="display: none;"':''); ?>>
                                                <label><span class="required">*</span>&nbsp;<?php echo $lang['leaving_date']; ?></label>
                                                <input type="text" id="leaving_date" name="leaving_date" value="<?php echo $leaving_date; ?>" class="form-control dtpDate" />
                                                </div>
                                            </div>
                                            <div class="col-sm-3">
                                                <div class="form-group">
                                                    <label><span class="required">*</span>&nbsp;<?php echo $lang['bank_name']; ?></label>
                                                    <select class="form-control" id="employee_bank_id" name="employee_bank_id">
                                                        <option value="">&nbsp;</option>
                                                        <?php foreach($employee_banks as $bank): ?>
                                                        <option data-bank_id="<?php echo $bank['bank_id']; ?>" data-bank_title="<?php echo $bank['account_title']; ?>" data-bank_account="<?php echo $bank['account_no']; ?>" data-bank_iban="<?php echo $bank['iban_no']; ?>" value="<?php echo $bank['employee_bank_id']; ?>" <?php echo ($bank['employee_bank_id']==$employee_bank_id?'selected="true"':''); ?>><?php echo $bank['bank_name'].' - '.$bank['account_no']; ?></option>
                                                        <?php endforeach; ?>
                                                    </select>
                                                    <input type="hidden" id="bank_id" name="bank_id" value="<?php echo $bank_id; ?>" />
                                                    <label for="employee_bank_id" class="error" style="display: none;">This field is required.</label>
                                                </div>
                                                <div class="form-group">
                                                    <label><span class="required">*</span>&nbsp;<?php echo $lang['bank_account']; ?></label>
                                                    <input type="text" id="bank_account" name="bank_account" value="<?php echo $bank_account; ?>" class="form-control" readonly/>
                                                </div>
                                                <div class="form-group">
                                                    <label><span class="required">*</span>&nbsp;<?php echo $lang['bank_title']; ?></label>
                                                    <input type="text" id="bank_title" name="bank_title" value="<?php echo $bank_title; ?>" class="form-control" readonly/>
                                                </div>
                                                <div class="form-group">
                                                    <label for="bank_iban"><span class="required">*</span>&nbsp;<?php echo $lang['bank_iban']; ?></label>
                                                    <input type="text" id="bank_iban" name="bank_iban" value="<?php echo $bank_iban; ?>" class="form-control" readonly/>
                                                </div>
                                                <div class="form-group">
                                                    <label for="party_id"><span class="required">&nbsp;</span>&nbsp;<?php echo $lang['party_id']; ?></label>
                                                    <input type="text" id="party_id" name="party_id" value="<?php echo $party_id; ?>" class="form-control"/>
                                                </div>
                                            </div>
                                            <div class="col-sm-2">
                                                <div class="form-group">
                                                    <label><span class="required">&nbsp;</span>&nbsp;<?php echo $lang['total_payroll']; ?></label>
                                                    <input type="text" id="total_payroll" name="total_payroll" value="<?php echo $total_payroll; ?>" class="form-control fPInteger" />
                                                </div>
                                                <div class="form-group">
                                                    <label><span class="required">&nbsp;</span>&nbsp;<?php echo $lang['arrears']; ?></label>
                                                    <input type="text" id="arrears" name="arrears" value="<?php echo $arrears; ?>" class="form-control" />
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="tab-pane" id="tabSalary">
                                        <div class="row">
                                            <div class="col-sm-7">
                                                <div class="row">
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label><?php echo $lang['wef_date']; ?></label>
                                                            <input type="text" id="wef_date" name="wef_date" class="form-control dtpDate" value="" />
                                                            <input type="hidden" id="employee_salary_id" name="employee_salary_id" class="form-control" value="" />
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="form-group">
                                                            <label><?php echo $lang['basic_salary']; ?></label>
                                                            <input type="text" id="basic_salary" name="basic_salary" class="form-control" value="" onchange="calculateSalaryTotal();" />
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="checkbox">
                                                            <label>
                                                                <input type="checkbox" id="taxable" name="taxable" value="Yes" checked> <?php echo $lang['taxable']; ?>
                                                            </label>
                                                        </div>
                                                        <div class="checkbox">
                                                            <label>
                                                                <input type="checkbox" id="taxable_house_rent" name="taxable_house_rent" value="Yes"> <?php echo $lang['taxable_house_rent']; ?>
                                                            </label>
                                                        </div>
                                                        <div id="divTaxableHouseRent" class="input-group" style="display: none;">
                                                            <input class="form-control fPDecimal text-right" type="text" id="taxable_house_rent_percent" name="taxable_house_rent_percent" value="" onchange="calculateSalaryTotal();">
                                                            <span class="input-group-addon">%</span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-sm-7">
                                                        <label>Allowances</label>
                                                        <div class="table-responsive">
                                                            <table id="tblEmployeeAllowance" class="table table-bordered no-margin">
                                                                <thead>
                                                                <tr>
                                                                    <td class="text-center"><?php echo $lang['allowance']; ?></td>
                                                                    <td class="text-center"><?php echo $lang['allowance_value']; ?></td>
                                                                    <td class="text-center"><?php echo $lang['grossable']; ?></td>
                                                                    <td class="text-center"><?php echo $lang['taxable']; ?></td>
                                                                </tr>
                                                                </thead>
                                                                <tbody>
                                                                <?php foreach($allowances as $allowance): ?>
                                                                <tr data-allowance_id="<?php echo $allowance['allowance_id']; ?>">
                                                                    <td>
                                                                        <input type="hidden" id="employee_allowance_<?php echo $allowance['allowance_id']; ?>_allowance_id" name="employee_allowances[<?php echo $allowance['allowance_id']; ?>][allowance_id]" value="<?php echo $allowance['allowance_id']; ?>" readonly />
                                                                        <input class="form-control" type="text" id="employee_allowance_<?php echo $allowance['allowance_id']; ?>_allowance_name" name="employee_allowances[<?php echo $allowance['allowance_id']; ?>][allowance_name]" value="<?php echo $allowance['allowance_name']; ?>" disabled />
                                                                    </td>
                                                                    <td>
                                                                        <input onchange="calculateSalaryTotal();" class="form-control fPDecimal text-right" id="employee_allowance_<?php echo $allowance['allowance_id']; ?>_allowance_amount" name="employee_allowances[<?php echo $allowance['allowance_id']; ?>][allowance_amount]" value="" />
                                                                    </td>
                                                                    <td class="text-center">
                                                                        <input onchange="calculateSalaryTotal();" id="employee_allowance_<?php echo $allowance['allowance_id']; ?>_grossable" name="employee_allowances[<?php echo $allowance['allowance_id']; ?>][grossable]" type="checkbox" value="1">
                                                                    </td>
                                                                    <td class="text-center">
                                                                        <input onchange="calculateSalaryTotal();" id="employee_allowance_<?php echo $allowance['allowance_id']; ?>_taxable" name="employee_allowances[<?php echo $allowance['allowance_id']; ?>][taxable]" type="checkbox" value="1">
                                                                    </td>
                                                                </tr>
                                                                <?php endforeach; ?>
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-5">
                                                        <label>Deductions</label>
                                                        <div class="table-responsive">
                                                            <table id="tblEmployeeDeduction" class="table table-bordered no-margin">
                                                                <thead>
                                                                <tr>
                                                                    <td class="text-center"><?php echo $lang['deduction']; ?></td>
                                                                    <td class="text-center"><?php echo $lang['deduction_value']; ?></td>
                                                                </tr>
                                                                </thead>
                                                                <tbody>
                                                                <?php $grid_row_deduction=0;?>
                                                                <?php foreach($deductions as $deduction): ?>
                                                                <tr id="grid_row_deduction_<?php echo $grid_row_deduction; ?>" data-grid_row_deduction="<?php echo $grid_row_deduction; ?>">
                                                                    <td>
                                                                        <input type="hidden" id="employee_deduction_<?php echo $deduction['deduction_id']; ?>_deduction_id" name="employee_deductions[<?php echo $deduction['deduction_id']; ?>][deduction_id]" value="<?php echo $deduction['deduction_id']; ?>" readonly />
                                                                        <input class="form-control fPDecimal text-right" type="text" id="employee_deduction_<?php echo $deduction['deduction_id']; ?>_deduction_name" name="employee_deductions[<?php echo $deduction['deduction_id']; ?>][deduction_name]" value="<?php echo $deduction['deduction_name']; ?>" disabled />
                                                                    </td>
                                                                    <td>
                                                                        <input onchange="calculateSalaryTotal();" class="form-control fPDecimal text-right" id="employee_deduction_<?php echo $deduction['deduction_id']; ?>_deduction_amount" name="employee_deductions[<?php echo $deduction['deduction_id']; ?>][deduction_amount]" value="<?php echo $deduction['default_value']; ?>" />
                                                                    </td>
                                                                </tr>
                                                                <?php endforeach; ?>
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-sm-8">
                                                        <div class="row">
                                                            <div class="col-sm-4">
                                                                <div class="form-group">
                                                                    <label><?php echo $lang['total_allowance']; ?></label>
                                                                    <input type="text" id="total_allowance" name="total_allowance" class="form-control" value="" readonly/>
                                                                </div>
                                                            </div>
                                                            <div class="col-sm-4">
                                                                <div class="form-group">
                                                                    <label><?php echo $lang['gross_salary']; ?></label>
                                                                    <input type="text" id="gross_amount" name="gross_amount" class="form-control" value="" readonly/>
                                                                </div>
                                                            </div>
                                                            <div class="col-sm-4">
                                                                <div class="form-group">
                                                                    <label><?php echo $lang['taxable_salary']; ?></label>
                                                                    <div class="input-group input-group-sm">
                                                                        <input type="text" id="taxable_amount" name="taxable_amount" class="form-control text-right" value="" readonly/>
                                                                        <span class="input-group-btn">
                                                                        <button id="btnTax" class="btn btn-info btn-flat" type="button">Tax</button>
                                                                    </span>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="row">
                                                            <div class="col-sm-6">
                                                                <div class="form-group">
                                                                    <label><?php echo $lang['total_deduction']; ?></label>
                                                                    <input type="text" id="total_deduction" name="total_deduction" class="form-control text-right" value="" readonly/>
                                                                </div>
                                                            </div>
                                                            <div class="col-sm-6">
                                                                <div class="form-group">
                                                                    <label><?php echo $lang['net_salary']; ?></label>
                                                                    <input type="text" id="net_amount" name="net_amount" class="form-control text-right" value="" readonly/>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-5">
                                                <div class="table-responsive">
                                                    <table id="tblEmployeeSalary" class="table table-bordered table-striped">
                                                        <thead>
                                                        <tr>
                                                            <td class="text-center">&nbsp;</td>
                                                            <td class="text-center"><?php echo $lang['wef_date']; ?></td>
                                                            <td class="text-center"><?php echo $lang['basic_salary']; ?></td>
                                                            <td class="text-center"><?php echo $lang['total_allowance']; ?></td>
                                                            <td class="text-center"><?php echo $lang['gross_salary']; ?></td>
                                                            <td class="text-center"><?php echo $lang['total_deduction']; ?></td>
                                                            <td class="text-center"><?php echo $lang['net_salary']; ?></td>
                                                            <td class="text-center"><?php echo $lang['remove']; ?></td>
                                                        </tr>
                                                        </thead>
                                                        <tbody>
                                                        <?php $grid_row_salary=0;?>
                                                        <?php foreach($employee_salaries as $salary): ?>
                                                        <tr id="grid_row_salary_<?php echo $grid_row_salary; ?>" data-grid_row_salary_id="<?php echo $grid_row_salary; ?>">
                                                            <td>
                                                                <a class="btn btn-xs btn-primary" title="Edit" data-toggle="tooltip" href="javascript:void(0);" onclick="editEmployeeSalary('<?php echo $salary['employee_salary_id']; ?>',0);"><i class="fa fa-pencil"></i></a>
                                                                <a class="btn btn-xs btn-info" title="Duplicate" data-toggle="tooltip" href="javascript:void(0);" onclick="editEmployeeSalary('<?php echo $salary['employee_salary_id']; ?>',1);"><i class="fa fa-pencil"></i></a>
                                                            </td>
                                                            <td><?php echo $salary['wef_date']; ?></td>
                                                            <td class="text-right"><?php echo number_format($salary['basic_salary'],2); ?></td>
                                                            <td class="text-right"><?php echo number_format($salary['total_allowance'],2); ?></td>
                                                            <td class="text-right"><?php echo number_format($salary['gross_amount'],2); ?></td>
                                                            <td class="text-right"><?php echo number_format($salary['total_deduction'],2); ?></td>
                                                            <td class="text-right"><?php echo number_format($salary['net_amount'],2); ?></td>
                                                            <td class="text-center"><input type="checkbox" name="removeSalaries[]" value="<?php echo $salary['employee_salary_id'];?>" /></td>
                                                        </tr>
                                                        <?php $grid_row_salary++; ?>
                                                        <?php endforeach; ?>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Allowance Policy -->
                                    <div class="tab-pane" id="tabScholarshipMedical">
                                        <div class="row">
                                            <div class="col-sm-2">
                                                <div class="form-group">
                                                    <?php echo $lang['override_attendance_policy']; ?>
                                                    <input type="checkbox" id="override_attendance_policy" name="override_attendance_policy" value="1" data-toggle="toggle" data-on="Yes" data-off="No" data-width="100%" data-onstyle="success" data-offstyle="danger" <?php echo ($override_attendance_policy=='1'?'checked':'');?>>
                                                </div>
                                            </div>
                                            <div class="col-sm-2">
                                                <div class="form-group">
                                                    <?php echo $lang['override_allowance_policy']; ?>
                                                    <input type="checkbox" id="override_allowance_policy" name="override_allowance_policy" value="1" data-toggle="toggle" data-on="Yes" data-off="No" data-width="100%" data-onstyle="success" data-offstyle="danger" <?php echo ($override_allowance_policy=='1'?'checked':'');?>>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-sm-12">
                                                <div id="panelAttendance" class="panel panel-info">
                                                    <div class="panel-heading">
                                                        Attendance Policy
                                                    </div>
                                                    <div class="panel-body">
                                                        <div class="row">
                                                            <div class="col-sm-2">
                                                                <div class="form-group">
                                                                    <?php echo $lang['attendance_exempted']; ?>
                                                                    <input type="checkbox" id="attendance_exempted" name="attendance_exempted" value="1" data-toggle="toggle" data-on="Yes" data-off="No" data-width="100%" data-onstyle="success" data-offstyle="danger" <?php echo ($attendance_exempted=='1'?'checked':'');?>>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="row">
                                                            <div class="col-sm-2">
                                                                <div class="form-group">
                                                                    <label><?php echo $lang['deduction_days']; ?></label>
                                                                    <input type="text" class="form-control" name="deduction_days" value="<?php echo $deduction_days; ?>" />
                                                                </div>
                                                            </div>
                                                            <div class="col-sm-2">
                                                                <div class="form-group">
                                                                    <label><?php echo $lang['deduction_percent']; ?></label>
                                                                    <input type="text" class="form-control" name="deduction_percent" value="<?php echo $deduction_percent; ?>" />
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div id="panelAllowance" class="panel panel-info">
                                                    <div class="panel-heading">
                                                        Allowance Policy
                                                    </div>
                                                    <div class="panel-body">
                                                        <div class="table-responsive">
                                                            <table id="tblScholarship" class="table table-bordered table-stripped">
                                                                <thead>
                                                                <tr align="center" data-row_id="H">
                                                                    <td style="width: 15px;"><a class="btnAddScholarship btn btn-xs btn-primary" title="Add" href="javascript:void(0);"><i class="fa fa-plus"></i></a></td>
                                                                    <td><?php echo $lang['allowance_type']; ?></td>
                                                                    <td><?php echo $lang['allowance_category']; ?></td>
                                                                    <td><?php echo $lang['relation']; ?></td>
                                                                    <td><?php echo $lang['allowance_on']; ?></td>
                                                                    <td><?php echo $lang['allowance_value']; ?></td>
                                                                </tr>
                                                                </thead>
                                                                <tbody>
                                                                <?php $scholarship_row = 0;
                                                                    $scholarship_row_desc = count($employee_allowance_policy)-1 ?>
                                                                <?php foreach($employee_allowance_policy as $scholarship): ?>
                                                                <tr id="scholarship_row_<?php echo $scholarship_row; ?>" data-scholarship_row="<?php echo $scholarship_row; ?>">
                                                                    <td>
                                                                        <a onclick="removeScholarship(this);" title="Remove" class="btn btn-xs btn-danger" href="javascript:void(0);"><i class="fa fa-times"></i></a>
                                                                        <input type="hidden" id="employee_scholarship_<?php echo $scholarship_row; ?>_employee_scholarship_id" name="employee_scholarships[<?php echo $scholarship_row; ?>][employee_special_allowance_id]" value="<?php echo $scholarship['employee_special_allowance_id']; ?>" />

                                                                    </td>
                                                                    <td>
                                                                        <select class="form-control" id="allowance_type_<?php echo $scholarship_row; ?>" name="employee_scholarships[<?php echo $scholarship_row; ?>][allowance_type_id]" onchange="getAllowanceType(this);">
                                                                            <?php foreach($allowance_type as $type): ?>
                                                                            <option value="<?php echo $type['special_allowance_type_id']; ?>" <?php echo ($type['special_allowance_type_id']==$scholarship['allowance_type_id']?'selected="true"':''); ?>><?php echo $type['special_allowance_type']; ?></option>
                                                                            <?php endforeach; ?>
                                                                        </select>
                                                                    </td>
                                                                    <td>
                                                                        <select class="form-control" id="allowance_category_<?php echo $scholarship_row; ?>" name="employee_scholarships[<?php echo $scholarship_row; ?>][allowance_category_id]">
                                                                            <option value="0">ALL</option>
                                                                            <?php foreach($allowance_categories[$scholarship['allowance_type_id']] as $category): ?>
                                                                            <option value="<?php echo $category['special_allowance_category_id']; ?>" <?php echo ($category['special_allowance_category_id']==$scholarship['allowance_category_id']?'selected="true"':''); ?> ><?php echo $category['special_allowance_category']; ?></option>
                                                                            <?php endforeach; ?>
                                                                        </select>
                                                                    </td>
                                                                    <td>
                                                                        <select class="form-control" id="employee_scholarship_<?php echo $scholarship_row; ?>_relation" name="employee_scholarships[<?php echo $scholarship_row; ?>][relation]">
                                                                            <option value="">&nbsp;</option>
                                                                            <option value="Self" <?php echo ($scholarship['relation']=='Self'?'selected="true"':''); ?>><?php echo $lang['self']; ?></option>
                                                                            <option value="Parent" <?php echo ($scholarship['relation']=='Parent'?'selected="true"':''); ?>><?php echo $lang['parent']; ?></option>
                                                                            <option value="Sibling" <?php echo ($scholarship['relation']=='Sibling'?'selected="true"':''); ?>><?php echo $lang['sibling']; ?></option>
                                                                            <option value="Spouse" <?php echo ($scholarship['relation']=='Spouse'?'selected="true"':''); ?>><?php echo $lang['spouse']; ?></option>
                                                                            <option value="Child" <?php echo ($scholarship['relation']=='Child'?'selected="true"':''); ?>><?php echo $lang['child']; ?></option>
                                                                        </select>
                                                                    </td>
                                                                    <td>
                                                                        <select class="form-control" id="employee_scholarship_<?php echo $scholarship_row; ?>_scholarship_on" name="employee_scholarships[<?php echo $scholarship_row; ?>][allowance_on]">
                                                                            <option value="Percent" <?php echo ($scholarship['allowance_on']=='Percent'?'selected="true"':''); ?>><?php echo $lang['percent']; ?></option>
                                                                            <option value="Fixed" <?php echo ($scholarship['allowance_on']=='Fixed'?'selected="true"':''); ?>><?php echo $lang['fixed']; ?></option>
                                                                        </select>
                                                                    </td>
                                                                    <td>
                                                                        <input type="text" class="form-control fPDecimal" id="employee_scholarship_<?php echo $scholarship_row; ?>_scholarship_value" name="employee_scholarships[<?php echo $scholarship_row; ?>][allowance_value]" value="<?php echo $scholarship['allowance_value']; ?>" />
                                                                    </td>
                                                                </tr>
                                                                <?php $scholarship_row++; ?>
                                                                <?php $scholarship_row_desc--; ?>
                                                                <?php endforeach; ?>
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="box-footer">
                            <div class="pull-right">
                                <button type="button" class="btn btn-primary btnSave" onclick="submitDocument();">
                                    <i class="fa fa-floppy-o"></i>
                                    &nbsp;<?php echo $lang['save']; ?>
                                </button>
                                <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                                    <i class="fa fa-undo"></i>
                                    &nbsp;<?php echo $lang['cancel']; ?>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <link rel="stylesheet" href="plugins/bootstrap-toggle/css/bootstrap-toggle.min.css">
    <script src="plugins/bootstrap-toggle/js/bootstrap-toggle.min.js"></script>
    <script type="text/javascript" src="plugins/validate/jquery.validate.min.js"></script>
    <script>
        var $lang = <?php echo json_encode($lang); ?>;
        var $scholarship_row = '<?php echo $scholarship_row; ?>';
        var $medical_row = '<?php echo $medical_row; ?>';
        var $URLGetEmployee = '<?php echo $href_get_employee; ?>';
        var $URLGetEmployeeSalary = '<?php echo $href_get_employee_salary; ?>';
        var $URLGetSalaryInfo = '<?php echo $href_get_salary_info; ?>';
        var $URLGetTaxInfo = '<?php echo $href_get_tax_info; ?>';
        var $URLSaveAjax = '<?php echo $href_save_ajax; ?>';
        var $URLValidateAttendanceCode = '<?php echo $href_validate_attendance; ?>';
        var $URLGetAllowanceCategory = '<?php echo $href_get_allowance_category; ?>';
        var $URLCheckEmployeeLoan = '<?php echo $href_check_emp_loan; ?>';
        var $grid_row_allowance = '<?php echo $grid_row_allowance; ?>';
        var $grid_row_deduction = '<?php echo $grid_row_deduction; ?>';
        var $allowances = <?php echo json_encode($allowances); ?>;
        var $deductions = <?php echo json_encode($deductions); ?>;
        // var $special_allowance_categories = <?php echo json_encode($special_allowance_categories); ?>;
        // var $scholarship_allowances = <?php echo json_encode($scholarship_allowances); ?>;
        var $allowance_type = <?php echo json_encode($allowance_type); ?>;

        jQuery('#form').validate(<?php echo $strValidation; ?>);
    </script>
    <script type="text/javascript" src="../admin/view/js/employee/employee_registration.js"></script>
    <?php echo $page_footer; ?>
    <?php echo $column_right; ?>
</div><!-- ./wrapper -->
<?php echo $footer; ?>
</body>
</html>