<!DOCTYPE html>
<html>
<?php echo $header; ?>
<body class="hold-transition skin-blue sidebar-mini sidebar-collapse">
<div class="wrapper">
    <?php echo $page_header; ?>
    <?php echo $column_left; ?>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1><?php echo $lang['heading_title']; ?></h1>
            <div class="row">
                <div class="col-sm-6">
                    <ol class="breadcrumb">
                        <?php foreach($breadcrumbs as $breadcrumb): ?>
                        <li>
                            <a href="<?php echo $breadcrumb['href']; ?>">
                                <i class="<?php echo $breadcrumb['class']; ?>"></i>
                                <?php echo $breadcrumb['text']; ?>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ol>
                </div>
                <div class="col-sm-6">
                    <div class="pull-right">
                        <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                            <i class="fa fa-undo"></i>
                            &nbsp;<?php echo $lang['cancel']; ?>
                        </a>
                        <?php if($isEdit==1): ?>
                        <a class="btn btn-warning" href="javascript:void(0);" onclick="returnDocument();">
                            <i class="fa fa-repeat"></i>
                            &nbsp;Return to Employee
                        </a>
                        <?php endif; ?>
                        <a class="btn btn-primary" href="javascript:void(0);" onclick="$('#form').submit();">
                            <i class="fa fa-floppy-o"></i>
                            &nbsp;Save as Draft
                        </a>
                        <a class="btn btn-primary" href="javascript:void(0);" onclick="saveSubmit();">
                            <i class="fa fa-floppy-o"></i>
                            &nbsp;Save & Submit
                        </a>
                    </div>
                </div>
            </div>
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-sm-12">
                    <div class="box">
                        <div class="box-header">
                            <?php if ($error_warning) { ?>
                            <div class="alert alert-danger alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $error_warning; ?>
                            </div>
                            <?php } ?>
                            <?php  if ($success) { ?>
                            <div class="alert alert-success alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $success; ?>
                            </div>
                            <?php  } ?>
                        </div><!-- /.box-header -->
                        <div class="box-body">
                            <div class="col-sm-12">
                                <form action="<?php echo $action_save; ?>" method="post" enctype="multipart/form-data" id="form">
                                    <div class="row">
                                        <div class="col-sm-4">
                                            <div class="form-group">
                                                <label><span class="required">*</span>&nbsp;<?php echo $lang['request_on']; ?></label>
                                                <input type="text" class="form-control dtpDate" id="request_date" name="request_date" value="<?php echo $request_date; ?>"/>
                                            </div>
                                        </div>
                                        <div class="col-sm-4">
                                            <div class="form-group">
                                                <label><span class="required">*</span>&nbsp;<?php echo $lang['employee_name']; ?></label>
                                                <select class="form-control" id="employee_registration_id" name="employee_registration_id">
                                                    <option value="">&nbsp;</option>
                                                    <?php foreach($employee_registrations as $employee): ?>
                                                    <option value="<?php echo $employee['employee_registration_id']; ?>" <?php echo ($employee['employee_registration_id']==$employee_registration_id?'selected="true"':''); ?>><?php echo $employee['employee_name']; ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                                <label for="employee_registration_id" class="error" style="display: none;">&nbsp;</label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-sm-4">
                                            <div class="form-group">
                                                <label><span class="required">*</span>&nbsp;<?php echo $lang['leave_from']; ?></label>
                                                <input type="text" class="form-control dtpDate" id="leave_from" name="leave_from" value="<?php echo $leave_from; ?>"/>
                                            </div>
                                        </div>
                                        <div class="col-sm-4">
                                            <div class="form-group">
                                                <label><span class="required">*</span>&nbsp;<?php echo $lang['leave_to']; ?></label>
                                                <input type="text" class="form-control dtpDate" id="leave_to" name="leave_to" value="<?php echo $leave_to; ?>"/>
                                            </div>
                                        </div>
                                        <div class="col-sm-4">
                                            <div class="form-group">
                                                <label><span class="required">*</span>&nbsp;<?php echo $lang['reason']; ?></label>
                                                <input type="text" class="form-control" id="reason" name="reason" value="<?php echo $reason; ?>"/>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="form-group">
                                                <label><span class="required">*</span>&nbsp;<?php echo $lang['description']; ?></label>
                                                <textarea class="form-control" rows="3" id="description" name="description"><?php echo $description; ?></textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <hr />
                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="table-responsive">
                                                <label class="help-block">Previous Leaves</label>
                                                <table class="table table-bordered table-hover">
                                                    <thead>
                                                    <tr>
                                                        <th>Request On</th>
                                                        <th>Leave Request</th>
                                                        <th>Status</th>
                                                        <th>Leave Approved</th>
                                                        <th>Leave Type</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <?php foreach($leaves as $leave): ?>
                                                    <tr>
                                                        <td><?php echo stdDate($leave['request_date']); ?></td>
                                                        <td><?php echo stdDate($leave['leave_from']).' - '.stdDate($leave['leave_to']); ?></td>
                                                        <td><?php echo $leave['status']; ?></td>
                                                        <td>
                                                            <?php if($leave['status']=='Approved'): ?>
                                                            <?php echo stdDate($leave['approved_from']).' - '.stdDate($leave['approved_to']); ?>
                                                            <?php endif; ?>
                                                        </td>
                                                        <td>
                                                            <?php if($leave['status']=='Approved'): ?>
                                                            <?php echo $leave['approved_type']; ?>
                                                            <?php endif; ?>
                                                        </td>
                                                    </tr>
                                                    <?php endforeach; ?>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <div class="box-footer">
                            <div class="pull-right">
                                <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                                    <i class="fa fa-undo"></i>
                                    &nbsp;<?php echo $lang['cancel']; ?>
                                </a>
                                <?php if($isEdit==1): ?>
                                <a class="btn btn-warning" href="javascript:void(0);" onclick="returnDocument();">
                                    <i class="fa fa-repeat"></i>
                                    &nbsp;Return to Employee
                                </a>
                                <?php endif; ?>
                                <a class="btn btn-primary" href="javascript:void(0);" onclick="$('#form').submit();">
                                    <i class="fa fa-floppy-o"></i>
                                    &nbsp;Save as Draft
                                </a>
                                <a class="btn btn-primary" href="javascript:void(0);" onclick="saveSubmit();">
                                    <i class="fa fa-floppy-o"></i>
                                    &nbsp;Save & Submit
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <script type="text/javascript" src="../admin/view/js/employee/employee_leave.js"></script>
    <script type="text/javascript" src="plugins/validate/jquery.validate.min.js"></script>
    <script>
        function saveSubmit() {
            var $URLSave = '<?php echo $action_save; ?>&submit=1';
            $('#form').attr('action', $URLSave).submit();
        }

        function returnDocument() {
            var $URLSave = '<?php echo $href_return; ?>';
            $('#form').attr('action', $URLSave).submit();
        }

        var $URLGetEmployeeDepartments = '<?php echo $href_get_employee_departments; ?>';
        jQuery('#form').validate(<?php echo $strValidation; ?>);
    </script>
    <?php echo $page_footer; ?>
    <?php echo $column_right; ?>
</div><!-- ./wrapper -->
<?php echo $footer; ?>
</body>
</html>