<!DOCTYPE html>
<html>
<?php echo $header; ?>
<body class="hold-transition skin-blue sidebar-mini sidebar-collapse">
<div class="wrapper">
    <?php echo $page_header; ?>
    <?php echo $column_left; ?>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1><?php echo $lang['heading_title']; ?></h1>
            <div class="row">
                <div class="col-sm-6">
                    <ol class="breadcrumb">
                        <?php foreach($breadcrumbs as $breadcrumb): ?>
                        <li>
                            <a href="<?php echo $breadcrumb['href']; ?>">
                                <i class="<?php echo $breadcrumb['class']; ?>"></i>
                                <?php echo $breadcrumb['text']; ?>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ol>
                </div>
                <div class="col-sm-6">
                    <div class="pull-right">
                        <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                            <i class="fa fa-undo"></i>
                            &nbsp;<?php echo $lang['cancel']; ?>
                        </a>
                        <a class="btn btn-primary" href="javascript:void(0);" onclick="$('#form').submit();">
                            <i class="fa fa-floppy-o"></i>
                            &nbsp;<?php echo $lang['save']; ?>
                        </a>
                    </div>
                </div>
            </div>
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-sm-12">
                    <div class="box">
                        <div class="box-header">
                            <?php if ($error_warning) { ?>
                            <div class="alert alert-danger alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $error_warning; ?>
                            </div>
                            <?php } ?>
                            <?php  if ($success) { ?>
                            <div class="alert alert-success alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $success; ?>
                            </div>
                            <?php  } ?>
                        </div><!-- /.box-header -->
                        <div class="box-body">
                            <div class="col-sm-12">
                                <form action="<?php echo $action_save; ?>" method="post" enctype="multipart/form-data" id="form">
                                    <div class="row">
                                        <div class="col-sm-4">
                                            <div class="form-group">
                                                <label><span class="required">*</span>&nbsp;<?php echo $lang['document_no']; ?></label>
                                                <input type="text" class="form-control" id="document_identity" name="document_identity" value="<?php echo $document_identity; ?>" readonly/>
                                            </div>
                                        </div>
                                        <div class="col-sm-4">
                                            <div class="form-group">
                                                <label><span class="required">*</span>&nbsp;<?php echo $lang['document_date']; ?></label>
                                                <input type="text" class="form-control dtpDate" id="document_date" name="document_date" value="<?php echo $document_date; ?>"/>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-sm-4">
                                            <div class="form-group">
                                                <label><span class="required">*</span>&nbsp;<?php echo $lang['company']; ?></label>
                                                <select class="form-control" id="company_id" name="company_id">
                                                    <option value="">&nbsp;</option>
                                                    <?php foreach($companies as $company): ?>
                                                    <option value="<?php echo $company['company_id']; ?>" ><?php echo $company['company_name']; ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                                <label class="error" for="company_id"></label>
                                            </div>
                                        </div>
                                        <div class="col-sm-4">
                                            <div class="form-group">
                                                <label><span class="required">*</span>&nbsp;<?php echo $lang['employee_name']; ?></label>
                                                <input type="hidden" name="employee_code" id="employee_code" value="<?php echo $employee_code?>" />
                                                <input type="hidden" name="employee_name" id="employee_name" value="<?php echo $employee_name?>" />
                                                <select class="form-control" id="employee_id" name="employee_id">
                                                    <option data-employee_code="" data-employee_name="" value="">&nbsp;</option>
                                                    <?php foreach($employees as $employee): ?>
                                                    <option data-employee_code="<?php echo $employee['employee_code']; ?>" data-employee_name="<?php echo $employee['employee_name']; ?>" value="<?php echo $employee['employee_id']; ?>" <?php echo ($employee_id==$employee['employee_id']?'selected':''); ?> ><?php echo $employee['employee_code'].': '.$employee['employee_name']. ($employee['its_no']==''?'':' - '.$employee['its_no']); ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                                <label class="error" for="employee_id"></label>
                                            </div>
                                        </div>
                                        <div class="col-sm-4">
                                            <div class="form-group">
                                                <label><span class="required">*</span>&nbsp;<?php echo $lang['signatory_name']; ?></label>
                                                <input type="text" class="form-control" id="signatory_name" name="signatory_name" value="<?php echo $signatory_name; ?>"/>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-sm-4">
                                            <div class="form-group">
                                                <label><span class="required">*</span>&nbsp;<?php echo $lang['hospital_name']; ?></label>
                                                <input type="text" class="form-control" id="hospital_name" name="hospital_name" value="<?php echo $hospital_name; ?>"/>
                                            </div>
                                        </div>
                                        <div class="col-sm-4">
                                            <div class="form-group">
                                                <label><span class="required">*</span>&nbsp;<?php echo $lang['hospital_address_1']; ?></label>
                                                <input type="text" class="form-control" id="hospital_address_1" name="hospital_address_1" value="<?php echo $hospital_address_1; ?>"/>
                                            </div>
                                        </div>
                                        <div class="col-sm-4">
                                            <div class="form-group">
                                                <label><span class="required">*</span>&nbsp;<?php echo $lang['hospital_address_2']; ?></label>
                                                <input type="text" class="form-control" id="hospital_address_2" name="hospital_address_2" value="<?php echo $hospital_address_2; ?>"/>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <div class="box-footer">
                            <div class="pull-right">
                                <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                                    <i class="fa fa-undo"></i>
                                    &nbsp;<?php echo $lang['cancel']; ?>
                                </a>
                                <a class="btn btn-primary" href="javascript:void(0);" onclick="$('#form').submit();">
                                    <i class="fa fa-floppy-o"></i>
                                    &nbsp;<?php echo $lang['save']; ?>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <script type="text/javascript" src="plugins/validate/jquery.validate.min.js"></script>
    <script type="text/javascript">
        $(document).on('change','#company_id', function() {
            var $company_id = $(this).find('option:selected').val();
            var $URLGetCompanyEmployees = '<?php echo $href_get_company_employees; ?>';

            $.ajax({
                url: $URLGetCompanyEmployees,
                dataType: 'json',
                type: 'post',
                data: 'company_id='+$company_id,
                beforeSend: function() {
                    $('#employee_id').html('<option data-employee_code="" data-employee_name="" value=""></option>');
                    $('#employee_id').before('<i id="loader" class="fa fa-spin fa-refresh"></i>');
                },
                complete: function() {
                    $('#loader').remove();
                },
                success: function(json) {
                    if(json.success)
                    {
                        $('#employee_id').html(json.employees).trigger('change');
                    } else {
                        alert(json.error);
                    }
                },
                error: function(xhr, ajaxOptions, thrownError) {
                    console.log(xhr.responseText);
                }
            });
        });

        $(document).on('change','#employee_id', function() {
            var $data = $(this).find('option:selected').data();

            $('#employee_code').val($data.employee_code);
            $('#employee_name').val($data.employee_name);
        });

        var $strValidation = <?php echo $strValidation ?>;
        jQuery("#form").validate($strValidation);
    </script>
    <?php echo $page_footer; ?>
    <?php echo $column_right; ?>
</div><!-- ./wrapper -->
<?php echo $footer; ?>
</body>
</html>