<!DOCTYPE html>
<html>
<?php echo $header; ?>
<body class="hold-transition skin-blue sidebar-mini sidebar-collapse">
    <style type="text/css" src="plugins/dataTables/extensions/FixedColumns/css/dataTables.fixedColumns.min.css"></style>
    <div class="wrapper">
        <?php echo $page_header; ?>
        <?php echo $column_left; ?>
        <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section class="content-header">
                <h1><?php echo $lang['heading_title']; ?></h1>
                <div class="row">
                    <div class="col-sm-6">
                        <ol class="breadcrumb">
                            <?php foreach($breadcrumbs as $breadcrumb): ?>
                            <li>
                                <a href="<?php echo $breadcrumb['href']; ?>">
                                    <i class="<?php echo $breadcrumb['class']; ?>"></i>
                                    <?php echo $breadcrumb['text']; ?>
                                </a>
                            </li>
                            <?php endforeach; ?>
                        </ol>
                    </div>
                    <div class="col-sm-6">
                        <div class="pull-right">
                            <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                                <i class="fa fa-undo"></i>
                                &nbsp;<?php echo $lang['cancel']; ?>
                            </a>
                            <?php if($isEdit != 1): ?>
                            <button type="submit" class="btn btn-primary btnSave">
                                <i class="fa fa-floppy-o"></i>
                                &nbsp;<?php echo $lang['save']; ?>
                            </button>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </section>
            <!-- Main content -->
            <section class="content">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="box">
                            <div class="box-header">
                                <?php if ($error_warning) { ?>
                                <div class="alert alert-danger alert-dismissable">
                                    <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                    <?php echo $error_warning; ?>
                                </div>
                                <?php } ?>
                                <?php  if ($success) { ?>
                                <div class="alert alert-success alert-dismissable">
                                    <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                    <?php echo $success; ?>
                                </div>
                                <?php  } ?>
                            </div><!-- /.box-header -->
                            <form action="" method="post" enctype="multipart/form-data" id="form">
                                <div class="box-body">
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <label>&nbsp;<?php echo $lang['doc_no']; ?></label>
                                            <input type="text" id="doc_no" name="document_no" value="<?php echo $document_identity ?>" class="form-control" readonly/>
                                        </div>    
                                    </div>
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <label>&nbsp;<?php echo $lang['doc_date']; ?></label>
                                            <input type="text" id="document_date" name="document_date" value="<?php echo date($document_date); ?>" class="form-control dtpDate" />
                                        </div>
                                    </div>
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['month']; ?></label>
                                            <select class="form-control" id="for_month" name="for_month">
                                                <option value="">&nbsp;</option>
                                                <option value="1" <?php echo ($for_month == '1')?"selected":"" ?> >January</option>
                                                <option value="2" <?php echo ($for_month == '2')?"selected":"" ?>>February</option>
                                                <option value="3" <?php echo ($for_month == '3')?"selected":"" ?>>March</option>
                                                <option value="4" <?php echo ($for_month == '4')?"selected":"" ?>>April</option>
                                                <option value="5" <?php echo ($for_month == '5')?"selected":"" ?>>May</option>
                                                <option value="6" <?php echo ($for_month == '6')?"selected":"" ?>>June</option>
                                                <option value="7" <?php echo ($for_month == '7')?"selected":"" ?>>July</option>
                                                <option value="8" <?php echo ($for_month == '8')?"selected":"" ?>>August</option>
                                                <option value="9" <?php echo ($for_month == '9')?"selected":"" ?>>September</option>
                                                <option value="10" <?php echo ($for_month == '10')?"selected":"" ?>>October</option>
                                                <option value="11" <?php echo ($for_month == '11')?"selected":"" ?>>November</option>
                                                <option value="12" <?php echo ($for_month == '12')?"selected":"" ?>>December</option>
                                            </select>
                                        </div>    
                                    </div>
                                    <div class="col-sm-12">
                                        <div class="pull-right">
                                            <button type="button" onclick="getMemberList();" class="btn btn-primary btnSave">
                                                <i class="fa fa-search"></i>
                                                &nbsp;<?php echo $lang['search']; ?>
                                            </button>
                                        </div>    
                                    </div>
                                    
                                    <div class="col-sm-12">
                                        <label>Members' List</label>
                                        <div class="table-responsive">
                                            <table id="tblMemberList" class="table table-striped table-bordered table-hover" align="center">
                                                <thead>
                                                    <tr>
                                                        <td align="center" style="width: 6%"><?php echo $lang['employee_registration_code']; ?></td>
                                                        <td class="text-center"><?php echo $lang['employee_name']; ?></td>
                                                        <td class="text-center"><?php echo $lang['cnic_no']; ?></td>
                                                        <td class="text-center"><?php echo $lang['department']; ?></td>
                                                        <td class="text-center"><?php echo $lang['designation']; ?></td>
                                                        <td class="text-center"><?php echo $lang['social_security_no']; ?></td>
                                                        <td class="text-center"><?php echo $lang['basic_amount']; ?></td>
                                                        <td class="text-center"><?php echo $lang['amount']; ?></td>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php if(!empty($contribution_details))
                                                    { ?>
                                                        <?php foreach($contribution_details as $key => $value): ?>
                                                        <tr>
                                                            <td><?php echo $value['registration_code']; ?></td>
                                                            <td><?php echo $value['employee_name']; ?></td>
                                                            <td><?php echo $value['cnic_no']; ?></td>
                                                            <td><?php echo $value['department_name']; ?></td>
                                                            <td><?php echo $value['designation_name']; ?></td>
                                                            <td><?php echo $value['social_security_no']; ?></td>
                                                            <td><?php echo $value['basic_salary']; ?></td>
                                                            <td><?php echo $value['amount']; ?></td>
                                                        </tr>
                                                         <?php endforeach; ?>
                                                    <?php }
                                                    ?>
                                                    
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                                <div class="box-footer">
                                    <div class="pull-right">
                                        <?php if($isEdit != 1): ?>
                                        <button type="submit" class="btn btn-primary btnSave">
                                            <i class="fa fa-floppy-o"></i>
                                            &nbsp;<?php echo $lang['save']; ?>
                                        </button>
                                        <?php endif; ?>
                                        <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                                            <i class="fa fa-undo"></i>
                                            &nbsp;<?php echo $lang['cancel']; ?>
                                        </a>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </section>
        </div>
        <link rel="stylesheet" href="plugins/dataTables/dataTables.bootstrap.css">
        <script src="plugins/dataTables/jquery.dataTables.js"></script>
        <script src="plugins/dataTables/dataTables.bootstrap.js"></script>
        <script type="text/javascript">
            var $URLGetMemberList = '<?php echo $href_get_member; ?>';
            function getMemberList()
            {
                var $data = {
                    doc_date: $('#document_date').val(),
                    month: $('#for_month').val()
                }
                $.ajax({
                    url: $URLGetMemberList,
                    dataType: 'json',
                    type: 'post',
                    data: $data,
                    mimeType:"multipart/form-data",
                    beforeSend: function() {
                        $('#tblMemberList').before('<span id="loader" class="pull-right"><i class="fa fa-spin fa-refresh"></i></span>');
                    },
                    complete: function() {
                            // $('.btnSave').removeAttr('disabled');
                            $('#loader').remove();
                        },
                        success: function(json) {
                            if(json.success)
                            {
                                console.log(json);
                                $('#tblMemberList tbody').html(json.html);
                            } else {
                                alert(json.error);
                            }
                        },
                        error: function(xhr, ajaxOptions, thrownError) {
                            console.log(xhr.responseText);
                        }
                    })
            }
            jQuery(document).ready(function(){

                oTable = jQuery('#dataTable').dataTable();
                
            });
        </script>
        <?php echo $page_footer; ?>
        <?php echo $column_right; ?>
    </div><!-- ./wrapper -->
    <?php echo $footer; ?>
</body>
</html>