<!DOCTYPE html>
<html>
<?php echo $header; ?>
<body class="hold-transition skin-blue sidebar-mini sidebar-collapse">
<style type="text/css" src="plugins/dataTables/extensions/FixedColumns/css/dataTables.fixedColumns.min.css"></style>
<div class="wrapper">
<?php echo $page_header; ?>
<?php echo $column_left; ?>
<div class="content-wrapper">
<!-- Content Header (Page header) -->
<section class="content-header">
    <h1><?php echo $lang['heading_title']; ?></h1>
    <div class="row">
        <div class="col-sm-6">
            <ol class="breadcrumb">
                <?php foreach($breadcrumbs as $breadcrumb): ?>
                <li>
                    <a href="<?php echo $breadcrumb['href']; ?>">
                        <i class="<?php echo $breadcrumb['class']; ?>"></i>
                        <?php echo $breadcrumb['text']; ?>
                    </a>
                </li>
                <?php endforeach; ?>
            </ol>
        </div>
        <div class="col-sm-6">
            <div class="pull-right">
                <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                    <i class="fa fa-undo"></i>
                    &nbsp;<?php echo $lang['cancel']; ?>
                </a>
                <?php if($is_edit!=1): ?>
                <a class="btn btn-primary" href="javascript:void(0);" onclick="$('#form').submit();">
                    <i class="fa fa-floppy-o"></i>
                    &nbsp;<?php echo $lang['save']; ?>
                </a>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>
<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-sm-12">
            <div class="box">
                <div class="box-body">
                    <?php if ($error_warning) { ?>
                    <div class="alert alert-danger alert-dismissable">
                        <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                        <?php echo $error_warning; ?>
                    </div>
                    <?php } ?>
                    <?php  if ($success) { ?>
                    <div class="alert alert-success alert-dismissable">
                        <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                        <?php echo $success; ?>
                    </div>
                    <?php  } ?>
                    <form action="<?php echo $action_save; ?>" method="post" enctype="multipart/form-data" id="form">
                        <div class="row">
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label><span class="required">*</span>&nbsp;<?php echo $lang['from_date']; ?></label>
                                    <input type="text" id="from_date" name="from_date" value="<?php echo $from_date; ?>" class="form-control dtpDate"/>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label><span class="required">*</span>&nbsp;<?php echo $lang['to_date']; ?></label>
                                    <input type="text" id="to_date" name="to_date" value="<?php echo $to_date; ?>" class="form-control dtpDate"/>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label><span class="required">*</span>&nbsp;<?php echo $lang['pay_date']; ?></label>
                                    <input type="text" id="pay_date" name="pay_date" value="<?php echo $pay_date; ?>" class="form-control dtpDate"/>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>&nbsp;</label>
                                    <button type="button" id="btnCalculate" name="btnCalculate" class="btn btn-primary form-control">Calculate</button>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div id="divBankLetter" class="table-responsive">
                                    <?php if($is_edit): ?>
                                    <table class="table table-bordered">
                                        <thead>
                                        <tr>
                                            <th colspan="10">Deposit Slips</th>
                                        </tr>
                                        <tr>
                                            <th>Payroll Date</th>
                                            <th>Deposit Slip Date</th>
                                            <th>Deposit Slip No.</th>
                                            <th>Deposit Slip Title</th>
                                            <th>Account Title</th>
                                            <th>Account No.</th>
                                            <th>Cheque Date</th>
                                            <th>Cheque No.</th>
                                            <th>Amount</th>
                                            <th>Post</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php foreach($account_posting_slips as $slip): ?>
                                        <tr>
                                            <td><?php echo $slip['payroll_date']; ?></td>
                                            <td><?php echo $slip['deposit_slip_date']; ?></td>
                                            <td><?php echo $slip['deposit_slip_no']; ?></td>
                                            <td><?php echo $slip['deposit_slip_title']; ?></td>
                                            <td><?php echo $slip['account_title']; ?></td>
                                            <td><?php echo $slip['account_no']; ?></td>
                                            <td><?php echo $slip['cheque_date']; ?></td>
                                            <td><?php echo $slip['cheque_no']; ?></td>
                                            <td><?php echo $slip['cheque_amount']; ?></td>
                                            <td><?php echo $slip['post']; ?></td>
                                        </tr>
                                        <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div id="divLedger" class="table-responsive">
                                    <?php if($is_edit==1): ?>
                                    <table class="table table-striped">
                                        <thead>
                                        <tr><th colspan="17">Account Entry</th></tr>
                                        <tr>
                                            <th>PayDate</th>
                                            <th>SysKey</th>
                                            <th>SysTag</th>
                                            <th>Year</th>
                                            <th>Comp</th>
                                            <th>PartyID</th>
                                            <th>Party</th>
                                            <th>trans_type</th>
                                            <th>BAHKey</th>
                                            <th>AHKey</th>
                                            <th>CCKey</th>
                                            <th>BudKey</th>
                                            <th>Narr</th>
                                            <th>Ref</th>
                                            <th>taxType</th>
                                            <th>Pamount</th>
                                            <th>Bamount</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php foreach($account_posting_ledgers as $ledger): ?>
                                        <tr>
                                            <th><?php echo $ledger['PayDate']; ?></th>
                                            <th><?php echo $ledger['SysKey']; ?></th>
                                            <th><?php echo $ledger['SysTag']; ?></th>
                                            <th><?php echo $ledger['Year']; ?></th>
                                            <th><?php echo $ledger['Comp']; ?></th>
                                            <th><?php echo $ledger['PartyID']; ?></th>
                                            <th><?php echo $ledger['Party']; ?></th>
                                            <th><?php echo $ledger['trans_type']; ?></th>
                                            <th><?php echo $ledger['BAHKey']; ?></th>
                                            <th><?php echo $ledger['AHKey']; ?></th>
                                            <th><?php echo $ledger['CCKey']; ?></th>
                                            <th><?php echo $ledger['BudKey']; ?></th>
                                            <th><?php echo $ledger['Narr']; ?></th>
                                            <th><?php echo $ledger['Ref']; ?></th>
                                            <th><?php echo $ledger['taxType']; ?></th>
                                            <th><?php echo $ledger['Pamount']; ?></th>
                                            <th><?php echo $ledger['Bamount']; ?></th>
                                        </tr>
                                        <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div id="divBudget" class="table-responsive">
                                    <?php if($is_edit==1): ?>
                                    <table class="table table-striped">
                                        <thead>
                                        <tr><th colspan="6">Budget Entry</th></tr>
                                        <tr>
                                            <th>Comp</th>
                                            <th>Year</th>
                                            <th>BudKey</th>
                                            <th>Ref</th>
                                            <th>budAmount</th>
                                            <th>Status</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php foreach($account_posting_budgets as $budget): ?>
                                        <tr>
                                            <td><?php echo $budget['Comp']; ?></td>
                                            <td><?php echo $budget['Year']; ?></td>
                                            <td><?php echo $budget['BudKey']; ?></td>
                                            <td><?php echo $budget['Ref']; ?></td>
                                            <td><?php echo $budget['budAmount']; ?></td>
                                            <td><?php echo $budget['Status']; ?></td>
                                        </tr>
                                        <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="box-footer">
                    <div class="pull-right">
                        <?php if($is_edit!=1): ?>
                        <a class="btn btn-primary" href="javascript:void(0);" onclick="$('#form').submit();">
                            <i class="fa fa-floppy-o"></i>
                            &nbsp;<?php echo $lang['save']; ?>
                        </a>
                        <?php endif; ?>
                        <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                            <i class="fa fa-undo"></i>
                            &nbsp;<?php echo $lang['cancel']; ?>
                        </a>

                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
</div>
<link rel="stylesheet" href="plugins/dataTables/dataTables.bootstrap.css">
<script src="plugins/dataTables/jquery.dataTables.js"></script>
<script src="plugins/dataTables/dataTables.bootstrap.js"></script>
<script type="text/javascript" src="plugins/dataTables/extensions/FixedColumns/js/dataTables.fixedColumns.min.js"></script>
<script type="text/javascript" src="plugins/validate/jquery.validate.min.js"></script>
<script>
    jQuery('#form').validate(<?php echo $strValidation; ?>);

    var $URLGetData = '<?php echo $href_get_data; ?>';
</script>
<script type="text/javascript" src="../admin/view/js/payroll/account_posting.js"></script>
<?php echo $page_footer; ?>
<?php echo $column_right; ?>
</div><!-- ./wrapper -->
<?php echo $footer; ?>
</body>
</html>