<!DOCTYPE html>
<html>
<?php echo $header; ?>
<body class="hold-transition skin-blue sidebar-mini sidebar-collapse">
<div class="wrapper">
    <?php echo $page_header; ?>
    <?php echo $column_left; ?>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1><?php echo $lang['heading_title']; ?></h1>
            <div class="row">
                <div class="col-sm-6">
                    <ol class="breadcrumb">
                        <?php foreach($breadcrumbs as $breadcrumb): ?>
                        <li>
                            <a href="<?php echo $breadcrumb['href']; ?>">
                                <i class="<?php echo $breadcrumb['class']; ?>"></i>
                                <?php echo $breadcrumb['text']; ?>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ol>
                </div>
                <div class="col-sm-6">
                    <div class="pull-right">
                        <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                            <i class="fa fa-undo"></i>
                            &nbsp;<?php echo $lang['cancel']; ?>
                        </a>
                        <a class="btn btn-primary" href="javascript:void(0);" onclick="$('#form').submit();">
                            <i class="fa fa-floppy-o"></i>
                            &nbsp;<?php echo $lang['save']; ?>
                        </a>
                    </div>
                </div>
            </div>
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-sm-12">
                    <div class="box">
                        <div class="box-header">
                            <?php if ($error_warning) { ?>
                            <div class="alert alert-danger alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $error_warning; ?>
                            </div>
                            <?php } ?>
                            <?php  if ($success) { ?>
                            <div class="alert alert-success alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $success; ?>
                            </div>
                            <?php  } ?>
                        </div><!-- /.box-header -->
                        <div class="box-body">
                            <form action="<?php echo $action_save; ?>" method="post" enctype="multipart/form-data" id="form">
                                <div class="row">
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['date']; ?></label>
                                            <input type="text" id="date" name="date" value="<?php echo $date; ?>" class="form-control dtpDate"/>
                                        </div>
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['employee']; ?></label>
                                            <select id="employee_registration_id" name="employee_registration_id" class="form-control">
                                                <option value="" data-employee_id="" data-registration_code="" data-employee_code="">&nbsp;</option>
                                                <?php foreach($employees as $employee): ?>
                                                <option data-employee_id="<?php echo $employee['employee_id'];?>" data-registration_code="<?php echo $employee['registration_code'];?>" data-employee_code="<?php echo $employee['employee_code'];?>" value="<?php echo $employee['employee_registration_id']; ?>" <?php echo ($employee['employee_registration_id']==$employee_registration_id?'selected="true"':''); ?>><?php echo $employee['employee_name']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <label class="error" for="employee_registration_id" style="display: none;">&nbsp;</label>
                                            <input type="hidden" id="registration_code" name="registration_code" value="<?php echo $registration_code; ?>" />
                                            <input type="hidden" id="employee_id" name="employee_id" value="<?php echo $employee_id; ?>" />
                                            <input type="hidden" id="employee_code" name="employee_code" value="<?php echo $employee_code; ?>" />
                                        </div>
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['amount']; ?></label>
                                            <input type="text" id="amount" name="amount" value="<?php echo $amount; ?>" class="form-control"/>
                                        </div>
                                        <div class="form-group">
                                            <label><span class="required">&nbsp;</span>&nbsp;<?php echo $lang['description']; ?></label>
                                            <textarea class="form-control" id="description" name="description" rows="3"><?php echo $description; ?></textarea>
                                        </div>
                                    </div>
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['bank_account']; ?></label>
                                            <select id="company_account_id" name="company_account_id" class="form-control">
                                                <option value="">&nbsp;</option>
                                                <?php foreach($company_accounts as $account): ?>
                                                <option value="<?php echo $account['company_account_id']; ?>" <?php echo ($account['company_account_id']==$company_account_id?'selected="true"':''); ?>><?php echo $account['account_title']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <label for="company_account_id" class="error"></label>
                                        </div>
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['cheque_date']; ?></label>
                                            <input type="text" id="cheque_date" name="cheque_date" value="<?php echo $cheque_date; ?>" class="form-control dtpDate"/>
                                        </div>
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['cheque_no']; ?></label>
                                            <input type="text" id="cheque_no" name="cheque_no" value="<?php echo $cheque_no; ?>" class="form-control"/>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="box-footer">
                            <div class="pull-right">
                                <a class="btn btn-primary" href="javascript:void(0);" onclick="$('#form').submit();">
                                    <i class="fa fa-floppy-o"></i>
                                    &nbsp;<?php echo $lang['save']; ?>
                                </a>
                                <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                                    <i class="fa fa-undo"></i>
                                    &nbsp;<?php echo $lang['cancel']; ?>
                                </a>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <script type="text/javascript" src="plugins/validate/jquery.validate.min.js"></script>
    <script>
        jQuery('#form').validate(<?php echo $strValidation; ?>);

        $(document).on('change','#employee_registration_id',function() {
            var $data = $('#employee_registration_id option:selected').data();
            $('#registration_code').val($data['registration_code']);
            $('#employee_code').val($data['employee_code']);
            $('#employee_id').val($data['employee_id']);

        });
    </script>
    <?php echo $page_footer; ?>
    <?php echo $column_right; ?>
</div><!-- ./wrapper -->
<?php echo $footer; ?>
</body>
</html>