<!DOCTYPE html>
<html>
<?php echo $header; ?>
<body class="hold-transition skin-blue sidebar-mini sidebar-collapse">
<div class="wrapper">
    <?php echo $page_header; ?>
    <?php echo $column_left; ?>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1><?php echo $lang['heading_title']; ?></h1>
            <div class="row">
                <div class="col-sm-6">
                    <ol class="breadcrumb">
                        <?php foreach($breadcrumbs as $breadcrumb): ?>
                        <li>
                            <a href="<?php echo $breadcrumb['href']; ?>">
                                <i class="<?php echo $breadcrumb['class']; ?>"></i>
                                <?php echo $breadcrumb['text']; ?>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ol>
                </div>
                <div class="col-sm-6">
                    <div class="pull-right">
                        <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                            <i class="fa fa-undo"></i>
                            &nbsp;<?php echo $lang['cancel']; ?>
                        </a>
                        <?php if($is_post != 1): ?>
                        <a class="btn btn-primary" href="javascript:void(0);" onclick="$('#form').submit();">
                            <i class="fa fa-floppy-o"></i>
                            &nbsp;<?php echo $lang['save']; ?>
                        </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-sm-12">
                    <div class="box">
                        <div class="box-header">
                            <?php if ($error_warning) { ?>
                            <div class="alert alert-danger alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $error_warning; ?>
                            </div>
                            <?php } ?>
                            <?php  if ($success) { ?>
                            <div class="alert alert-success alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $success; ?>
                            </div>
                            <?php  } ?>
                        </div><!-- /.box-header -->
                        <div class="box-body">
                            <form action="<?php echo $action_save; ?>" method="post" enctype="multipart/form-data" id="form">
                                <div class="row">
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['document_no']; ?></label>
                                            <input type="text" id="document_identity" name="document_identity" value="<?php echo $document_identity; ?>" class="form-control" readonly/>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['document_date']; ?></label>
                                            <input type="text" id="document_date" name="document_date" value="<?php echo $document_date; ?>" class="form-control dtpDate"/>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['document_title']; ?></label>
                                            <input type="text" id="document_title" name="document_title" value="<?php echo $document_title; ?>" class="form-control"/>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['pay_from']; ?></label>
                                            <select class="form-control" id="pay_from_company_id" name="pay_from_company_id">
                                                <option value="">&nbsp;</option>
                                                <?php foreach($companies as $company): ?>
                                                <option <?php echo ($pay_from_company_id==$company['company_id']?'selected="true"':''); ?> value="<?php echo $company['company_id']; ?>"><?php echo $company['company_name']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <label for="pay_from_company_id" class="error" style="display: none;"></label>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['bank_name']; ?></label>
                                            <select class="form-control" id="company_account_id" name="company_account_id">
                                                <option value="">&nbsp;</option>
                                                <?php foreach($company_accounts as $account): ?>
                                                <option <?php echo ($company_account_id==$account['company_account_id']?'selected="true"':''); ?> value="<?php echo $account['company_account_id']; ?>"><?php echo $account['account_title'] . ' ['.$account['bank_name'].' - '.$account['account_no'].']'; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <label for="company_account_id" class="error" style="display: none;"></label>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['from_allowance_date']; ?></label>
                                            <input type="text" id="from_allowance_date" name="from_allowance_date" value="<?php echo $from_allowance_date; ?>" class="form-control dtpDate"/>
                                        </div>
                                    </div>
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['to_allowance_date']; ?></label>
                                            <input type="text" id="to_allowance_date" name="to_allowance_date" value="<?php echo $to_allowance_date; ?>" class="form-control dtpDate"/>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><span class="required">&nbsp;&nbsp;</span>&nbsp;<?php echo $lang['allowance_type']; ?></label>
                                            <select class="form-control" id="special_allowance_type_id" name="special_allowance_type_id">
                                                <option value="">&nbsp;</option>
                                                <?php foreach($special_allowance_types as $special_allowance_type): ?>
                                                <option value="<?php echo $special_allowance_type['special_allowance_type_id']; ?>" <?php echo ($special_allowance_type_id==$special_allowance_type['special_allowance_type_id']?'selected="true"':''); ?>><?php echo $special_allowance_type['special_allowance_type']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <label for="special_allowance_type_id" class="error" style="display: none;">&nbsp;</label>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><span class="required">&nbsp;&nbsp;</span>&nbsp;<?php echo $lang['department']; ?></label>
                                            <select class="form-control" id="department_id" name="department_id[]" multiple>
                                                <?php foreach($departments as $department): ?>
                                                <option value="<?php echo $department['department_id']; ?>" <?php echo ($department_id==$department['department_id']?'selected="true"':''); ?>><?php echo $department['department_name']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label>&nbsp;</label>
                                            <button type="button" class="btn btn-info form-control" id="btnSearch">Search</button>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="table-responsive">
                                            <table id="tblAllowances" class="table table-striped">
                                                <thead>
                                                <tr>
                                                    <th>&nbsp;</th>
                                                    <th><?php echo $lang['sno']; ?></th>
                                                    <th><?php echo $lang['document_no']; ?></th>
                                                    <th><?php echo $lang['reg_code']; ?></th>
                                                    <th><?php echo $lang['employee_name']; ?></th>
                                                    <th><?php echo $lang['cheque_date']; ?></th>
                                                    <th><?php echo $lang['cheque_no']; ?></th>
                                                    <th><?php echo $lang['amount']; ?></th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                <?php foreach($details as $row_no=>$allowance): ?>
                                                <tr>
                                                    <td><button type="button" class="btn btn-danger btn-xs" onclick="removeRow(this);"><i class="fa fa-times"></i></button></td>
                                                    <td><?php echo $row_no+1; ?></td>
                                                    <td><?php echo $allowance['document_identity']; ?></td>
                                                    <td>
                                                        <input type="hidden" name="allowances[<?php echo $row_no; ?>][special_allowance_id]" value="<?php echo $allowance['special_allowance_id']; ?>" />
                                                        <?php echo $allowance['registration_code']; ?>
                                                    </td>
                                                    <td><?php echo $allowance['employee_name']; ?></td>
                                                    <td>
                                                        <input type="text" class="form-control dtpDate" name="allowances[<?php echo $row_no; ?>][cheque_date]" value="<?php echo $allowance['cheque_date']; ?>"/>
                                                    </td>
                                                    <td>
                                                        <input type="text" class="form-control" name="allowances[<?php echo $row_no; ?>][cheque_no]" value="<?php echo $allowance['cheque_no']; ?>"/>
                                                        </td>
                                                    <td>
                                                        <input type="text" class="form-control text-right amount" name="allowances[<?php echo $row_no; ?>][amount]" value="<?php echo $allowance['amount']; ?>" readonly/>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-offset-9 col-sm-3">
                                        <div class="form-group">
                                            <label><?php echo $lang['total_amount']; ?></label>
                                            <input type="text" class="form-control text-right" id="total_amount" name="total_amount" value="<?php echo $total_amount; ?>" readonly/>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="box-footer">
                            <div class="pull-right">
                                <a class="btn btn-primary" href="javascript:void(0);" onclick="$('#form').submit();">
                                    <i class="fa fa-floppy-o"></i>
                                    &nbsp;<?php echo $lang['save']; ?>
                                </a>
                                <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                                    <i class="fa fa-undo"></i>
                                    &nbsp;<?php echo $lang['cancel']; ?>
                                </a>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <script type="text/javascript" src="../admin/view/js/payroll/allowance_posting.js"></script>
    <script type="text/javascript" src="plugins/validate/jquery.validate.min.js"></script>
    <script>
        var $URLGetAllowances = '<?php echo $href_get_allowances; ?>';
        var $company_accounts = <?php echo json_encode($company_accounts); ?>;
        jQuery('#form').validate(<?php echo $strValidation; ?>);
    </script>
    <?php echo $page_footer; ?>
    <?php echo $column_right; ?>
</div><!-- ./wrapper -->
<?php echo $footer; ?>
</body>
</html>