<!DOCTYPE html>
<html>
<?php echo $header; ?>
<body class="hold-transition skin-blue sidebar-mini sidebar-collapse">
<div class="wrapper">
    <?php echo $page_header; ?>
    <?php echo $column_left; ?>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1><?php echo $lang['heading_title']; ?></h1>
            <div class="row">
                <div class="col-sm-6">
                    <ol class="breadcrumb">
                        <?php foreach($breadcrumbs as $breadcrumb): ?>
                        <li>
                            <a href="<?php echo $breadcrumb['href']; ?>">
                                <i class="<?php echo $breadcrumb['class']; ?>"></i>
                                <?php echo $breadcrumb['text']; ?>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ol>
                </div>
                <div class="col-sm-6">
                    <div class="pull-right">
                        <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                            <i class="fa fa-undo"></i>
                            &nbsp;<?php echo $lang['cancel']; ?>
                        </a>
                        <?php if($is_post != 1): ?>
                        <a class="btn btn-primary" href="javascript:void(0);" onclick="$('#form').submit();">
                            <i class="fa fa-floppy-o"></i>
                            &nbsp;<?php echo $lang['save']; ?>
                        </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-sm-12">
                    <div class="box">
                        <div class="box-header">
                            <?php if ($error_warning) { ?>
                            <div class="alert alert-danger alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $error_warning; ?>
                            </div>
                            <?php } ?>
                            <?php  if ($success) { ?>
                            <div class="alert alert-success alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $success; ?>
                            </div>
                            <?php  } ?>
                        </div><!-- /.box-header -->
                        <div class="box-body">
                            <form action="<?php echo $action_save; ?>" method="post" enctype="multipart/form-data" id="form">
                                <div class="row">
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['document_no']; ?></label>
                                            <input type="text" id="document_identity" name="document_identity" value="<?php echo $document_identity; ?>" class="form-control" readonly/>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['document_date']; ?></label>
                                            <input type="text" id="document_date" name="document_date" value="<?php echo $document_date; ?>" class="form-control" readonly/>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['document_title']; ?></label>
                                            <input type="text" id="document_title" name="document_title" value="<?php echo $document_title; ?>" class="form-control" readonly/>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['bank_name']; ?></label>
                                            <select class="form-control" id="company_account_id" name="company_account_id" disabled>
                                                <option value="">&nbsp;</option>
                                                <?php foreach($company_accounts as $account): ?>
                                                <option <?php echo ($company_account_id==$account['company_account_id']?'selected="true"':''); ?> value="<?php echo $account['company_account_id']; ?>"><?php echo $account['account_title'] . ' ['.$account['bank_name'].' - '.$account['account_no'].']'; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <label for="company_account_id" class="error" style="display: none;"></label>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['from_allowance_date']; ?></label>
                                            <input type="text" id="from_allowance_date" name="from_allowance_date" value="<?php echo $from_allowance_date; ?>" class="form-control" readonly/>
                                        </div>
                                    </div>
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label><span class="required">*</span>&nbsp;<?php echo $lang['to_allowance_date']; ?></label>
                                            <input type="text" id="to_allowance_date" name="to_allowance_date" value="<?php echo $to_allowance_date; ?>" class="form-control" readonly/>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><span class="required">&nbsp;&nbsp;</span>&nbsp;<?php echo $lang['allowance_type']; ?></label>
                                            <select class="form-control" id="special_allowance_type_id" name="special_allowance_type_id" disabled>
                                                <option value="">&nbsp;</option>
                                                <?php foreach($special_allowance_types as $special_allowance_type): ?>
                                                <option value="<?php echo $special_allowance_type['special_allowance_type_id']; ?>" <?php echo ($special_allowance_type_id==$special_allowance_type['special_allowance_type_id']?'selected="true"':''); ?>><?php echo $special_allowance_type['special_allowance_type']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <label for="special_allowance_type_id" class="error" style="display: none;">&nbsp;</label>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label><span class="required">&nbsp;&nbsp;</span>&nbsp;<?php echo $lang['department']; ?></label>
                                            <select class="form-control" id="department_id" name="department_id[]" multiple disabled>
                                                <?php foreach($departments as $department): ?>
                                                <option value="<?php echo $department['department_id']; ?>" <?php echo ($department_id==$department['department_id']?'selected="true"':''); ?>><?php echo $department['department_name']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label>&nbsp;</label>
                                            <button type="button" class="btn btn-info form-control" id="btnSearch">Search</button>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="table-responsive">
                                            <table id="tblAllowances" class="table table-striped">
                                                <thead>
                                                <tr>
                                                    <th>&nbsp;</th>
                                                    <th><?php echo $lang['sno']; ?></th>
                                                    <th><?php echo $lang['document_no']; ?></th>
                                                    <th><?php echo $lang['reg_code']; ?></th>
                                                    <th><?php echo $lang['employee_name']; ?></th>
                                                    <th><?php echo $lang['cheque_date']; ?></th>
                                                    <th><?php echo $lang['cheque_no']; ?></th>
                                                    <th><?php echo $lang['amount']; ?></th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                <?php foreach($details as $row_no=>$allowance): ?>
                                                <tr>
                                                    <td><button type="button" class="btn btn-danger btn-xs" onclick="removeRow(this);"><i class="fa fa-times"></i></button></td>
                                                    <td><?php echo $row_no+1; ?></td>
                                                    <td><?php echo $allowance['special_allowance_identity']; ?></td>
                                                    <td>
                                                        <?php echo $allowance['registration_code']; ?>
                                                    </td>
                                                    <td><?php echo $allowance['employee_name']; ?></td>
                                                    <td><?php echo $allowance['cheque_date']; ?></td>
                                                    <td><?php echo $allowance['cheque_no']; ?></td>
                                                    <td><?php echo $allowance['amount']; ?></td>
                                                </tr>
                                                <?php endforeach; ?>
                                                </tbody>
                                                <tfoot>
                                                <tr>
                                                    <td colspan="6" class="text-right">Total:</td>
                                                    <td class="text-right"><?php echo $total_amount; ?></td>
                                                </tr>
                                                </tfoot>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <label>Pay From</label>
                                            <select class="form-control" id="pay_from_company_id" name="pay_from_company_id">
                                                <option value="">&nbsp;</option>
                                                <?php foreach($companies as $company): ?>
                                                <option <?php echo ($company['company_id']==$pay_from_company_id?'selected':'');?> value="<?php echo $company['company_id']; ?>" data-ref_id="<?php echo $company['ref_id']; ?>"><?php echo $company['company_name']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="table-responsive">
                                            <table class="table table-bordered">
                                                <thead>
                                                <tr>
                                                    <th>PayDate</th>
                                                    <th>SysKey</th>
                                                    <th>SysTag</th>
                                                    <th>TranCategory</th>
                                                    <th>Year</th>
                                                    <th>Comp</th>
                                                    <th>PartyID</th>
                                                    <th>Party</th>
                                                    <th>tran_type</th>
                                                    <th>BAHKey</th>
                                                    <th>AHKey</th>
                                                    <th>CCKey</th>
                                                    <th>BudKey</th>
                                                    <th>Narr</th>
                                                    <th>Ref</th>
                                                    <th>taxType</th>
                                                    <th>Pamount</th>
                                                    <th>Bamount</th>
                                                    <th>Ctrl_No</th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                <?php foreach($posting_details as $row_id=>$detail): ?>
                                                <tr>
                                                    <td class="text-center"><input type="text" class="form-control" name="account_details[<?php echo $row_id; ?>][PayDate]" value="<?php echo $detail['PayDate']; ?>" /></td>
                                                    <td class="text-center"><input type="text" class="form-control" name="account_details[<?php echo $row_id; ?>][Syskey]" value="<?php echo $detail['SysKey']; ?>" /></td>
                                                    <td class="text-center"><input type="text" class="form-control" name="account_details[<?php echo $row_id; ?>][SysTag]" value="<?php echo $detail['SysTag']; ?>" /></td>
                                                    <td class="text-center"><input type="text" class="form-control" name="account_details[<?php echo $row_id; ?>][TranCategory]" value="<?php echo $detail['TranCategory']; ?>" /></td>
                                                    <td class="text-center"><input type="text" class="form-control" name="account_details[<?php echo $row_id; ?>][Year]" value="<?php echo $detail['Year']; ?>" /></td>
                                                    <td class="text-center"><input type="text" class="form-control comp" name="account_details[<?php echo $row_id; ?>][Comp]" value="<?php echo $detail['Comp']; ?>" readonly/></td>
                                                    <td class="text-center"><input type="text" class="form-control" name="account_details[<?php echo $row_id; ?>][PartyID]" value="<?php echo $detail['PartyID']; ?>" /></td>
                                                    <td class="text-center"><input type="text" class="form-control" name="account_details[<?php echo $row_id; ?>][Party]" value="<?php echo $detail['Party']; ?>" /></td>
                                                    <td class="text-center"><input type="text" class="form-control" name="account_details[<?php echo $row_id; ?>][tran_type]" value="<?php echo $detail['tran_type']; ?>" /></td>
                                                    <td class="text-center"><input type="text" class="form-control" name="account_details[<?php echo $row_id; ?>][BAHKey]" value="<?php echo $detail['BAHKey']; ?>" /></td>
                                                    <td class="text-center"><input type="text" class="form-control" name="account_details[<?php echo $row_id; ?>][AHKey]" value="<?php echo $detail['AHKey']; ?>" /></td>
                                                    <td class="text-center"><input type="text" class="form-control" name="account_details[<?php echo $row_id; ?>][CCKey]" value="<?php echo $detail['CCKey']; ?>" /></td>
                                                    <td class="text-center"><input type="text" class="form-control" name="account_details[<?php echo $row_id; ?>][BudKey]" value="<?php echo $detail['BudKey']; ?>" /></td>
                                                    <td class="text-center"><input type="text" class="form-control" name="account_details[<?php echo $row_id; ?>][Narr]" value="<?php echo $detail['Narr']; ?>" /></td>
                                                    <td class="text-center"><input type="text" class="form-control" name="account_details[<?php echo $row_id; ?>][Ref]" value="<?php echo $detail['Ref']; ?>" /></td>
                                                    <td class="text-center"><input type="text" class="form-control" name="account_details[<?php echo $row_id; ?>][taxType]" value="<?php echo $detail['taxType']; ?>" /></td>
                                                    <td class="text-center"><input type="text" class="form-control" name="account_details[<?php echo $row_id; ?>][Pamount]" value="<?php echo $detail['Pamount']; ?>" /></td>
                                                    <td class="text-center"><input type="text" class="form-control" name="account_details[<?php echo $row_id; ?>][Bamount]" value="<?php echo $detail['Bamount']; ?>" /></td>
                                                    <td class="text-center"><input type="text" class="form-control" name="account_details[<?php echo $row_id; ?>][Ctrl_No]" value="<?php echo $detail['Ctrl_No']; ?>" /></td>
                                                </tr>
                                                <?php endforeach; ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div id="divBudget" class="table-responsive">
                                            <table class="table table-striped">
                                                <thead>
                                                <tr><th colspan="6">Budget Entry</th></tr>
                                                <tr>
                                                    <th>Comp</th>
                                                    <th>Year</th>
                                                    <th>BudKey</th>
                                                    <th>Ref</th>
                                                    <th>budAmount</th>
                                                    <th>Status</th>
                                                    <th>PartyID</th>
                                                    <th>AHKey</th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                <?php $row_id =0; ?>
                                                <?php foreach($budgets as $budget): ?>
                                                <tr>
                                                    <td class="text-center"><input type="text" class="form-control comp" name="budgets[<?php echo $row_id; ?>][Comp]" value="<?php echo $budget['Comp']; ?>" /></td>
                                                    <td class="text-center"><input type="text" class="form-control" name="budgets[<?php echo $row_id; ?>][Year]" value="<?php echo $budget['Year']; ?>" /></td>
                                                    <td class="text-center"><input type="text" class="form-control" name="budgets[<?php echo $row_id; ?>][BudKey]" required="true" onfocusout="check(this);" value="<?php echo $budget['BudKey']; ?>" /></td>
                                                    <td class="text-center"><input type="text" class="form-control" name="budgets[<?php echo $row_id; ?>][Ref]" value="<?php echo $budget['Ref']; ?>" /></td>
                                                    <td class="text-center"><input type="text" class="form-control" name="budgets[<?php echo $row_id; ?>][budAmt]" value="<?php echo $budget['budAmount']; ?>" /></td>
                                                    <td class="text-center"><input type="text" class="form-control" name="budgets[<?php echo $row_id; ?>][Status]" value="<?php echo $budget['Status']; ?>" /></td>
                                                    <td class="text-center"><input type="text" class="form-control" name="budgets[<?php echo $row_id; ?>][PartyID]" value="<?php echo $budget['PartyID']; ?>" /></td>
                                                    <td class="text-center"><input type="text" class="form-control" name="budgets[<?php echo $row_id; ?>][AHKey]" value="<?php echo $budget['AHKey']; ?>" /></td>
                                                </tr>
                                                <?php $row_id++; ?>
                                                <?php endforeach; ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="box-footer">
                            <div class="pull-right">
                                <a class="btn btn-primary" href="javascript:void(0);" onclick="$('#form').submit();">
                                    <i class="fa fa-floppy-o"></i>
                                    &nbsp;<?php echo $lang['save']; ?>
                                </a>
                                <a class="btn btn-default" href="<?php echo $action_cancel; ?>">
                                    <i class="fa fa-undo"></i>
                                    &nbsp;<?php echo $lang['cancel']; ?>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <script type="text/javascript" src="../admin/view/js/payroll/allowance_posting.js"></script>
    <script type="text/javascript" src="plugins/validate/jquery.validate.min.js"></script>
    <script>
        jQuery('#form').validate(<?php echo $strValidation; ?>);

        $(document).on('change','#pay_from_company_id', function() {
            var $ref_id = $('#pay_from_company_id option:selected').data('ref_id');
            $('.comp').val($ref_id);
        });
    </script>
    <?php echo $page_footer; ?>
    <?php echo $column_right; ?>
</div><!-- ./wrapper -->
<?php echo $footer; ?>
</body>
</html>