<!DOCTYPE html>
<html>
<?php echo $header; ?>
<body class="hold-transition skin-blue sidebar-mini sidebar-collapse">
<div class="wrapper">
    <?php echo $page_header; ?>
    <?php echo $column_left; ?>
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1><?php echo $lang['heading_title']; ?></h1>
            <div class="row">
                <div class="col-sm-6">
                    <ol class="breadcrumb">
                        <?php foreach($breadcrumbs as $breadcrumb): ?>
                        <li>
                            <a href="<?php echo $breadcrumb['href']; ?>">
                                <i class="<?php echo $breadcrumb['class']; ?>"></i>
                                <?php echo $breadcrumb['text']; ?>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ol>
                </div>
            </div>
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-sm-12">
                    <div class="box">
                        <div class="box-header box-default">
                            <?php if ($error_warning) { ?>
                            <div class="alert alert-danger alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $error_warning; ?>
                            </div>
                            <?php } ?>
                            <?php  if ($success) { ?>
                            <div class="alert alert-success alert-dismissable">
                                <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
                                <?php echo $success; ?>
                            </div>
                            <?php  } ?>
                            <form action="<?php echo $href_print_report; ?>" target="_blank" method="post" enctype="multipart/form-data" id="form">
                                <div class="row">
                                    <div class="col-sm-3">
                                        <div id="_available_column" class="panel panel-default">
                                            <div class="panel-heading">
                                                <label class="panel-title">Available Column</label>
                                            </div>
                                            <div class="panel-body list-group" style="height: 200px; overflow-y: auto;">
                                                <?php foreach($columns as $column): ?>
                                                <a class="list-group-item" data-column_name="<?php echo $column['column_name']; ?>" data-display_name="<?php echo $column['display_name']; ?>" data-column_ratio="<?php echo $column['column_ratio']; ?>" href="javascript:void(0);">
                                                    <span onclick="fnAddToList(this);" class="badge bg-yellow"><i class="fa fa-arrow-right"></i></span>
                                                    <p class="list-group-item-text"><?php echo $column['display_name']; ?></p>
                                                </a>
                                                <?php endforeach; ?>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-4">
                                        <div id="_display_column" class="panel panel-default">
                                            <div class="panel-heading">
                                                <label class="panel-title">Display Column</label>
                                            </div>
                                            <div class="panel-body list-group" style="height: 200px; overflow-y: auto;">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div id="_load_report" class="panel panel-default">
                                            <div class="panel-heading">
                                                <label class="panel-title">Load Report</label>
                                            </div>
                                            <div class="panel-body list-group" style="height: 200px; overflow-y: auto;">
                                                <?php foreach($reports as $report): ?>
                                                <a class="list-group-item" data-report_criteria_id="<?php echo $report['report_criteria_id']; ?>" data-report_id="<?php echo $report['report_id']; ?>" href="javascript:void(0);">
                                                    <button onclick="removeReport(this)" class="btn btn-danger btn-xs pull-right">
                                                        <i class="fa fa-remove"></i>
                                                    </button>
                                                    <p class="list-group-item-text"><?php echo $report['report_title']; ?></p>
                                                </a>
                                                <?php endforeach; ?>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label>Report Title</label>
                                            <input type="text" class="form-control" id="report_title" name="report_title" value="" />
                                            <input type="hidden" class="form-control" id="report_id" name="report_id" value="" />
                                        </div>
                                        <div class="form-group">
                                            <button id="btnSave" class="btn btn-info form-control" type="button">
                                                <i class="fa fa-save"></i>
                                                &nbsp;Save Report
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div><!-- /.box-header -->
                        <div class="box-body">
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="table-responsive">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <script type="text/javascript" src="../admin/view/js/payroll/bank_letter_custom_excel.js"></script>
    <script type="text/javascript">
        var $URLSaveFormat = '<?php echo $href_save_report; ?>';
        var $URLLoadFormats = '<?php echo $href_load_formats; ?>';
        var $URLRemoveFormat = '<?php echo $href_remove_format; ?>';
    </script>
    <?php echo $page_footer; ?>
    <?php echo $column_right; ?>
</div><!-- ./wrapper -->
<?php echo $footer; ?>
</body>
</html>